%This program produces descriptive figures of TIPS (Figures 2A-7A)
%When running this program need to update paths
%10/6/2009 cpflueger@hbs.edu

clear;

%load return data as produced from nominal_returns_UK.m
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\apr_09');
load MATLAB\inflation_bonds\apr_09\returnsUS10Y.mat

%Read in stock return index, dates are in 'date' format in Excel
[num, txt]=xlsread('C:\Documents and Settings\hbsuser\My Documents\RAwork\inflation_bonds\data_apr_09\MSCIData.xls',1);

stockheaders=1; %Row where stock index data starts
stockheaderstxt=11; %row where date data starts

%Read in vector of settlement dates
dates_stock=txt(:,1);
N=size(dates_stock,1);
dates_stock=dates_stock(stockheaderstxt:N);
dates_stock=datenum(dates_stock);

return_index_world=num(:,1);
return_index_US=num(:,2);

%now compute daily returns for stock indeces

[stock_return_US, dates_stock_return_US]=daily_returns(return_index_US,dates_stock);
[stock_return_world, dates_stock_return_world]=daily_returns(return_index_world,dates_stock);

%get nominal treasury data
load MATLAB\inflation_bonds\apr_09\nominal_US.mat
%Estimate daily returns
T10=size(nom10_yield,1);
nom10_return_test=zeros(T10,1);
dur=zeros(T10,1);
for t=2:T10
    %Estimate duration, coupon is paid semiannually
    Yt=nom10_yield(t-1)/200;
    Yplus=nom10_yield(t)/200;
    dur(t)=(1-(1+Yt)^(-20))/(1-(1+Yt)^-1);
    nom10_return_test(t)=(-dur(t)*log(1+Yplus)+dur(t)*log(1+Yt));
    test=(-10*log(1+nom10_yield(t)/100)+10*log(1+nom10_yield(t-1)/100));
    nom10_return_test(t)=exp(nom10_return_test(t))-1;
end
%corr(nom10_return, nom10_return_test) - this gives me a correlation of
%0.9885
nom10_return_test=nom10_return_test*252;
%For 10-year bond use estimated daily returns
nom10_return=nom10_return_test;
date_nom20_CRSP=date_nom;

%Get yield splices
load MATLAB\inflation_bonds\apr_09\splice_US10YR.mat
yield10=splice;
date10=days;
load MATLAB\inflation_bonds\apr_09\splice_US20YR.mat
yield20=splice;
date20=days;
startUS=729930; 
startUS1=729770;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Compute breakeven inflation rate
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
yield10nom=adjust_format(nom10_yield, date_nom10, yield10, date10);
yield20nom=adjust_format(nom20_yield, date_nom20, yield20, date20);
breakeven10=yield10nom-yield10;
breakeven20=yield20nom-yield20;
a=and(yield10nom>0,breakeven10<15);
breakeven10=breakeven10(a);
datebreakeven10=date10(a);

b=and(yield20nom>0,breakeven20<15);
breakeven20=breakeven20(b);
datebreakeven20=date20(b);

%Get actual inflation
[data, txt]=xlsread('C:\Documents and Settings\hbsuser\My Documents\RAwork\inflation_bonds\data_apr_09\daily_deflator_US',1);
%Compute year on year inflation 
dates_inflation=x2mdate(data(:,1));
CPI=data(:,2);
T=size(dates_inflation,1);
%Compute year on year inflation 
inflation=CPI;
for t=1:(T-24)
    inflation(t)=(CPI(t+24)-CPI(t))/CPI(t);
end
inflation2=(1/2)*inflation(1:T-24)*100; %Take average over 2 years - divide by 2
dates_inflation2=dates_inflation(1:T-24)+ones(T-24,1)*182; %Shift date so that it matches with moving average

inflation=CPI;
for t=1:(T-36)
    inflation(t)=(CPI(t+36)-CPI(t))/CPI(t);
end
inflation3=(1/3)*inflation(1:T-36)*100; %Take average over 3 years - divide by 3
dates_inflation3=dates_inflation(1:T-36)+ones(T-36,1)*181; %Shift date so that it matches with moving average

dates_inflation=x2mdate(data(:,1));
CPI=data(:,2);
T=size(dates_inflation,1);
%Compute year on year inflation 
inflation=CPI;
for t=1:(T-48)
    inflation(t)=(CPI(t+48)-CPI(t))/CPI(t);
end
inflation4=(1/4)*inflation(1:T-48)*100; %Take average over 2 years - divide by 2
dates_inflation4=dates_inflation(1:T-48)+ones(T-48,1)*182; %Shift date so that it matches with moving average


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Compute correlations
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Compute correlations stock returns, window=365 days
%10 Year TIPS
Y=3652; %10 year splice
[splice_ret, dates_ret, bond, retY, bound]=splice_returns(datepx,ret_nom, issue, mat,Y);
start_US=min(dates_ret);
end_US=max(dates_ret);
[dates_USstock_ret, newsplice_ret_US, newstock_return_US]=format_dates(dates_ret, dates_stock_return_US, splice_ret, stock_return_US);
[dates_worldstock_ret, newsplice_ret_world, newstock_return_world]=format_dates(dates_ret, dates_stock_return_world, splice_ret, stock_return_world);

window=365;
[mean1, meanUSstocks10, std1, std2, US10Ystock_corr, US10Ystock_beta, dates_US10Y_stock_corr]=beta_return_window(newsplice_ret_US,newstock_return_US,dates_USstock_ret, window);
[mean1, meanworldstocks10, std1, std2, world10Ystock_corr, world10Ystock_beta, dates_world10Y_stock_corr]=beta_return_window(newsplice_ret_world,newstock_return_world,dates_worldstock_ret, window);

%10 year nominal
[dates_nom_ret10, newsplice_nom_ret10, new_return_nom10]=format_dates(dates_ret, date_nom10, splice_ret, nom10_return/252);
%Only look at date range with TIPS data
a10=and(date_nom10>=start_US,date_nom10<=end_US);
dates_ret=date_nom10(a10);
splice_ret=nom10_return(a10)/252; %in data return already annualized
[dates_USstock_ret, newsplice_ret_US, newstock_return_US]=format_dates(dates_ret, dates_stock_return_US, splice_ret, stock_return_US);
[dates_worldstock_ret, newsplice_ret_world, newstock_return_world]=format_dates(dates_ret, dates_stock_return_world, splice_ret, stock_return_world);

window=365;
[mean1, mean2, std1, std2, US10Ystock_corr_nom, US10Ystock_beta_nom, dates_US10Y_stock_corr_nom]=beta_return_window(newsplice_ret_US,newstock_return_US,dates_USstock_ret, window);
[mean1, mean2, std1, std2,nom_corr10Y, nom_beta10Y, dates_10Ynom_corr]=beta_return_window(newsplice_nom_ret10,new_return_nom10,dates_nom_ret10, window);
[mean1, mean2, std1, std2, world10Ystock_corr_nom, world10Ystock_beta_nom, dates_world10Y_stock_corr_nom]=beta_return_window(newsplice_ret_world,newstock_return_world,dates_worldstock_ret, window);
[mean1, meannom10, std1, std2,nom_corr10Y, nom_beta10Y, dates_10Ynom_corr]=beta_return_window(newsplice_nom_ret10,new_return_nom10,dates_nom_ret10, window);

%20 year splice
Y=2*3652-20; 
[splice_ret, dates_ret, bond, retY, bound]=splice_returns(datepx,ret_nom, issue, mat,Y);
[dates_USstock_ret, newsplice_ret_US, newstock_return_US]=format_dates(dates_ret, dates_stock_return_US, splice_ret, stock_return_US);
[dates_worldstock_ret, newsplice_ret_world, newstock_return_world]=format_dates(dates_ret, dates_stock_return_world, splice_ret, stock_return_world);

window=365;
[mean1, meanUSstocks20, std1, std2, US20Ystock_corr, US20Ystock_beta, dates_US20Y_stock_corr]=beta_return_window(newsplice_ret_US,newstock_return_US,dates_USstock_ret, window);
[mean1, meanworldstocks20, std1, std2, world20Ystock_corr, world20Ystock_beta, dates_world20Y_stock_corr]=beta_return_window(newsplice_ret_world,newstock_return_world,dates_worldstock_ret, window);

%20 year nominal
[dates_nom_ret20, newsplice_nom_ret20, new_return_nom20]=format_dates(dates_ret, date_nom20_CRSP, splice_ret, nom20_return/252);
%Only look at date range with TIPS data
a20=and(date_nom20_CRSP>=start_US,date_nom20_CRSP<=end_US);
dates_ret=date_nom20_CRSP(a20);
splice_ret=nom20_return(a20)/252;

[dates_USstock_ret, newsplice_ret_US, newstock_return_US]=format_dates(dates_ret, dates_stock_return_US, splice_ret, stock_return_US);
[dates_worldstock_ret, newsplice_ret_world, newstock_return_world]=format_dates(dates_ret, dates_stock_return_world, splice_ret, stock_return_world);

window=365;
[mean1, mean2, std1, std2, US20Ystock_corr_nom, US20Ystock_beta_nom, dates_US20Y_stock_corr_nom]=beta_return_window(newsplice_ret_US,newstock_return_US,dates_USstock_ret, window);
[mean1, mean2, std1, std2, world20Ystock_corr_nom, world20Ystock_beta_nom, dates_world20Y_stock_corr_nom]=beta_return_window(newsplice_ret_world,newstock_return_world,dates_worldstock_ret, window);
[mean1, meannom20, std1, std2,nom_corr20Y, nom_beta20Y, dates_20Ynom_corr]=beta_return_window(newsplice_nom_ret20,new_return_nom20,dates_nom_ret20, window);


%Compute correlation of breakeven inflation with US stocks
%Compute correlation breakeven inflation with UK stocks - this is the beta
%and correlation with a portfolio that is long one nominal bond and short
%one real bond
window=365;
%compute 10 year real returns
Y=3652; %10 year splice real
[splice_ret, dates_ret, bond, retY, bound]=splice_maturity(datepx,ret_nom, issue, mat,Y);
%First bring nominal and real returns into the same format
[dates_stockbreakeven10, breakeven_return, breakeven_return_nom]=format_dates(dates_ret, date_nom10, splice_ret, nom10_return/252);
breakeven_return=breakeven_return_nom-breakeven_return;
[dates_stockbreakeven10, newsplice_breakeven10, newstock_breakeven_US]=format_dates(dates_stockbreakeven10, dates_stock_return_US, breakeven_return, stock_return_US);
[mean1, meanUSstockbreakeven10, std1, std2, stockbreakeven10_corr, stockbreakeven10_beta, dates_stockbreakeven10]=beta_return_window(newsplice_breakeven10,newstock_breakeven_US,dates_stockbreakeven10, window);

%Need to add path where I want to save pictures
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\real_yields\USplots\apr_09')
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 1a: Nominal yield and real yield
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
a=(date_nom10>=datenum([1992 9 25]));
%Don't begin plotting before startdate UK which is Sept 1992
plot(date_nom10(a), nom10_yield(a),'k','LineWidth',2);
hold on
%plot(date20, yield20,'k');
plot(date10, yield10,'--b','LineWidth',2);
%plot(date_nom20, nom20_yield, 'm');
hold off
axis([min(date10) max(date10) 0 10.5])
set(gca,'xtick',[726834 727564 728295 729025 729756 730486 731217 731947 732678 733408 734139])
line([startUS1 startUS1], [0 10.5],'color','k', 'Linestyle','--','LineWidth',2);
datetick('x',11,'keepticks')
legend('yield 10YR real', 'yield 10 YR nominal','Location','SouthWest');
title('US - real and nominal yields');
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\real_yields')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure1a_USyields_real_nominal.pdf')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure1a_USyields_real_nominal.eps')
pause();
plot_matrix1=horzcat(m2xdate(date_nom10(a)), nom10_yield(a));
plot_matrix2=horzcat(m2xdate(date10),yield10);
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix1, 1,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix2, 1,'C2');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 1b: Plot breakeven inflation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
a=(dates_inflation3>min(datebreakeven10));
plot(datebreakeven10, breakeven10,'k','LineWidth',2)
hold on
plot(dates_inflation3(a),inflation3(a),'--b','LineWidth',2)
hold off
legend('Breakeven inflation from 10YR real bonds', 'Realized inflation over next 3 years','Location', 'NorthEast')
axis([min(datebreakeven10) max(datebreakeven10) 0 6])
set(gca,'xtick',[726834 727564 728295 729025 729756 730486 731217 731947 732678 733408 734139])
line([startUS1 startUS1], [0 6],'color','k', 'Linestyle','--','LineWidth',2);
datetick('x',11,'keepticks')
title('Annualized US Breakeven inflation rate')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure1b_USbreakeven.pdf')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure1b_USbreakeven.eps')
pause()
plot_matrix1=horzcat(m2xdate(datebreakeven10), breakeven10);
plot_matrix2=horzcat(m2xdate(dates_inflation3(a)),inflation3(a));
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix1, 3,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix2, 3,'C2');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 2: Standard deviations of daily returns
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y=3652; %10 year splice real
[splice_ret, dates_ret, bond, retY, bound]=splice_maturity(datepx,ret_nom, issue, mat,Y);
window=365;
[std_splice10, mean_splice10, dates_std10, bond_std]=std_return_window_ann(splice_ret, bond, window,dates_ret);
% 10 year nominal
a10=and(date_nom10>=start_US,date_nom10<=end_US);
dates_ret=date_nom10(a10);
splice_ret=nom10_return(a10)/252; %in data return already annualized
[std_splice10_nom, mean_splice10_nom, dates_std10_nom, bond_std]=std_return_window_ann(splice_ret, dates_ret, window,dates_ret);

%Now make 20 year splices
Y=2*3652-20; %20 year splice real
[splice_ret, dates_ret, bond, retY, bound]=splice_maturity(datepx,ret_nom, issue, mat,Y);
window=365;
[std_splice20, mean_splice20, dates_std20, bond_std]=std_return_window_ann(splice_ret, bond, window,dates_ret);

% 20 year nominal
a20=and(date_nom20_CRSP>=start_US,date_nom20_CRSP<=end_US);
dates_ret=date_nom20_CRSP(a20);
splice_ret=nom20_return(a20)/252; %in data return already annualized
[std_splice20_nom, mean_splice20_nom, dates_std20_nom, bond_std]=std_return_window_ann(splice_ret, dates_ret, window,dates_ret);

plot(dates_std10,std_splice10,'k','LineWidth',2);
hold on
%plot(dates_std20, std_splice20,'k');
plot(dates_std10_nom, std_splice10_nom,'--b','LineWidth',2)
%plot(dates_std20_nom, std_splice20_nom,'m')
hold off
axis([min(dates_std10) max(dates_std10) 0 0.16])
set(gca,'xtick',[726834 727564 728295 729025 729756 730486 731217 731947 732678 733408 734139])
line([startUS startUS], [0 0.16],'color','k', 'Linestyle','--','LineWidth',2);
datetick('x',11,'keepticks')
legend('std 10YR real','std 10 YR nominal','Location','NorthWest');
title('US - std of daily holding returns of real and nominal bonds over 1 year moving window');
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\real_yields')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure2_USstd_real_nominal.pdf')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure2_USstd_real_nominal.eps')
pause();
plot_matrix1=horzcat(m2xdate(dates_std10), std_splice10);
plot_matrix2=horzcat(m2xdate(dates_std10_nom),std_splice10_nom);
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix1, 5,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix2, 5,'C2');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 3: Std of breakeven inflation rate, real/nominal correlation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Compute standard deviation of breakeven
[std_breakeven10, mean_breakeven10, dates_breakeven10, bond_std]=std_return_window_ann(breakeven10, breakeven10, window,datebreakeven10);
[std_breakeven20, mean_breakeven20, dates_breakeven20, bond_std]=std_return_window_ann(breakeven20, breakeven20, window,datebreakeven20);

plot(dates_breakeven10, std_breakeven10,'k','LineWidth',2);
hold on
%plot(dates_breakeven20, std_breakeven20,'k');
hold off
axis([min(dates_breakeven10) max(dates_breakeven10) -1 16])
line([startUS startUS], [-1 16],'color','k', 'Linestyle','--','LineWidth',2);
legend('std breakeven infl. 10YR bonds','Location','NorthWest');
set(gca,'xtick',[726834 727564 728295 729025 729756 730486 731217 731947 732678 733408 734139])
datetick('x',11,'keepticks')
ax1 = gca;
ax2 = axes('Position',get(ax1,'Position'),'YAxisLocation','right','Color','none','XColor','k','YColor','k');
hl3 = line(dates_10Ynom_corr, nom_corr10Y,'Color','b','LineStyle','--','LineWidth',2,'Parent',ax2);
%hl4 = line(dates_20Ynom_corr, nom_corr20Y,'Color','m','Parent', ax2);
axis(ax2,[min(dates_breakeven10) max(dates_breakeven10) -0.1 1.6])
set(gca,'xtick',[726834 727564 728295 729025 729756 730486 731217 731947 732678 733408 734139])
%line([startUS startUS], [-0.1 1.6],'color','k', 'Linestyle','--','LineWidth',2);
datetick(ax2,'x',11,'keepticks')
legend('Corr. daily returns 10YR real/nominal bonds ','Location', 'SouthEast');
title('Std. of US breakeven inflation and correlation between daily holding returns real/nominal bonds');
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure3_UScorr_real_nom.pdf')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure3_UScorr_real_nom.eps')
pause();
plot_matrix1=horzcat(m2xdate(dates_breakeven10), std_breakeven10);
plot_matrix2=horzcat(m2xdate(dates_10Ynom_corr),nom_corr10Y);
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix1, 7,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix2, 7,'C2');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 4: Correlations bonds internationally - see
%international_correlations and get 3day_return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 5: correlations with domestic stock market
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Only plot 10 year - makes it easier to compare
figure()
plot(dates_US10Y_stock_corr_nom, US10Ystock_corr_nom, 'k','LineWidth',2);
hold on;
%plot(dates_US20Y_stock_corr_nom, US20Ystock_corr_nom,'m','LineWidth',1);
plot(dates_US10Y_stock_corr, US10Ystock_corr, '--b','LineWidth',2);
%Switch sign of breakeven - rel returns minus nom returns
plot(dates_stockbreakeven10, -stockbreakeven10_corr,':r','LineWidth',2);
%plot(dates_US20Y_stock_corr, US20Ystock_corr,'k');
%plot(dates_US10Y_stock_corr, meanUSstocks10, 'Color', 'g');
hold off;
legend('Nominal 10YR', 'Real 10YR','Breakeven infl. from 10YR bonds','Location', 'NorthWest');
line([726834 max(dates_US10Y_stock_corr)], [0 0],'color','k', 'Linestyle','--','LineWidth',2);
axis([min(dates_US10Y_stock_corr) max(dates_US10Y_stock_corr) -0.7 0.7])
set(gca,'xtick',[726834 727564 728295 729025 729756 730486 731217 731947 732678 733408 734139])
line([startUS startUS], [-0.7 0.7],'color','k', 'Linestyle','--');
datetick('x',11,'keepticks')
title('Corr. daily return US real bonds,nominal bonds and breakeven inflation with US stock');
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure5_US_stockcorrelations.pdf')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure5_US_stockcorrelations.eps')
pause();
plot_matrix1=horzcat(m2xdate(dates_US10Y_stock_corr_nom), US10Ystock_corr_nom);
plot_matrix2=horzcat(m2xdate(dates_US10Y_stock_corr), US10Ystock_corr);
plot_matrix3=horzcat(m2xdate(dates_stockbreakeven10), -stockbreakeven10_corr);
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix1, 9,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix2, 9,'C2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix3, 9,'E2');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Figure 6a: betas of bonds with domestic stock market
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Only plot 10 year - makes it easier to compare
figure()
plot(dates_US10Y_stock_corr_nom, US10Ystock_beta_nom, 'k','LineWidth',2);
hold on;
%plot(dates_US20Y_stock_corr_nom, US20Ystock_corr_nom,'m','LineWidth',1);
plot(dates_US10Y_stock_corr, US10Ystock_beta, '--b','LineWidth',2);
plot(dates_stockbreakeven10, -stockbreakeven10_beta,':r','LineWidth',2);
%plot(dates_US20Y_stock_corr, US20Ystock_corr,'k');
%plot(dates_US10Y_stock_corr, meanUSstocks10, 'Color', 'g');
hold off;
legend('Nominal 10YR', 'Real 10YR','Breakeven inflation from 10YR bonds');
line([726834 max(dates_US10Y_stock_corr)], [0 0],'color','k', 'Linestyle','--','LineWidth',2);
axis([min(dates_US10Y_stock_corr) max(dates_US10Y_stock_corr) -0.6 0.6])
set(gca,'xtick',[726834 727564 728295 729025 729756 730486 731217 731947 732678 733408 734139])
line([startUS startUS], [-0.6 0.6],'color','k', 'Linestyle','--','LineWidth',2);
datetick('x',11,'keepticks')
title('Betas daily return US real bonds,nominal bonds and breakeven inflation with US stock');
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure6a_US_stockbetas.pdf')
saveas(gcf,'inflation_bonds\real_yields\USplots\apr_09\Figure6a_US_stockbetas.eps')
pause();

plot_matrix1=horzcat(m2xdate(dates_US10Y_stock_corr_nom), US10Ystock_beta_nom);
plot_matrix2=horzcat(m2xdate(dates_US10Y_stock_corr), US10Ystock_beta);
plot_matrix3=horzcat(m2xdate(dates_stockbreakeven10), -stockbreakeven10_beta);
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix1, 11,'A2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix2, 11,'C2');
xlswrite('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\Excel_plots\plots_US_apr28.xls',plot_matrix3, 11,'E2');

save inflation_bonds\apr_09\correlation_plots_US.mat