%This program computes daily nominal returns for UK inflation indexed bonds
%from price data 
%When running this program you will need to update the paths
%10/6/2009 cpflueger@hbs.edu

%load price data and index data UK
clear
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\apr_09')
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds')
%Load a .mat file that has one variable 'days' for the dates that is in
%Excel number format. The other variabel is 'px' with one time series of
%prices in each column
load MATLAB\inflation_bonds\apr_09\px_UK.mat
%Remove some extreme outliers
a=and(px<10,px>0);
a=sum(a,2);
a=(a==0);
px=px(a,:);
days=days(a);
%Convert dates into Matlab format
datepx=x2mdate(days); %Convert dates 
%Delete weird rows
a=(datepx>720000);
datepx=datepx(a);
px=px(a,:);

%Load the daily inflation indeces computed with index_UK_aug_08.m
load MATLAB\inflation_bonds\apr_09\UK_RPI.mat

%gives number of digits to round down for 8 month lagged bonds
%Different bonds have different rounding conventions. This can be found in 
%http://www.dmo.gov.uk/documentview.aspx?docname=/giltsmarket/formulae/ylde
%qns.pdf&page=Gilts/Formulae
load MATLAB\inflation_bonds\apr_09\round_apr_09.mat

%Download sequence of bank holidays - this is needed to compute ex-dividend
%date
addpath('C:\Documents and Settings\hbsuser\My Documents\RAwork\inflation_bonds\nominal_yields\UK')
%Make sure that the dates in UKbankholidays are not in number format 
[xx,UKholidays]=xlsread('C:\Documents and Settings\hbsuser\My Documents\RAwork\inflation_bonds\nominal_yields\UK\UKbankholidays.xls',1);
UKholidays=datenum(UKholidays);

%Load maturity, coupon and issue dates, lag_3 is an idicator for bonds that
%have a 3-month lag in their inflation index
load MATLAB\inflation_bonds\apr_09\yieldsdata_UK.mat

%There are some weird rows at the beginning of datepx, get rid off these,
%substract/add 7 to make sure that business days do not get us into trouble
begin_dates=max(min(datepx(datepx>720000)), min(dates_index))+7;
%Need to be careful: sometimes need to substract half a year because sometimes require
%that inflation index be known one coupon period in advance, should be OK
%because more recent bonds are 3month indexed
end_dates=min(max(datepx), max(dates_index)); %
dates=(begin_dates:end_dates); %Need interest payments for every date

%Delete superfluous rows of data in px, delete +- 7 days to be safe for
%holidays
keep=and(datepx<end_dates-7,datepx>begin_dates+7);
px=px(keep,:);
datepx=datepx(keep);

datepx_shift=datepx;
%Need to shift dates forward by one business date to get same numbers as in
%DMO file, later need to shift this back
datepx=busdate(datepx, 1, UKholidays, [1 0 0 0 0 0 1]); 

T=size(inflation_index,1);
N=size(yields,2); %N is number of bonds
inflation_factor=zeros(T,N); %matrix of individual inflation factors for every bond at every date


%Find index-ratios for gilts with 3-month lag and RPID/RPIB for gilts with 8
%month lag

N=size(px,2); %Number of bonds
for n=1:N
    %find CPI(issue(n))
    a=(dates_index==issue(n)); %dates_index contains all dates so should never get empty set here
    if lag_3(n)==1
    if sum(a)==1
        CPI_issue=inflation_index(a);
    end
    inflation_factor(:,n)=inflation_index/CPI_issue;
    else
        if sum(a)==1
            CPI_issue=RPI_8month(a);
        end
    inflation_factor(:,n)=RPI_8month/CPI_issue;
    end
end

inflation_factor=round(inflation_factor*100000)/100000;

%Compute coupon date, ex-dividend dates, real interest payments and accrued
%interest
N=size(px,2); %Number of bonds
T=size(dates,2);
interest=zeros(T,N); %real interest payments
interest_nom=zeros(T,N);
coupon_date=zeros(T,N);
ex_div_date=zeros(T,N);
AccInt=zeros(T,N);
AccInt_nom=zeros(T,N);
Redemption_payment=zeros(T,N); %redemption payment at maturity, need to multiply with max(index_ratio,1) to get nominal quantity
Redemption_payment_nom=zeros(T,N);

%Quantities for computing price from yield - everything in real terms,
%because we want real yields
%cash flow due on next quasi-coupon date
%Cash flow due on the next but one quasi coupon date
D1=zeros(T,N);
D2=zeros(T,N);
%Number of days from the settlement date to the next quasi-coupon date
f=zeros(T,N);
%Number of days in the full coupon period in which the settlement date
%occurs
d=zeros(T,N);
%Number of full semi-annual coupon periods between the first/next
%quasi-coupon date and the maturity date
n_coupons=zeros(T,N);

for n=1:N
    a=(issue(n)<=dates);
    b=(mat(n)>=dates);
    c=and(a==1,b==1);
    T_issuenext=sum(1-a)+1;
    T_matnext=sum(b);
    T_coupon=find(first_coupon(n)==dates); %The only way to get an empty matrix here is if the bond was issued way 
    % before the data series begins, in that case long and short dividend
    % periods are irrelevant
    if sum(c)>0
    PreviousQuasiCouponDate = cpndatepq(dates(c), mat(n), period(n),0,0,issue(n),first_coupon(n),mat(n));
    NextQuasiCouponDate = cpndatenq(dates(c), mat(n), period(n),0,0,issue(n),first_coupon(n),mat(n));
    previousqcpn=[zeros(T_issuenext-1,1)
                    PreviousQuasiCouponDate
                    zeros(T-T_matnext,1)];
    nextqcpn=[zeros(T_issuenext-1,1)
                    NextQuasiCouponDate
                    zeros(T-T_matnext,1)];
    %Function compute_coupon_dates_US is only good for coupon_dates
    NextCouponDate=cpndaten(dates(c), mat(n), period(n),0,0,issue(n),first_coupon(n),mat(n));
    PreviousCouponDate=cpndatep(dates(c), mat(n), period(n),0,0,issue(n),first_coupon(n),mat(n));
    previouscpn=[zeros(T_issuenext-1,1)
                    PreviousCouponDate
                    zeros(T-T_matnext,1)];
    nextcpn=[zeros(T_issuenext-1,1)
                    NextCouponDate
                    zeros(T-T_matnext,1)];

    %Now find ex-dividend date before next coupon date
    exdiv=find_exdiv(nextcpn, UKholidays);
    
    %Now find vector of indicators for dates on which dividends are paid,
    %exlude issue date
    coupon_dates=(dates'==previouscpn);
    coupon_dates(T_issuenext)=0;
    
    %Determine whether coupon period normal, short or long
    period_type=determine_coupon_type(issue(n), first_coupon(n), previouscpn, nextcpn, previousqcpn, nextqcpn, dates, T_issuenext); 
    %Compute vector of dividend payments
    [interest_temp, next_interest_temp]=compute_dividend_UK(period_type, coupon(n), issue(n), first_coupon(n), period(n), nextqcpn, previousqcpn, T_issuenext, coupon_dates);
    y=(dates==mat(n));
    redempt=y'*100;
    %Real accrued interest
    accrued_temp=compute_accrued_interest_UK(previouscpn, nextqcpn, previousqcpn, period_type, exdiv, issue(n), coupon(n), period(n), next_interest_temp, dates, T_issuenext, first_coupon(n));
        
    if lag_3(n)==1
    [interest_temp_nom, accrued_temp_nom, redempt_nom]=getnominal_int_UK(interest_temp, accrued_temp, redempt, dates, inflation_factor(:,n),dates_index);
    end
    
    if lag_3(n)==0
        [next_interest_temp_nom, interest_temp_nom, redempt_nom]=getnominal_8month(next_interest_temp, interest_temp, redempt, nextcpn, previouscpn, inflation_factor(:,n),dates_index, T_issuenext, dates, round_dividend_UK(n));
        a=(dates<datenum([1998 11 1]))'; %before 11/1/1998 use actual/365 day count convention
        %get nominal accrued interest if computed before 1998
        accrued_before98=compute_accrued_interest_UK_before98(previouscpn, nextcpn, exdiv, next_interest_temp_nom, dates);
        %Compute nominal accrued interest after 1998
        accrued_temp_nom=accrued_interest_8month(previouscpn, nextqcpn, previousqcpn, period_type, exdiv, issue(n), coupon(n), period(n), next_interest_temp_nom, dates, T_issuenext, first_coupon(n), dates_index, inflation_factor(:,n));
        accrued_temp_nom=a.*accrued_before98+(1-a).*accrued_temp_nom;
    end
    AccInt(:,n)=-accrued_temp;
    AccInt_nom(:,n)=-accrued_temp_nom;
    
    interest(:,n)=interest_temp;
    interest_nom(:,n)=interest_temp_nom;
    
   Redemption_payment(:,n)=redempt; %On face value of 100, in UK nominal redemption 
    %payment can be below face value
    Redemption_payment_nom(:,n)=redempt_nom;
    
    %Now fill values for yield calculcations
    f(:,n)=nextqcpn-dates';
    d(:,n)=nextqcpn-previousqcpn;
    datestemp=max(min(dates,mat(n)),issue(n));
    NumCouponsRemaining = cpncount(datestemp, mat(n),2, 0, 0);
    n_coupons(:,n)=NumCouponsRemaining-ones(T,1);
    [d1,d2]=compute_Div_UK(dates,exdiv, nextqcpn, issue, mat, coupon, period, first_coupon,T_issuenext, T_matnext,n);
    D1(:,n)=d1;
    D2(:,n)=d2;  
    end
end
%Bring interest and AccInt into format of px
interest_nom=adjust_format(interest_nom, dates, px, datepx);
interest=adjust_format(interest,dates,px,datepx);
AccInt_nom=adjust_format(AccInt_nom, dates, px, datepx);
AccInt=adjust_format(AccInt, dates, px, datepx);
Redemption_payment=adjust_format(Redemption_payment, dates, px, datepx);
Redemption_payment_nom=adjust_format(Redemption_payment_nom, dates, px, datepx);
inflation_factor=adjust_format(inflation_factor,dates_index, px, datepx);

%Bring data for yields into format of px
%Bring yields into format of prices
yields_new=adjust_format(yields, dates_yields, px, datepx_shift);
D1=adjust_format(D1, dates, px, datepx);
D2=adjust_format(D2, dates, px, datepx);
n_coupons=adjust_format(n_coupons, dates, px, datepx);
f=adjust_format(f, dates, px, datepx);
d=adjust_format(d, dates, px, datepx);

px_yields_dirty=yield_to_px_UK(yields_new, coupon,D1, D2, f, d, n_coupons);
px_yields=px_yields_dirty+AccInt;

px_nom=px.*inflation_factor;
%8-month lagged bonds quoted in nominal terms
N=size(px,2);
for n=1:N
    if lag_3(n)==0
        px_nom(:,n)=px(:,n);
        px(:,n)=px_nom(:,n)./inflation_factor(:,n);
    end
end

%Add redemption payment and interest payments
interest_nom=interest_nom+Redemption_payment_nom;

%Now add on accrued interest to get 'full price', AccInt_nom is saved as
%negative
px_full=px_nom-AccInt_nom;
px_dirty_real=px_full./inflation_factor;
%Now compute yields from prices

%Compute real yields - just to check, careful this is very slow
%real_yields=yields_new;
%Tpx=size(datepx,1);
%for n=1:N 
 %  for t=1:Tpx
 %   d1=D1(t,n);
 %   d2=D2(t,n);
 %   f_temp=f(t,n);
 %   d_temp=d(t,n);
 %   n_coupons_temp=n_coupons(t,n);
 %   px_temp=px_dirty_real(t,n);
 %   coupon_temp=coupon(n);
 %   y_start=yields_new(t,n);
%Get yield so that price is precise up to 2 digits
%y=fminsearch(@(y) minimize_for_yield_UK(y, coupon_temp,d1, d2, f_temp, d_temp, n_coupons_temp, px_temp), y_start,optimset('TolX',1e-2));
%real_yields(t,n)=y;
 %  end
%end

%Now shift date back by one business date
datepx=datepx_shift;
exceldate=m2xdate(datepx);
%Create a matrix comparable to data from DMO
datevector=datevec(datepx);
test=[datevector(:,1:3) yields_new(:,1) px_dirty_real(:,1) px_yields_dirty(:,1)];

%Now compute nominal daily returns for bond n
N=size(px,2); %Number of bonds
Tpx=size(px,1);
ret_nom=px_nom; %Daily holding return from yesterday to today

%Define px_full_minus,datepx_minus as the full price on the previous date
px_full_minus=px_full;
datepx_minus=datepx;

for t=2:Tpx
    px_full_minus(t,:)=px_full(t-1,:);
    datepx_minus(t)=datepx(t-1);
end
datepx_minus(1)=0;
px_full_minus(1,:)=zeros(1,N);

for n=1:N
    %If price data is available for day and previous business day compute nominal
    %daily return, otherwise set return to NaN
    a=and(datepx==busdate(datepx_minus, 1, UKholidays, [1 0 0 0 0 0 1]) ,px_full(:,n)>5).*(px_full_minus(:,n)>5); %check whether >5 because if price is 0 and accrued interest>0 can have 
    %very small price which is wrong
    a=a>0;
    ret_nom(:,n)=(px_full(:,n)-px_full_minus(:,n)+interest_nom(:,n))./px_full_minus(:,n);
    ret_nom(:,n)=ret_nom(:,n).*a;
end

for n=1:N
    for t=1:Tpx
        if isnan(ret_nom(t,n))
            ret_nom(t,n)=0;
        end
    end
end
            

save inflation_bonds\apr_09\nominal_returns_UK.mat

%Now need to splice nominal returns together 
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds')
Y=3652; %10 year splice
[splice_ret, dates_ret, bond, retY, bound]=splice_maturity(datepx,ret_nom, issue, mat,Y);
window=365;
[std_splice10, mean_splice10, dates_std10, bond_std]=std_return_window_ann(splice_ret, bond, window,dates_ret);

%Now make 20 year splices
Y=2*3652-20; %20 year splice
[splice_ret, dates_ret, bond, retY, bound]=splice_maturity(datepx,ret_nom, issue, mat,Y);
window=365;
[std_splice20, mean_splice20, dates_std20, bond_std]=std_return_window_ann(splice_ret, bond, window,dates_ret);

hold off;
plot(dates_std10,std_splice10);
hl2=line(dates_std20,std_splice20, 'Color','k');
datetick('x',11)
legend('std 10Y', 'std 20Y','Location','SouthWest');
ax1 = gca;
ax2 = axes('Position',get(ax1,'Position'),'YAxisLocation','right','Color','none','XColor','k','YColor','k');
hl3 = line(dates_std10,mean_splice10,'Color','g','Parent',ax2);
hl4=line(dates_std20,mean_splice20, 'Color','m', 'Parent',ax2);
datetick('x',11)
title('UK - std and mean of annualized daily returns, computed over 1 year window');
legend('mean 10Y', 'mean 20Y','Location','NorthEast');
addpath('C:\Documents and Settings\hbsuser\My Documents\MATLAB\inflation_bonds\real_yields')
saveas(gcf,'inflation_bonds\real_yields\UK\UKstd_mean_returns.pdf')
pause();
save inflation_bonds\apr_09\returnsUK10Y.mat
