%Computes 2 types of daily reference CPI for UK from monthly RPI data
%This is necessary because some of the bonds have an 8 month lag and others
%have a 3 month lag
%Data for these computation is is daily_deflator_UK.xls
%10/6/2009 cpflueger@hbs.edu

function [dates_index,inflation_index, RPI_8month]=index_UK_aug_08(data)
%Publication dates of monthly CPI sequence
CPI_dates=x2mdate(data(:,1));

%Find first date and last date of CPI sequence
startdate=min(data(:,1));
enddate=max(data(:,1));

startv=datevec(startdate);
endv=datevec(enddate)+[0 6 0 0 0 0];
%Can only start daily deflator sequence 9 months after start of CPI
%sequences because we need 8 month lags
startv=startv+[0 9 0 0 0 0];

startdate=datenum(startv);
enddate=datenum(endv);
days=(startdate:1:enddate);
%Convert dates to Matlab format
days=x2mdate(days);

N=size(days,2);
inflation_index=zeros(N,1);
RPI_8month=zeros(N,1); %Get RPI 8 months ago to adjust principal of bonds issued before 2005

daysvec=datevec(days);
A=[ones(N,1) zeros(N,1) zeros(N,1) zeros(N,1)];
first_of_month=[daysvec(:,1) daysvec(:,2) A];
%Number of days elapsed since beginning of month
elapsed=days-datenum(first_of_month)';
%Total number of days in month
A=[zeros(N,1) ones(N,1) zeros(N,1) zeros(N,1) zeros(N,1) zeros(N,1)];
total=datenum(first_of_month+A)-datenum(first_of_month);

CPI_plus=zeros(N,1); %CPI 3 months ago
CPI_minus=zeros(N,1); %CPI 2 months ago

%publication date CPI 2 or 3 months ago
date_plus=datenum(first_of_month)-15*ones(N,1); %Need to substract this number of dates so that get correspondence with 
date_minus=datenum(first_of_month)-45*ones(N,1); %Treasury series
date_8month=datenum(first_of_month)-(15+6*31)*ones(N,1); 
    
date_plus=datevec(date_plus);
date_minus=datevec(date_minus);
date_8month=datevec(date_8month);

date_plus=datenum([date_plus(:,1) date_plus(:,2) ones(N,1) zeros(N,1) zeros(N,1) zeros(N,1)]);
date_minus=datenum([date_minus(:,1) date_minus(:,2) ones(N,1) zeros(N,1) zeros(N,1) zeros(N,1)]);
date_8month=datenum([date_8month(:,1) date_8month(:,2) ones(N,1) zeros(N,1) zeros(N,1) zeros(N,1)]);

for n=1:N
     
    a=or(CPI_dates==date_plus(n), CPI_dates==date_plus(n)-1);
    if sum(a)>0
    CPI_plus(n)=data(a,2);
    end
    
    a=or(CPI_dates==date_minus(n), CPI_dates==date_minus(n)-1);
    if sum(a)>0
    CPI_minus(n)=data(a,2);
    end
    
    a=or(CPI_dates==date_8month(n), CPI_dates==date_8month(n)-1);
    
    if sum(a)>0
    RPI_8month(n)=data(a,2);
    end
    inflation_index(n)=CPI_minus(n)+(elapsed(n)/total(n))*(CPI_plus(n)-CPI_minus(n));%Formula in Deacon&Derry
    
end


  %round to 5 digits 
   inflation_index=round(inflation_index*100000)/100000;
   dates_index=days;
   keep=RPI_8month>0;
dates_index=dates_index(keep);
RPI_8month=RPI_8month(keep);
inflation_index=inflation_index(keep);
   
