%Computes next interest payment and redemption payment in nominal terms for
%g month lagged inflation indexed gilt
%10/6/2009 cpflueger@hbs.edu
function [next_interest_nom, interest_nom, redempt_nom]=getnominal_8month(next_interest, interest, redempt, nextcpn, previouscpn, inflation_factor_n,dates_index, T_issuenext, dates, round_dividend_UK)

interest_nom=interest;
next_interest_nom=next_interest;
redempt_nom=redempt;
T=size(redempt,1);
for t=T_issuenext:T
    if dates(t)==previouscpn(t)
        a=(dates_index==dates(t));
    else
    a=(dates_index==nextcpn(t));
    end
    if sum(a)>0
    inflation_temp=inflation_factor_n(a);
    else
        inflation_temp=0;
    end
    interest_nom(t)=interest(t)*inflation_temp;
    next_interest_nom(t)=next_interest(t)*inflation_temp;
    redempt_nom(t)=redempt(t)*inflation_temp;
end

%get closer to DMO figures without rounding
%if round_dividend_UK>0
%    interest_nom=floor(interest_nom*round_dividend_UK)/round_dividend_UK;
%    next_interest_nom=floor(next_interest_nom*round_dividend_UK)/round_dividend_UK;
%end
