%This is to align the data according to dates for US prices and dates
%Note that this file requires data as input that contains bid-, ask-, and
%mid prices
%10/6/2009 cpflueger@hbs.edu
%Set NaNs to zero
T=size(data,1);
N=size(data,2);
for t=1:T
    for n=1:N
        if isnan(data(t,n))==1
            data(t,n)=0;
        end
    end
end
        
    
%Find the first start date

K=size(data,2)/4; %No of bonds; Have 4 columns per bond: date and px, px_bid, px_ask


dates=[]; %Matrix of date vectors
for k=1:K
    dates=[dates data(:,4*k-3)];
end
startdate=min(dates);
enddate=max(dates);

firstday=min(startdate'); %First trading day in sample
lastday=max(max(data)');  %Last trading day in sample

days=zeros(lastday-firstday,1); %List of trading days

%Create maximal list of dates
for k=firstday:lastday
    if sum(sum(data==k)')>0
        days(k-firstday+1,1)=k;
    end
end

a=(days>1000);
days=days(a);
T=size(days,1);

px=zeros(T,K);
bid=zeros(T,K);
ask=zeros(T,K);

%For each bond check whether yield is reported for respective date

for k=1:K
    for t=1:T
        check=(data(:,4*k-3)==days(t));
    if sum(check)==1
        px(t,k)=data(check, 4*k-2); %Set price equal to price from data
        bid(t,k)=data(check, 4*k-1);
        ask(t,k)=data(check, 4*k);        
    end
    end
end





