clear
set memory 500000
set matsize 5000
set more off
/* ************************************************************************************************************** */
cd  "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick\Brookings Submission\Stata"
/* ************************************************************************************************************** */
use nick10, clear
keep if type=="Informal"
drop if country=="Cameroon"
/* ************************************************************************************************************** */
generate group=0 if informalsurvey==1 & registered_ctral==0
replace  group=1 if informalsurvey==1 & registered_ctral==1
replace  group=size_new+1 if informalsurvey==0
replace  group=2 if size_new==. & formal==1 & employees<20
replace  group=4 if size_new==. & formal==1 & employees>100 & employees~=.
replace  group=3 if size_new==. & formal==1 & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)
/* ************************************************************************************************************** */
generate income_pc=(gdp_pc_usd)

generate s=ln((s_l*(1+employees))/income_pc)
generate lab_emp=(labor_cost/100)*sales/employees

generate w=(lab_emp/income_pc)
generate ws=(lab_emp/(sales/employees))

generate comp=.
replace  comp=comp_full if formal==0

replace  comp=comp_perm if formal==1
replace  comp=comp_emp  if formal==1 & comp==.

replace  comp=(comp/income_pc)

sort code year

foreach var in  "comp" "w" "lab_emp" {
	by code year: egen cap=pctile(`var'), p(95)
	replace `var'=cap if `var'>cap & `var'~=.
	drop cap
}

table country, c(mean w mean comp mean lab_emp mean labor_cost mean income_pc)

#delimit ;

keep w ws comp lab_emp labor_cost income_pc country year file group;
save tmp, replace;

local X w ws comp lab_emp labor_cost income_pc;
/* ************************************************************************************************************** */
log using wages_inf, replace;
generate group1=(group==4);
generate group2=(group==2);
/* ************************************************************************************************************** */
foreach Z in "Cape Verde"   {;
	display "`Z'";	
	quietly: count if (country=="`Z'" & group1==1);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (country=="`Z'" & group2==1);
	if r(N)==0 {;
			continue;
	};
	ttest w if (group1==1 | group2==1) & country=="`Z'", by(group2);
};
log close;
/* ************************************************************************************************************** */
keep w ws comp lab_emp labor_cost income_pc country year file group;
save tmp, replace;
/* ************************************************************************************************************** */
collapse (mean) `X' , by(country year group);
/* ************************************************************************************************************** */
reshape wide `X'  , i(country year) j(group);
sort country year;
save output, replace;
/* ************************************************************************************************************** */
use tmp, clear;
collapse (mean) `X' , by(country year file);
reshape wide w ws comp lab_emp labor_cost income_pc, i(country year) j(file);
keep year country w0 w1 ws0 ws1;
rename w0 w_formal;
rename w1 w_informal;
rename ws0 ws_formal;
rename ws1 ws_informal;

sort country year;
merge country year using output;
edit country year w0 w1 w_informal w2 w3 w4 w_formal;
* edit country year ws0 ws1 ws_informal ws2 ws3 ws4 ws_formal;
/* ************************************************************************************************************** */
#delimit cr
use nick10, clear
keep if type=="Micro"
generate income_pc=(gdp_pc_usd)
generate s=ln((s_l*(1+employees))/income_pc)
generate lab_emp=(labor_cost/100)*sales/employees

generate w= (lab_emp/income_pc)
generate ws=(lab_emp/(sales/employees))
/* ************************************************************************************************************** */
generate group=0 if microinformal==1
replace  group=1 if microformal==1
replace  group=size_new+1 if enterprise_survey==1
replace  group=2 if size_new==. & (enterprise_survey==1) & employees<20
replace  group=4 if size_new==. & (enterprise_survey==1) & employees>100 & employees~=.
replace  group=3 if size_new==. & (enterprise_survey==1) & employees>=20 & employees<100 
/* ************************************************************************************************************** */
su lab_emp if country=="India" & group==0

generate file=(group<2)
/* ************************************************************************************************************** */
generate comp=.
replace  comp=comp_full if formal==0

replace  comp=comp_perm if formal==1
replace  comp=comp_emp  if formal==1 & comp==.

replace  comp=(comp/income_pc)

sort code year

foreach var in  "comp" "w" "lab_emp" {
	by code year: egen cap=pctile(`var'), p(95)
	replace `var'=cap if `var'>cap & `var'~=.
	drop cap
}

table country, c(mean w mean comp mean lab_emp  mean labor_cost mean income_pc)

#delimit ;

local X w ws comp lab_emp  labor_cost income_pc;
/* ************************************************************************************************************** */
log using wages_mic, replace;
generate group1=(group==0);
generate group2=(group==2);
/* ************************************************************************************************************** */
foreach Z in "Angola" "Botswana" "Burundi" "Congo, Dem. Rep." "Gambia, The" "Guinea" "Guinea-Bissau" "India"
"Mauritania" "Namibia" "Rwanda" "Swaziland" "Tanzania" "Uganda"  {;
	display "`Z'";	
	quietly: count if (country=="`Z'" & group1==1);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (country=="`Z'" & group2==1);
	if r(N)==0 {;
			continue;
	};
	ttest w if (group1==1 | group2==1) & country=="`Z'", by(group2);
};
/* ************************************************************************************************************** */
log close;
/* ************************************************************************************************************** */
keep w ws comp lab_emp labor_cost income_pc country year file group;
save tmp, replace;
/* ************************************************************************************************************** */
collapse (mean) `X' , by(country year group);
	generate group1=(group<=1);
	generate group2=(group>=2);
	display "ALL COUNTRIES";
	ttest w if (group1==1 | group==2) , by(group2);
drop group1 group2;
/* ************************************************************************************************************** */
reshape wide `X'  , i(country year) j(group);
sort country year;
save output, replace;
/* ************************************************************************************************************** */
use tmp, clear;
collapse (mean) `X' , by(country year file);
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
reshape wide `X'  , i(country year) j(file);
keep year country w0 w1 ws0 ws1;
rename w0 w_formal;
rename w1 w_informal;
rename ws0 ws_formal;
rename ws1 ws_informal;
sort country year;
merge country year using output;
edit country year w0 w1 w_informal w2 w3 w4 w_formal;
* edit country year ws0 ws1 ws_informal ws2 ws3 ws4 ws_formal;
