clear
set more off
set mem 90000
cd  "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick\Brookings Submission\Stata"
/* ******************************************************************************* */
use AFR_plus_LAC, clear
/* ******************************************************************************* */
generate changed=1 if Lb6b==2 & Lb6c~=.
replace  changed=0 if Lb6b==2 & Lb6c==.

generate YES=.
generate UNK=.

replace  YES=1 if Lb6b==1
replace  YES=0 if Lb6b==2
replace  UNK=0 if YES~=.
replace  UNK=1 if Lb6b<0

generate started=b5
replace  started=. if b5<0
/* ******************************************************************************* */
* does not know whether the establishment registered when it begun:
replace  started=. if Lb6b==-9
/* ******************************************************************************* */
* does not know when it registered:
replace  started=. if Lb6c==-9
/* ******************************************************************************* */
generate late=.
replace  late=Lb6c-started	if (started~=.) & (Lb6c>0)
replace  late=. if late<=0 

table a1, c(count YES mean YES mean UNK mean started mean late) row
/* ******************************************************************************* */
generate age=2006-started
generate registered=started 	if Lb6b==1.
replace  registered=Lb6c	if Lb6c~=. & Lb6c>0 

* sort registered
* tabulate age YES, freq
* sort started
* edit id started registered Lb6c Lb6b  if Lb6b~=. & registered==2000

tabulate late
