clear
set memory 500000
set matsize 5000
set more off
/* ************************************************************************************************************** */
cd "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick\Brookings Submission\Stata"
/* ************************************************************************************************************** */
use size03, clear
log using size03, replace
/* ************************************************************************************************************** */
* Missing GDP/POP from CIA factbook:
/* ************************************************************************************************************** */
local Y "inf_schneider"
eststo clear

eststo: regress `Y' proc_db		, robust

eststo: regress `Y' tax_db		, robust
eststo: regress `Y' time_tax		, robust

eststo: regress `Y' mgmt_time	, robust

eststo: regress `Y' hiringi*		, robust
eststo: regress `Y' firingi*		, robust
eststo: regress `Y' nonwagecost	, robust

eststo: regress `Y' formalism*	, robust
eststo: regress `Y' caseaeff*		, robust
eststo: regress `Y' road_density	, robust
eststo: regress `Y' corrupt2004	, robust
eststo: regress `Y' rule2004		, robust

eststo: regress `Y' priv_cred*	, robust
avplot priv_credit, ml(code) saving(tmp1, replace)

eststo: regress `Y' mcap		, robust
avplot mcap, ml(code) saving(tmp2, replace)

graph combine tmp1.gph tmp2.gph

eststo: regress `Y' access_loans	, robust
eststo: regress `Y' proc_db tax_db hiringi* priv_credit, robust
esttab using `Y'.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "tax_evasion"
eststo clear

eststo: regress `Y' proc_db		, robust

eststo: regress `Y' tax_db		, robust
eststo: regress `Y' time_tax		, robust

eststo: regress `Y' mgmt_time	, robust

eststo: regress `Y' hiringi*		, robust
eststo: regress `Y' firingi*		, robust
eststo: regress `Y' nonwagecost	, robust

eststo: regress `Y' formalism*	, robust
eststo: regress `Y' caseaeff*		, robust
eststo: regress `Y' road_density	, robust
eststo: regress `Y' corrupt2004	, robust
eststo: regress `Y' rule2004		, robust

eststo: regress `Y' priv_cred*	, robust
eststo: regress `Y' mcap		, robust

eststo: regress `Y' access_loans	, robust
eststo: regress `Y' proc_db tax_db hiringi* priv_credit, robust
esttab using `Y'.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "inf_elec"
eststo clear

eststo: regress `Y' proc_db		, robust

eststo: regress `Y' tax_db		, robust
eststo: regress `Y' time_tax		, robust

eststo: regress `Y' mgmt_time		, robust

eststo: regress `Y' hiringi*		, robust
eststo: regress `Y' firingi*		, robust
eststo: regress `Y' rigidityi*	, robust

eststo: regress `Y' formalism*	, robust
eststo: regress `Y' caseaeff*		, robust
eststo: regress `Y' road_density	, robust
eststo: regress `Y' corrupt2004	, robust
eststo: regress `Y' rule2004		, robust

eststo: regress `Y' priv_cred*	, robust
eststo: regress `Y' mcap		, robust

eststo: regress `Y' access_loans	, robust
eststo: regress `Y' proc_db tax_db hiringi* priv_credit, robust
esttab using `Y'.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "inf_wef"
eststo clear

eststo: regress `Y' proc_db		, robust

eststo: regress `Y' tax_db		, robust
eststo: regress `Y' time_tax		, robust

eststo: regress `Y' mgmt_time		, robust

eststo: regress `Y' hiringi*		, robust
eststo: regress `Y' firingi*		, robust
eststo: regress `Y' rigidityi*	, robust

eststo: regress `Y' formalism*	, robust
eststo: regress `Y' caseaeff*		, robust
eststo: regress `Y' road_density	, robust
eststo: regress `Y' corrupt2004	, robust
eststo: regress `Y' rule2004		, robust

eststo: regress `Y' priv_cred*	, robust
eststo: regress `Y' mcap		, robust

eststo: regress `Y' access_loans	, robust
eststo: regress `Y' proc_db tax_db hiringi* priv_credit, robust
esttab using `Y'.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
twoway(scatter self_emp_pct income, ml(code)) (lfit self_emp_pct income),  ytitle("%Self-employment") xtitle("Ln(GDP/POP)") legend(off) saving(self, replace asis)

local Y "self_emp_pct"
eststo clear

eststo: regress `Y' proc_db		, robust

eststo: regress `Y' tax_db		, robust
eststo: regress `Y' time_tax		, robust

eststo: regress `Y' mgmt_time		, robust

eststo: regress `Y' hiringi*		, robust
eststo: regress `Y' firingi*		, robust
eststo: regress `Y' rigidityi*	, robust

eststo: regress `Y' formalism*	, robust
eststo: regress `Y' caseaeff*		, robust
eststo: regress `Y' road_density	, robust
eststo: regress `Y' corrupt2004	, robust
eststo: regress `Y' rule2004		, robust

eststo: regress `Y' priv_cred*	, robust
eststo: regress `Y' mcap		, robust

eststo: regress `Y' access_loans	, robust
eststo: regress `Y' proc_db tax_db hiringi* priv_credit, robust
esttab using `Y'.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "non_agric_self"
eststo clear

eststo: regress `Y' proc_db		, robust

eststo: regress `Y' tax_db		, robust
eststo: regress `Y' time_tax		, robust

eststo: regress `Y' mgmt_time		, robust

eststo: regress `Y' hiringi*		, robust
eststo: regress `Y' firingi*		, robust
eststo: regress `Y' rigidityi*	, robust

eststo: regress `Y' formalism*	, robust
eststo: regress `Y' caseaeff*		, robust
eststo: regress `Y' road_density	, robust
eststo: regress `Y' corrupt2004	, robust
eststo: regress `Y' rule2004		, robust

eststo: regress `Y' priv_cred*	, robust
eststo: regress `Y' mcap		, robust

eststo: regress `Y' access_loans	, robust
eststo: regress `Y' proc_db tax_db hiringi* priv_credit, robust
esttab using `Y'.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "register_pop"
eststo clear

eststo: regress `Y' proc_db		, robust

eststo: regress `Y' tax_db		, robust
eststo: regress `Y' time_tax		, robust

eststo: regress `Y' mgmt_time		, robust

eststo: regress `Y' hiringi*		, robust
eststo: regress `Y' firingi*		, robust
eststo: regress `Y' rigidityi*	, robust

eststo: regress `Y' formalism*	, robust
eststo: regress `Y' caseaeff*		, robust
eststo: regress `Y' road_density	, robust
eststo: regress `Y' corrupt2004	, robust
eststo: regress `Y' rule2004		, robust

eststo: regress `Y' priv_cred*	, robust
avplot priv_credit, ml(code) saving(tmp1, replace)
eststo: regress `Y' mcap		, robust
avplot mcap, ml(code) saving(tmp2, replace)

graph combine tmp1.gph tmp2.gph

eststo: regress `Y' access_loans	, robust
eststo: regress `Y' proc_db tax_db hiringi* priv_credit, robust
esttab using `Y'.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
* ADD PER CAPITA INCOME
/* ************************************************************************************************************** */
local Y "inf_schneider"
eststo clear

eststo: regress `Y' income 			, robust
eststo: regress `Y' income proc_db		, robust

eststo: regress `Y' income tax_db		, robust
eststo: regress `Y' income time_tax		, robust

eststo: regress `Y' income mgmt_time	, robust

eststo: regress `Y' income hiringi*		, robust
eststo: regress `Y' income firingi*		, robust
eststo: regress `Y' income nonwagecost	, robust

eststo: regress `Y' income formalism*	, robust
eststo: regress `Y' income caseaeff*	, robust
eststo: regress `Y' income road_density	, robust
eststo: regress `Y' income corrupt2004	, robust
eststo: regress `Y' income rule2004		, robust

eststo: regress `Y' income priv_cred*	, robust
avplot priv_credit, ml(code) saving(tmp1, replace)
eststo: regress `Y' income mcap		, robust
avplot mcap, ml(code) saving(tmp1, replace)

graph combine tmp1.gph tmp2.gph

eststo: regress `Y' income access_loans	, robust
eststo: regress `Y' income proc_db tax_db hiringi* priv_credit , robust
esttab using `Y'_inc.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "tax_evasion"
eststo clear

eststo: regress `Y' income 			, robust
eststo: regress `Y' income proc_db		, robust

eststo: regress `Y' income tax_db		, robust
eststo: regress `Y' income time_tax		, robust

eststo: regress `Y' income mgmt_time	, robust

eststo: regress `Y' income hiringi*		, robust
eststo: regress `Y' income firingi*		, robust
eststo: regress `Y' income nonwagecost	, robust

eststo: regress `Y' income formalism*	, robust
eststo: regress `Y' income caseaeff*	, robust
eststo: regress `Y' income road_density	, robust
eststo: regress `Y' income corrupt2004	, robust
eststo: regress `Y' income rule2004		, robust

eststo: regress `Y' income priv_cred*	, robust
avplot priv_credit, ml(code) saving(tmp1, replace)

eststo: regress `Y' income mcap		, robust
avplot mcap, ml(code) saving(tmp2, replace)

graph combine tmp1.gph tmp2.gph

eststo: regress `Y' income access_loans	, robust
eststo: regress `Y' income proc_db tax_db hiringi* priv_credit , robust
esttab using `Y'_inc.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "inf_elec"
eststo clear

eststo: regress `Y' income 			, robust
eststo: regress `Y' income proc_db		, robust

eststo: regress `Y' income tax_db		, robust
eststo: regress `Y' income time_tax		, robust

eststo: regress `Y' income mgmt_time	, robust

eststo: regress `Y' income hiringi*		, robust
eststo: regress `Y' income firingi*		, robust
eststo: regress `Y' income rigidityi*	, robust

eststo: regress `Y' income formalism*	, robust
eststo: regress `Y' income caseaeff*	, robust
eststo: regress `Y' income road_density	, robust
eststo: regress `Y' income corrupt2004	, robust
eststo: regress `Y' income rule2004		, robust

eststo: regress `Y' income priv_cred*	, robust
avplot priv_credit, ml(code) saving(tmp1, replace)
eststo: regress `Y' income mcap		, robust
avplot mcap, ml(code) saving(tmp2, replace)

graph combine tmp1.gph tmp2.gph

eststo: regress `Y' income access_loans	, robust
eststo: regress `Y' income proc_db tax_db hiringi* priv_credit , robust
esttab using `Y'_inc.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "inf_wef"
eststo clear

eststo: regress `Y' income 			, robust
eststo: regress `Y' income proc_db		, robust

eststo: regress `Y' income tax_db		, robust
eststo: regress `Y' income time_tax		, robust

eststo: regress `Y' income mgmt_time	, robust

eststo: regress `Y' income hiringi*		, robust
eststo: regress `Y' income firingi*		, robust
eststo: regress `Y' income rigidityi*	, robust

eststo: regress `Y' income formalism*	, robust
eststo: regress `Y' income caseaeff*	, robust
eststo: regress `Y' income road_density	, robust
eststo: regress `Y' income corrupt2004	, robust
eststo: regress `Y' income rule2004		, robust

eststo: regress `Y' income priv_cred*	, robust
eststo: regress `Y' income mcap		, robust

eststo: regress `Y' income access_loans	, robust
eststo: regress `Y' income proc_db tax_db hiringi* priv_credit , robust
esttab using `Y'_inc.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "self_emp_pct"
eststo clear

eststo: regress `Y' income 			, robust
eststo: regress `Y' income proc_db		, robust

eststo: regress `Y' income tax_db		, robust
eststo: regress `Y' income time_tax		, robust

eststo: regress `Y' income mgmt_time	, robust

eststo: regress `Y' income hiringi*		, robust
eststo: regress `Y' income firingi*		, robust
eststo: regress `Y' income rigidityi*	, robust

eststo: regress `Y' income formalism*	, robust
eststo: regress `Y' income caseaeff*	, robust
eststo: regress `Y' income road_density	, robust
eststo: regress `Y' income corrupt2004	, robust
eststo: regress `Y' income rule2004		, robust

eststo: regress `Y' income priv_cred*	, robust
avplot priv_credit, ml(code) saving(tmp1, replace)
eststo: regress `Y' income mcap		, robust
avplot mcap, ml(code) saving(tmp2, replace)

graph combine tmp1.gph tmp2.gph

eststo: regress `Y' income access_loans	, robust
eststo: regress `Y' income proc_db tax_db hiringi* priv_credit , robust
esttab using `Y'_inc.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */
local Y "non_agric_self"
eststo clear

eststo: regress `Y' income 			, robust
eststo: regress `Y' income proc_db		, robust

eststo: regress `Y' income tax_db		, robust
eststo: regress `Y' income time_tax		, robust

eststo: regress `Y' income mgmt_time	, robust

eststo: regress `Y' income hiringi*		, robust
eststo: regress `Y' income firingi*		, robust
eststo: regress `Y' income rigidityi*	, robust

eststo: regress `Y' income formalism*	, robust
eststo: regress `Y' income caseaeff*	, robust
eststo: regress `Y' income road_density	, robust
eststo: regress `Y' income corrupt2004	, robust
eststo: regress `Y' income rule2004		, robust

eststo: regress `Y' income priv_cred*	, robust
eststo: regress `Y' income mcap		, robust

eststo: regress `Y' income access_loans	, robust
eststo: regress `Y' income proc_db tax_db hiringi* priv_credit , robust
esttab using `Y'_inc.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
/* ************************************************************************************************************** */local Y "register_pop"
local Y "register_pop"
eststo clear

eststo: regress `Y' income 			, robust
eststo: regress `Y' income proc_db		, robust

eststo: regress `Y' income tax_db		, robust
eststo: regress `Y' income time_tax		, robust

eststo: regress `Y' income mgmt_time	, robust

eststo: regress `Y' income hiringi*		, robust
eststo: regress `Y' income firingi*		, robust
eststo: regress `Y' income rigidityi*	, robust

eststo: regress `Y' income formalism*	, robust
eststo: regress `Y' income caseaeff*	, robust
eststo: regress `Y' income road_density	, robust
eststo: regress `Y' income corrupt2004	, robust
eststo: regress `Y' income rule2004		, robust

eststo: regress `Y' income priv_cred*	, robust
avplot priv_credit, ml(code) saving(tmp1, replace)
eststo: regress `Y' income mcap		, robust
avplot mcap, ml(code) saving(tmp2, replace)

graph combine tmp1.gph tmp2.gph

eststo: regress `Y' income access_loans	, robust
eststo: regress `Y' income proc_db tax_db hiringi* priv_credit , robust
esttab using `Y'_inc.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
log close
/* ************************************************************************************************************** */
* DO THE GRAPHS
/* ************************************************************************************************************** */
regress inf_schneider	income, robust
predict yhat

avplot income, ml(code) ytitle("Informal economy --Schneider") xtitle("GDP/POP")
graph save income, replace
twoway(scatter inf_schneider income, ml(code)) (lfit inf_schneider income),  ytitle("%Informal economy --Multiple Indicators") xtitle("Ln(GDP/POP)") legend(off) saving(multip.gph, replace asis)
/* ************************************************************************************************************** */
generate hk=ln(tyr)
regress inf_schneider	hk, robust
avplot hk, ml(code) ytitle("Informal economy --Schneider") xtitle("Ln(Years of schooling)")
graph save hk, replace
/* ************************************************************************************************************** */
regress inf_schneider	hk income, robust
avplot hk, ml(code) ytitle("Informal economy --Schneider") xtitle("Ln(Years of schooling) controlling for GDP/POP")
graph save hk_inc, replace
/* ************************************************************************************************************** */
regress inf_schneider	proc_db, robust
avplot proc_db, ml(code) ytitle("Informal economy --Schneider") xtitle("Ln(Number of procedures to start business)")
graph save proc, replace
/* ************************************************************************************************************** */
regress inf_schneider	proc_db income , robust
avplot proc_db, ml(code) ytitle("Informal economy --Schneider") xtitle("Ln(Number of procedures to start business) controlling for GDP/POP")
graph save proc_inc, replace
/* ************************************************************************************************************** */
regress inf_schneider	tax_db, robust
avplot tax_db, ml(code) ytitle("Informal economy --Schneider") xtitle("Total corporate tax rate")
graph save tax, replace	
/* ************************************************************************************************************** */
regress inf_schneider	tax_db income, robust
avplot tax_db, ml(code) ytitle("Informal economy --Schneider") xtitle("Total corporate tax rate controlling for GDP/POP")
graph save tax_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider	corrupt2004, robust
avplot corrupt2004, ml(code) ytitle("Informal economy --Schneider") xtitle("Corruption")
graph save corrupt, replace	
/* ************************************************************************************************************** */
regress inf_schneider	corrupt2004 income, robust
avplot corrupt2004, ml(code) ytitle("Informal economy --Schneider") xtitle("Corruption controlling for GDP/POP")
graph save corrupt_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider	formalism_c, robust
avplot formalism_c, ml(code) ytitle("Informal economy --Schneider") xtitle("Steps to collect on bounced check")
graph save formalism, replace	
/* ************************************************************************************************************** */
regress inf_schneider	formalism_c income, robust
avplot formalism_c, ml(code) ytitle("Informal economy --Schneider") xtitle("Steps to collect on bounced check controlling for GDP/POP")
graph save formalism_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider	caseaeff*, robust
avplot caseaeff*, ml(code) ytitle("Informal economy --Schneider") xtitle("Efficiency of bankruptcy")
graph save efficiency, replace	
/* ************************************************************************************************************** */
regress inf_schneider	caseaeff* income, robust
avplot caseaeff*, ml(code) ytitle("Informal economy --Schneider") xtitle("Efficiency of bankruptcy controlling for GDP/POP")
graph save efficiency_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider	rule2004, robust
avplot rule2004, ml(code) ytitle("Informal economy --Schneider") xtitle("Rule of law")
graph save rule, replace	
/* ************************************************************************************************************** */
regress inf_schneider	rule2004 income, robust
avplot rule2004, ml(code) ytitle("Informal economy --Schneider") xtitle("Rule of law controlling for GDP/POP")
graph save rule_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider	firingindex, robust
avplot firingindex, ml(code) ytitle("Informal economy --Schneider") xtitle("Firing Index")
graph save firing, replace	
/* ************************************************************************************************************** */
regress inf_schneider	firingindex income , robust
avplot firingindex, ml(code) ytitle("Informal economy --Schneider") xtitle("Firing Index controlling for GDP/POP")
graph save firing_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider	hiringindex, robust
avplot hiringindex, ml(code) ytitle("Informal economy --Schneider") xtitle("Hiring Index")
graph save hiring, replace	
/* ************************************************************************************************************** */
regress inf_schneider	hiringindex income, robust
avplot hiringindex, ml(code) ytitle("Informal economy --Schneider") xtitle("Hiring Index controlling for GDP/POP")
graph save hiring_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider rigidityindex, robust
avplot rigidityindex, ml(code) ytitle("Informal economy --Schneider") xtitle("Labor rigidity index")
graph save rigidity, replace	
/* ************************************************************************************************************** */
regress inf_schneider rigidityindex income, robust
avplot rigidityindex, ml(code) ytitle("Informal economy --Schneider") xtitle("Labor rigidity index controlling for GDP/POP")
graph save rigidity_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider mgmt_time, robust
avplot mgmt_time, ml(code) ytitle("Informal economy --Schneider") xtitle("% Management time spent dealing with regulations controlling for GDP/POP")
graph save mgmt_time_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider mcap, robust
avplot mcap, ml(code) ytitle("Informal economy --Schneider") xtitle("Stock market capitalization to GDP")
graph save mcap, replace	
/* ************************************************************************************************************** */
regress inf_schneider mcap income, robust
avplot mcap, ml(code) ytitle("Informal economy --Schneider") xtitle("Stock market capitalization to GDP controlling for GDP/POP")
graph save mcap_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider priv_credit, robust
avplot priv_credit, ml(code) ytitle("Informal economy --Schneider") xtitle("Private credit to GDP")
graph save priv_credit, replace	
/* ************************************************************************************************************** */
regress inf_schneider priv_credit income, robust
avplot priv_credit, ml(code) ytitle("Informal economy --Schneider") xtitle("Private credit to GDP controlling for GDP/POP")
graph save priv_credit_inc, replace	
/* ************************************************************************************************************** */
regress inf_schneider road_density, robust
avplot road_density, ml(code) ytitle("Informal economy --Schneider") xtitle("Road density")
graph save road_density, replace	

regress inf_schneider road_density income, robust
avplot road_density, ml(code) ytitle("Informal economy --Schneider") xtitle("Road density controlling for GDP/POP")
graph save road_density_inc, replace	
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
keep if inf_wef~=. | tax_evasion~=. | self_emp_pct~=. | lab_inf~=. | inf_schneider~=. | inf_elec~=.   


xtile group = gdp_pc_ppp, nq(4)

sort gdp_pc_ppp 
edit country gdp_pc_ppp inf_wef tax_evasion self_emp_pct non_* inf_elec inf_sch* register_pop
save tmp, replace

log using tstas, replace
foreach Y in "inf_wef" "tax_evasion" "self_emp_pct" "non_agric_self" "inf_elec" "inf_schneider" "register_pop" {
	ttest `Y' if group==1 | group==4, by(group)
	} 
log close
collapse (mean) gdp_pc_ppp gdp_pc_usd inf_sch* inf_elec inf_wef self_emp_pct non_* lab_inf register_pop emp_inf tax_evasion, by(group)
edit group gdp_pc_usd  inf_wef tax_evasion self_emp_pct non_* inf_elec inf_sch* register_pop
/* ************************************************************************************************************** */
use tmp, clear
pwcorr inf_wef tax_evasion self_emp_pct non_* inf_elec inf_sch* register_pop
pwcorr inf_wef tax_evasion self_emp_pct non_* inf_elec inf_sch* register_pop proc_db tax_db time_tax mgmt_time hiringin* firingin* nonwagecost formalism* caseaeff* road_density corrupt2004 rule2004 priv_cred* mcap income, star(0.1)

~
regress inf_schneider	income agriculture latitude, robust
ivregress 2sls inf_schneider	(income tax=legor_fr legor_ge legor_so legor_sc ethnic latitude), robust first
