clear
set memory 600000
set matsize 5000
set more off
adopath + "C:\Program Files\Stata10\bounds"
/* ************************************************************************************************************** */
cd  "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick\Brookings Submission\Stata"
/* ************************************************************************************************************** */
use city_region_0611, clear
sort code microinformal microformal informalsurvey idstd year
save tmp, replace

use nick10, clear
keep if a+l+mgr_educ+m+e+i~=.
sort code microinformal microformal informalsurvey idstd year
/* ************************************************************************************************************** */
merge code microinformal microformal informalsurvey idstd year using tmp
drop if _merge==2
drop _merge
sort code
save nick12, replace
/* ************************************************************************************************************** */
merge code using ppp_conversion_formatted
drop if _merge==2
/* ************************************************************************************************************** */
generate s=ln(sales)
bysort code year: egen cap=pctile(s), p(95)
replace s=cap if s>cap & s~=.
/* ************************************************************************************************************** */
generate income=ln(gdp_pc_ppp)

local j=0
forvalues i = 2(1)7 {
		local j = 2000 + `i'
		replace va=va-ln(ppp_factor_`j') if year==`j'
		replace sl=sl-ln(ppp_factor_`j') if year==`j'
		replace m =m -ln(ppp_factor_`j') if year==`j'
		replace e =e -ln(ppp_factor_`j') if year==`j'
		replace i =i -ln(ppp_factor_`j') if year==`j'
		replace s =s -ln(ppp_factor_`j') if year==`j'
	}

generate inf_reg=0
replace  inf_reg=1 if informalsurvey==1 & registered_ctral==1

drop micro
generate micro=0
replace  micro=1 if microinformal+microformal==1

generate mic_reg=0
replace  mic_reg=1 if microformal==1
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
generate tmp=exp(va)
generate va_klenow=((1+employees)*exp(va))^1.5/(1+employees)
replace  va_klenow=ln(va_klenow)
drop tmp
generate tmp=exp(sl)
generate sl_klenow=((1+employees)*exp(sl))^1.5/(1+employees)
replace  sl_klenow=ln(sl_klenow)
/* ************************************************************************************************************** */
pwcorr va_klenow va
pwcorr sl_klenow sl
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
su m e i s va
/* ************************************************************************************************************** */
* SIMPLE OLS REGRESSIONS FOR VALUE ADDED
/* ************************************************************************************************************** */
log using value_added,replace
eststo clear
eststo: xi: regress va informalsurvey inf_reg micro mic_reg								, robust cluster(code)
eststo: xi: regress va informalsurvey inf_reg micro mic_reg income						, robust cluster(code)
eststo: xi: regress va informalsurvey inf_reg micro mic_reg income	i.our_sic				, robust cluster(code)
eststo: xi: regress va informalsurvey inf_reg micro mic_reg income	i.our_sic m				, robust cluster(code)
eststo: xi: regress va informalsurvey inf_reg micro mic_reg income	i.our_sic m	e			, robust cluster(code)
eststo: xi: regress va informalsurvey inf_reg micro mic_reg income	i.our_sic m	e i			, robust cluster(code)
eststo: xi: regress va informalsurvey inf_reg micro mic_reg income	i.our_sic m e i mgr_educ	, robust cluster(code)
eststo: xi: regress va informalsurvey inf_reg micro mic_reg income	i.our_sic m e i mgr_educ s	, robust cluster(code)

esttab using reg01.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
log close
/* ************************************************************************************************************** */
* SIMPLE OLS REGRESSIONS FOR SALES/EMPLOYEE
/* ************************************************************************************************************** */
log using sales, replace
eststo clear
eststo: xi: regress sl informalsurvey inf_reg micro mic_reg								, robust cluster(code)
eststo: xi: regress sl informalsurvey inf_reg micro mic_reg income						, robust cluster(code)
eststo: xi: regress sl informalsurvey inf_reg micro mic_reg income	i.our_sic				, robust cluster(code)
eststo: xi: regress sl informalsurvey inf_reg micro mic_reg income	i.our_sic m				, robust cluster(code)
eststo: xi: regress sl informalsurvey inf_reg micro mic_reg income	i.our_sic m	e			, robust cluster(code)
eststo: xi: regress sl informalsurvey inf_reg micro mic_reg income	i.our_sic m	e i			, robust cluster(code)
eststo: xi: regress sl informalsurvey inf_reg micro mic_reg income	i.our_sic m e i mgr_educ	, robust cluster(code)
eststo: xi: regress sl informalsurvey inf_reg micro mic_reg income	i.our_sic m e i mgr_educ s	, robust cluster(code)

esttab using reg02.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
log close
/* ************************************************************************************************************** */
* SIMPLE OLS REGRESSIONS FOR REAL OUTPUT
/* ************************************************************************************************************** */
log using realoutput, replace
eststo clear
eststo: xi: regress sl_klenow informalsurvey inf_reg micro mic_reg							, robust cluster(code)
eststo: xi: regress sl_klenow informalsurvey inf_reg micro mic_reg income						, robust cluster(code)
eststo: xi: regress sl_klenow informalsurvey inf_reg micro mic_reg income	i.our_sic				, robust cluster(code)
eststo: xi: regress sl_klenow informalsurvey inf_reg micro mic_reg income	i.our_sic m				, robust cluster(code)
eststo: xi: regress sl_klenow informalsurvey inf_reg micro mic_reg income	i.our_sic m	e			, robust cluster(code)
eststo: xi: regress sl_klenow informalsurvey inf_reg micro mic_reg income	i.our_sic m	e i			, robust cluster(code)
eststo: xi: regress sl_klenow informalsurvey inf_reg micro mic_reg income	i.our_sic m e i mgr_educ	, robust cluster(code)
eststo: xi: regress sl_klenow informalsurvey inf_reg micro mic_reg income	i.our_sic m e i mgr_educ s	, robust cluster(code)

esttab using reg03.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
log close
