clear
set memory 500000
set matsize 5000
set more off
/* ************************************************************************************************************** */
cd  "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick\Brookings Submission\Stata"
/* ************************************************************************************************************** */
use nick10, clear
keep if type=="Informal"
drop if country=="Cameroon"

replace labor_cost=labor_cost/100
replace exp_mach=exp_mach/100
replace exp_land=exp_land/100
replace exp_rent=exp_rent/100
/* ************************************************************************************************************** */
generate group=0 if informalsurvey==1 & registered_ctral==0
replace  group=1 if informalsurvey==1 & registered_ctral==1
replace  group=size_new+1 if informalsurvey==0
replace  group=2 if size_new==. & formal==1 & employees<20
replace  group=4 if size_new==. & formal==1 & employees>100 & employees~=.
replace  group=3 if size_new==. & formal==1 & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)
/* ************************************************************************************************************** */
keep exp_raw exp_ene labor_cost exp_mach exp_land exp_rent country group file year
save tmp, replace

#delimit ;
local X exp_raw exp_ene labor_cost exp_mach exp_land exp_rent;

collapse (mean) `X' , by(country year group);
/* ************************************************************************************************************** */
log using inputs_inf, replace;
generate group1=(group==1);
generate group2=(group==0);

foreach l in `X'  {;
	display "`l'";
	quietly: count if (`l'~=. & group1==1);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (`l'~=. & group2==1);
	if r(N)==0 {;
			continue;
	};
	ttest `l' if (group1==1 | group2==1), by(group2);
};
log close;
collapse (mean) `X' , by(group);
xpose, clear varname;
save output, replace;
/* ************************************************************************************************************** */
use tmp, clear;
collapse (mean) `X' , by(country year file);
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
log using inputs_inf, replace;
foreach l in `X'  {;
	display "`l'";
	quietly: count if (`l'~=. & file==0);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (`l'~=. & file==1);
	if r(N)==0 {;
			continue;
	};
	ttest `l', by(file);
};

log close;
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
collapse (mean) `X' , by(file);
xpose, clear varname;

rename v1 formal;
rename v2 informal;

joinby _varname using output;
edit _varname v1 v2 informal v3 v4 v5 formal;
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
#delimit cr
set more off
use nick10, clear
keep if type=="Micro"
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
replace labor_cost=labor_cost/100
replace exp_mach=exp_mach/100
replace exp_land=exp_land/100
replace exp_rent=exp_rent/100
/* ************************************************************************************************************** */
generate group=0 if microinformal==1
replace  group=1 if microformal==1
replace  group=size_new+1 if enterprise_survey==1
replace  group=2 if size_new==. & (enterprise_survey==1) & employees<20
replace  group=4 if size_new==. & (enterprise_survey==1) & employees>100 & employees~=.
replace  group=3 if size_new==. & (enterprise_survey==1) & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)
/* ************************************************************************************************************** */
keep exp_raw exp_ene labor_cost exp_mach exp_land exp_rent country group file year
save tmp, replace

#delimit ;
local X exp_raw exp_ene labor_cost exp_mach exp_land exp_rent;

collapse (mean) `X' , by(country year group);
/* ************************************************************************************************************** */
log using inputs_mic, replace;
generate group1=(group==2);
generate group2=(group==4);

foreach l in `X'  {;
	display "`l'";
	quietly: count if (`l'~=. & group1==1);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (`l'~=. & group2==1);
	if r(N)==0 {;
			continue;
	};
	ttest `l' if (group1==1 | group2==1), by(group2);
};
log close;
collapse (mean) `X' , by(group);
xpose, clear varname;
save output, replace;
/* ************************************************************************************************************** */
use tmp, clear;
collapse (mean) `X' , by(country year file);
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
log using inputs_mic, replace;
foreach l in `X'  {;
	display "`l'";
	quietly: count if (`l'~=. & file==0);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (`l'~=. & file==1);
	if r(N)==0 {;
			continue;
	};
	ttest `l', by(file);
};

log close;
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
collapse (mean) `X' , by(file);
xpose, clear varname;

rename v1 formal;
rename v2 informal;

joinby _varname using output;
edit _varname v1 v2 informal v3 v4 v5 formal;

