clear
set memory 500000
set matsize 5000
set more off
/* ************************************************************************************************************** */
cd  "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick\Brookings Submission\Stata"
/* ************************************************************************************************************** */
use nick10, clear
keep if type=="Informal"
drop if country=="Cameroon"
generate income_pc=exp(gdp_pc_usd)
generate s=ln((s_l*(1+employees))/income_pc)
generate lab_emp=(labor_cost/100)*sales/employees
generate w=(lab_emp/income_pc)
replace capacity=capacity/100
replace buil_own=buil_own/100
replace mgr_primary=mgr_primary/100
replace mgr_secondary=mgr_secondary/100
replace mgr_vocational=mgr_vocational/100
replace mgr_college=mgr_college/100
replace wkr_primary=wkr_primary/100
replace wkr_secondary=wkr_secondary/100
replace wkr_college=wkr_college/100
replace finance_int=finance_int/100
replace fin_trade=fin_trade/100
replace fin_family=fin_family/100
replace finance_bnk=finance_bnk/100
replace emp_growth=(1+emp_growth/100)^0.5-1
replace sales_growth=(1+sales_growth/100)^0.5-1
replace mgmt_time=mgmt_time/100
replace bribes=bribes/100
replace tax_evasion=tax_evasion/100
replace security=security/100
replace protection=protection/100
replace theft=theft/100
replace reported=reported/100
/* ************************************************************************************************************** */
generate group=0 if informalsurvey==1 & registered_ctral==0
replace  group=1 if informalsurvey==1 & registered_ctral==1
replace  group=size_new+1 if informalsurvey==0
replace  group=2 if size_new==. & formal==1 & employees<20
replace  group=4 if size_new==. & formal==1 & employees>100 & employees~=.
replace  group=3 if size_new==. & formal==1 & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)
/* ************************************************************************************************************** */
bysort code year: egen cap=pctile(sales), p(95)
replace sales=cap if sales>=cap & sales~=.
drop cap

generate comp=.
replace  comp=comp_full if formal==0

replace  comp=comp_perm if formal==1
replace  comp=comp_emp  if formal==1 & comp==.

replace  comp=(comp/income_pc)

sort code year

foreach var in  "comp" "w" "lab_emp" {
	by code year: egen cap=pctile(`var'), p(95)
	replace `var'=cap if `var'>cap & `var'~=.
	drop cap
}

table country, c(mean w mean comp mean lab_emp mean labor_cost mean income_pc)

table country if formal==1, c(mean emp_growth  mean sales_growth)
table country if formal==0, c(mean emp_growth  mean sales_growth)

#delimit ;
local X days_power
days_water
days_teleph
days_transp


mgmt_time
bribes
tax_evasion


security
protection
theft
reported
days_solve
conflict
court
;
save tmp, replace;
collapse (mean) `X' , by(country year group);
/* ************************************************************************************************************** */
generate formal=(group>1);
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
log using tstat_pub, replace;
local Tstat 
tax_evasion mgmt_time bribes days_power days_water days_teleph days_transp theft security protection reported conflict days_solve;

generate group1=(group==4);
generate group2=(group==2);

foreach l in `Tstat'  {;
	display "`l'";
	quietly: count if (`l'~=. & group1==1);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (`l'~=. & group2==1);
	if r(N)==0 {;
			continue;
	};
	ttest `l' if (group1==1 | group2==1), by(group2);
};


log close;
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
collapse (mean) `X' , by(group);
xpose, clear varname;
save output, replace;
/* ************************************************************************************************************** */
use tmp, clear;
collapse (mean) `X' , by(country year file);
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
local Tstat 
tax_evasion mgmt_time bribes days_power days_water days_teleph days_transp theft security protection reported conflict days_solve ;

log using tstat_pub, replace;

foreach l in `Tstat'  {;
	display "`l'";
	quietly: count if (`l'~=. & file==0);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (`l'~=. & file==1);
	if r(N)==0 {;
			continue;
	};
	ttest `l', by(file);
};


log close;
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
collapse (mean) `X' , by(file);
xpose, clear varname;
rename v1 formal;
rename v2 informal;

joinby _varname using output;

edit _varname v1 v2 informal v3 v4 v5 formal;
/* ************************************************************************************************************** */
#delimit cr
set more off
use nick10, clear
keep if type=="Micro"
generate income_pc=exp(gdp_pc_usd)
generate s=ln((s_l*(1+employees))/income_pc)
generate lab_emp=(labor_cost/100)*sales/employees
generate w=(lab_emp/income_pc)
replace capacity=capacity/100
replace buil_own=buil_own/100
replace mgr_primary=mgr_primary/100
replace mgr_secondary=mgr_secondary/100
replace mgr_vocational=mgr_vocational/100
replace mgr_college=mgr_college/100
replace wkr_primary=wkr_primary/100
replace wkr_secondary=wkr_secondary/100
replace wkr_college=wkr_college/100
replace finance_int=finance_int/100
replace fin_trade=fin_trade/100
replace fin_family=fin_family/100
replace finance_bnk=finance_bnk/100
replace emp_growth=(1+emp_growth/100)^0.5-1
replace sales_growth=(1+sales_growth/100)^0.5-1
replace mgmt_time=mgmt_time/100
replace bribes=bribes/100
replace tax_evasion=tax_evasion/100
replace security=security/100
replace protection=protection/100
replace theft=theft/100
replace reported=reported/100
/* ************************************************************************************************************** */
generate group=0 if microinformal==1
replace  group=1 if microformal==1
replace  group=size_new+1 if enterprise_survey==1
replace  group=2 if size_new==. & (enterprise_survey==1) & employees<20
replace  group=4 if size_new==. & (enterprise_survey==1) & employees>100 & employees~=.
replace  group=3 if size_new==. & (enterprise_survey==1) & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)
/* ************************************************************************************************************** */
bysort code year: egen cap=pctile(sales), p(95)
replace sales=cap if sales>=cap & sales~=.
drop cap

generate comp=.
replace  comp=comp_full if formal==0

replace  comp=comp_perm if formal==1
replace  comp=comp_emp  if formal==1 & comp==.

replace  comp=(comp/income_pc)


sort code year

foreach var in  "comp" "w" "lab_emp" {
	by code year: egen cap=pctile(`var'), p(95)
	replace `var'=cap if `var'>cap & `var'~=.
	drop cap
}

table country, c(mean w mean comp mean lab_emp  mean labor_cost mean income_pc)

#delimit ;

local X 
days_power
freq_power
days_water
days_teleph
days_transp


mgmt_time
bribes
tax_evasion


security
protection
theft
reported
days_solve
conflict
court
;

save tmp, replace;

collapse (mean) `X' , by(country year group);

generate formal=0;
replace  formal=1 if group>0;
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
local Tstat 
freq_power theft security conflict court days_solve mgmt_time bribes tax_evasion;
log using tstat_pub, replace;

generate group1=(group==2);
generate group2=(group==4);

foreach l in `Tstat'  {;
	display "`l'";
	quietly: count if (`l'~=. & group1==1);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (`l'~=. & group2==1);
	if r(N)==0 {;
			continue;
	};
	ttest `l' if (group1==1 | group2==1), by(group2);
};

log close;
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
collapse (mean) `X' , by(group);
xpose, clear varname;
save output, replace;
/* ************************************************************************************************************** */
use tmp, clear;
collapse (mean) `X' , by(country year file);
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
local Tstat 
freq_power theft security conflict court days_solve mgmt_time bribes tax_evasion;

log using tstat_pub, replace;

foreach l in `Tstat'  {;
	display "`l'";
	quietly: count if (`l'~=. & file==0);
	if r(N)==0 {;
		continue;
	};
	quietly: count if (`l'~=. & file==1);
	if r(N)==0 {;
			continue;
	};
	ttest `l', by(file);
};


log close;
/* ************************************************************************************************************** */
collapse (mean) `X' , by(file);
xpose, clear varname;

rename v1 formal;
rename v2 informal;

joinby _varname using output;

edit _varname v1 v2 informal v3 v4 v5 formal;
