clear
set memory 500000
set matsize 5000
set more off
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
cd  "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick\Brookings Submission\Stata"
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
use nick10, clear
keep if type=="Informal"
drop if country=="Cameroon"
sort code
/* ************************************************************************************************************** */
merge code using ppp_conversion_formatted
drop if _merge==2
tabulate _merge
drop _merge

replace va=va-ln(ppp_factor_2003) if country=="Bangladesh"
replace va=va-ln(ppp_factor_2003) if country=="Brazil"
replace va=va-ln(ppp_factor_2003) if country=="Cambodia"
replace va=va-ln(ppp_factor_2006) if country=="Cape Verde"
replace va=va-ln(ppp_factor_2003) if country=="Guatemala"
replace va=va-ln(ppp_factor_2002) if country=="India"
replace va=va-ln(ppp_factor_2003) if country=="Indonesia"
replace va=va-ln(ppp_factor_2003) if country=="Kenya"
replace va=va-ln(ppp_factor_2005) if country=="Niger"
replace va=va-ln(ppp_factor_2003) if country=="Pakistan"
replace va=va-ln(ppp_factor_2003) if country=="Senegal"
replace va=va-ln(ppp_factor_2003) if country=="Tanzania"
replace va=va-ln(ppp_factor_2003) if country=="Uganda"
/* ************************************************************************************************************** */
replace sl=sl-ln(ppp_factor_2003) if country=="Bangladesh"
replace sl=sl-ln(ppp_factor_2003) if country=="Brazil"
replace sl=sl-ln(ppp_factor_2003) if country=="Cambodia"
replace sl=sl-ln(ppp_factor_2006) if country=="Cape Verde"
replace sl=sl-ln(ppp_factor_2003) if country=="Guatemala"
replace sl=sl-ln(ppp_factor_2002) if country=="India"
replace sl=sl-ln(ppp_factor_2003) if country=="Indonesia"
replace sl=sl-ln(ppp_factor_2003) if country=="Kenya"
replace sl=sl-ln(ppp_factor_2005) if country=="Niger"
replace sl=sl-ln(ppp_factor_2003) if country=="Pakistan"
replace sl=sl-ln(ppp_factor_2003) if country=="Senegal"
replace sl=sl-ln(ppp_factor_2003) if country=="Tanzania"
replace sl=sl-ln(ppp_factor_2003) if country=="Uganda"
/* ************************************************************************************************************** */
generate tmp=exp(va)
generate va_klenow=((1+employees)*exp(va))^1.5/(1+employees)
replace  va_klenow=ln(va_klenow)
drop tmp
generate tmp=exp(sl)
generate sl_klenow=((1+employees)*exp(sl))^1.5/(1+employees)
replace  sl_klenow=ln(sl_klenow)
/* ************************************************************************************************************** */
pwcorr va_klenow va
pwcorr sl_klenow sl
/* ************************************************************************************************************** */
generate group=0 if informalsurvey==1 & registered_ctral==0
replace  group=1 if informalsurvey==1 & registered_ctral==1
replace  group=size_new+1 if informalsurvey==0
replace  group=2 if size_new==. & formal==1 & employees<20
replace  group=4 if size_new==. & formal==1 & employees>100 & employees~=.
replace  group=3 if size_new==. & formal==1 & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)
/* ************************************************************************************************************** */
replace year=2003 if year==2002 & country=="Pakistan"
replace year=2004 if year==2003 & country=="Senegal"
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
replace va=va_klenow
replace sl=sl_klenow
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
keep size country year va sl our_sic formal code microinformal group file

save tmp_inf, replace
/* ************************************************************************************************************** */
log using descrip_inf, replace
	generate group1=(group==0)
	generate group2=(group==4)

	foreach Z in "Bangladesh" "Brazil" "Cambodia" "Cape Verde" "Guatemala" "India" "Indonesia" "Kenya" "Niger" "Pakistan" "Senegal" "Tanzania" "Uganda" {
	display  "`Z'"   
	quietly: count if (va~=. & country=="`Z'" & group1==1)
	if r(N)==0 {
			continue
	}
	quietly: count if (va~=. & country=="`Z'" & group2==1)
	if r(N)==0 {
			continue
	}
	ttest va if (group1==1 | group2==1) & country=="`Z'", by(group2)
	}

	display "ALL"
	ttest va if (group1==1 | group2==1), by(group2)

	foreach Z in "Bangladesh" "Brazil" "Cambodia" "Cape Verde" "Guatemala" "India" "Indonesia" "Kenya" "Niger" "Pakistan" "Senegal" "Tanzania" "Uganda" {
	display  "`Z'"   
	quietly: count if (sl~=. & country=="`Z'" & group1==1)
	if r(N)==0 {
			continue
	}
	quietly: count if (sl~=. & country=="`Z'" & group2==1)
	if r(N)==0 {
			continue
	}
	ttest sl if (group1==1 | group2==1) & country=="`Z'", by(group2)
	}
	display "ALL"
	ttest sl if (group1==1 | group2==1), by(group2)
log close
/* ************************************************************************************************************** */
local X sl
foreach x in `X'  {
	use tmp_inf, clear
	collapse (mean) `x' (count) Obs=`x', by(group country year)

	reshape wide `x' Obs, i(country year) j(group)
	keep if `x'0~=.
	keep if `x'1~=. | `x'2~=. | `x'3~=. | `x'4~=. 


	sort country year 
	save desc_inf_`x', replace

	use tmp_inf, clear
	collapse (mean) `x', by(country year file)

	reshape wide `x', i(country year) j(file)
	rename `x'0 `x'_formal
	rename `x'1 `x'_inform

	sort country year 
	merge country year using desc_inf_`x'
	keep if `x'1~=. | `x'2~=. | `x'3~=. 
	keep if _merge==3
	drop _merge 
	generate Obs_Formal=Obs2+Obs3+Obs4
	edit country year `x'0 `x'1 `x'_inform `x'2 `x'3 `x'4 `x'_formal 
}
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
use nick10, clear
keep if type=="Micro"
sort code
/* ************************************************************************************************************** */
merge code using ppp_conversion_formatted
drop if _merge==2
tabulate _merge
drop _merge
/* ************************************************************************************************************** */
replace sl=sl-ln(ppp_factor_2006) if country=="Angola"
replace sl=sl-ln(ppp_factor_2006) if country=="Botswana"
replace sl=sl-ln(ppp_factor_2006) if country=="Burundi"
replace sl=sl-ln(ppp_factor_2006) if country=="Congo, Dem. Rep."
replace sl=sl-ln(ppp_factor_2006) if country=="Gambia, The"
replace sl=sl-ln(ppp_factor_2006) if country=="Guinea"
replace sl=sl-ln(ppp_factor_2006) if country=="Guinea-Bissau"
replace sl=sl-ln(ppp_factor_2006) if country=="India"
replace sl=sl-ln(ppp_factor_2006) if country=="Mauritania"
replace sl=sl-ln(ppp_factor_2006) if country=="Namibia"
replace sl=sl-ln(ppp_factor_2006) if country=="Rwanda"
replace sl=sl-ln(ppp_factor_2006) if country=="Swaziland"
replace sl=sl-ln(ppp_factor_2006) if country=="Tanzania"
replace sl=sl-ln(ppp_factor_2006) if country=="Uganda"
/* ************************************************************************************************************** */
replace va=va-ln(ppp_factor_2006) if country=="Angola"
replace va=va-ln(ppp_factor_2006) if country=="Botswana"
replace va=va-ln(ppp_factor_2006) if country=="Burundi"
replace va=va-ln(ppp_factor_2006) if country=="Congo, Dem. Rep."
replace va=va-ln(ppp_factor_2006) if country=="Gambia, The"
replace va=va-ln(ppp_factor_2006) if country=="Guinea"
replace va=va-ln(ppp_factor_2006) if country=="Guinea-Bissau"
replace va=va-ln(ppp_factor_2006) if country=="India"
replace va=va-ln(ppp_factor_2006) if country=="Mauritania"
replace va=va-ln(ppp_factor_2006) if country=="Namibia"
replace va=va-ln(ppp_factor_2006) if country=="Rwanda"
replace va=va-ln(ppp_factor_2006) if country=="Swaziland"
replace va=va-ln(ppp_factor_2006) if country=="Tanzania"
replace va=va-ln(ppp_factor_2006) if country=="Uganda"
/* ************************************************************************************************************** */
generate tmp=exp(va)
generate va_klenow=((1+employees)*exp(va))^1.5/(1+employees)
replace  va_klenow=ln(va_klenow)
drop tmp
generate tmp=exp(sl)
generate sl_klenow=((1+employees)*exp(sl))^1.5/(1+employees)
replace  sl_klenow=ln(sl_klenow)
/* ************************************************************************************************************** */
pwcorr va_klenow va
pwcorr sl_klenow sl
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
replace va=va_klenow
replace sl=sl_klenow
/* ************************************************************************************************************** */
/* ************************************************************************************************************** */
generate group=0 if microinformal==1
replace  group=1 if microformal==1
replace  group=size_new+1 if enterprise_survey==1
replace  group=2 if size_new==. & (enterprise_survey==1) & employees<20
replace  group=4 if size_new==. & (enterprise_survey==1) & employees>100 & employees~=.
replace  group=3 if size_new==. & (enterprise_survey==1) & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)
/* ************************************************************************************************************** */
keep size country year va sl our_sic formal code microinformal group file

save tmp_mic, replace
/* ************************************************************************************************************** */
log using descrip_mic, replace
	generate group1=(group==0)
	generate group2=(group==4)
	foreach Z in "Angola" "Botswana" "Burundi" "Congo, Dem. Rep." "Gambia, The" "Guinea" "Guinea-Bissau" "India" "Mauritania" "Namibia" "Rwanda" "Swaziland" "Tanzania" "Uganda"  {

	display  "`Z'"   
	quietly: count if (va~=. & country=="`Z'" & group1==1)
	if r(N)==0 {
			continue
	}
	quietly: count if (va~=. & country=="`Z'" & group2==1)
	if r(N)==0 {
			continue
	}
	ttest va if (group1==1 | group2==1) & country=="`Z'", by(group2)
	}

	display "ALL"
	ttest va if (group1==1 | group2==1), by(group2)

	foreach Z in "Angola" "Botswana" "Burundi" "Congo, Dem. Rep." "Gambia, The" "Guinea" "Guinea-Bissau" "India" "Mauritania" "Namibia" "Rwanda" "Swaziland" "Tanzania" "Uganda"  {
	display  "`Z'"   
	quietly: count if (sl~=. & country=="`Z'" & group1==1)
	if r(N)==0 {
			continue
	}
	quietly: count if (sl~=. & country=="`Z'" & group2==1)
	if r(N)==0 {
			continue
	}
	ttest sl if (group1==1 | group2==1) & country=="`Z'", by(group2)
	}
	display "ALL"
	ttest sl if (group1==1 | group2==1), by(group2)
log close
/* ************************************************************************************************************** */
local X sl
foreach x in `X'  {
	use tmp_mic, clear
	collapse (mean) `x' (count) Obs=`x', by(group country year)

	reshape wide `x' Obs, i(country year) j(group)
	keep if `x'0~=.
	keep if `x'1~=. | `x'2~=. | `x'3~=. | `x'4~=. 

	sort country year 
	save desc_mic_`x', replace

	use tmp_mic, clear
	collapse (mean) `x', by(country year file)
	reshape wide `x', i(country year) j(file)
	rename `x'0 `x'_formal
	rename `x'1 `x'_inform

	sort country year 

	merge country year using desc_mic_`x'
	keep if `x'1~=. | `x'2~=. | `x'3~=. 
	keep if _merge==3
	drop _merge 
	generate Obs_Formal=Obs2+Obs3+Obs4
	edit country year `x'0 `x'1 `x'_inform `x'2 `x'3 `x'4 `x'_formal 
}
/* ************************************************************************************************************** */
