clear
set more off
set mem 90000
/* ************************************************************************************************************** */
cd "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick"
/* ************************************************************************************************************** */
use nick10.dta, clear
 
drop if country=="Cameroon"
generate income=ln(gdp_pc_ppp)

replace exp_land =exp_land/100
replace exp_rent =exp_rent/100
/* ******************************************************************************* */
log using cambridge, replace
eststo clear
eststo: xi: dprobit registered_ctral 	i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, replace bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit loan_ever			i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit buyer_largefirm 	i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit permstructure 		i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit inownershouse 		i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit buil_own 			i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit land_own 			i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit own_transp 		i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit generator 		i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit email 			i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit website 			i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: dprobit electricalconnection 	i.mgr_educ i.our_sic income, robust cluster(code)
outreg2 using panel_a, append bdec(4) symbol(a,b,c) excel
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

/* ******************************************************************************* */
esttab using probit.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace
eststo clear

su exp_raw capacity


eststo: xi: regress finance_int 	i.mgr_educ i.our_sic income, robust cluster(code)
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: regress exp_raw 		i.mgr_educ i.our_sic income, robust cluster(code)
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: regress exp_ene 		i.mgr_educ i.our_sic income, robust cluster(code)
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: regress exp_mach 		i.mgr_educ i.our_sic income, robust cluster(code)
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

eststo: xi: regress capacity 		i.mgr_educ i.our_sic income, robust cluster(code)
test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

* eststo: xi: regress hours 		i.mgr_educ i.our_sic income, robust cluster(code)
* test  _Imgr_educ_2  _Imgr_educ_3  _Imgr_educ_4

esttab using ols.csv, compress  se b(4) se(4) star(c 0.10 b 0.05 a 0.01) onecell mtitles replace


log close
