clear
set memory 500000
set matsize 5000
set more off
/* ************************************************************************************************************** */
cd "C:\Documents and Settings\Rafael.LaPorta\My Documents\InformalEconomy\Nick\Brookings Submission\Stata"
/* ************************************************************************************************************** */
use nick10, clear
keep if type=="Informal"
drop if country=="Cameroon"

sort code
/* ************************************************************************************************************** */
merge code using ppp_conversion_formatted
drop if _merge==2
drop _merge

replace sales=sales/ppp_factor_2003 if country=="Bangladesh"
replace sales=sales/ppp_factor_2003 if country=="Brazil"
replace sales=sales/ppp_factor_2003 if country=="Cambodia"
replace sales=sales/ppp_factor_2006 if country=="Cape Verde"
replace sales=sales/ppp_factor_2003 if country=="Guatemala"
replace sales=sales/ppp_factor_2002 if country=="India"
replace sales=sales/ppp_factor_2003 if country=="Indonesia"
replace sales=sales/ppp_factor_2003 if country=="Kenya"
replace sales=sales/ppp_factor_2005 if country=="Niger"
replace sales=sales/ppp_factor_2003 if country=="Pakistan"
replace sales=sales/ppp_factor_2003 if country=="Senegal"
replace sales=sales/ppp_factor_2003 if country=="Tanzania"
replace sales=sales/ppp_factor_2003 if country=="Uganda"

replace year=2003 if country=="Pakistan" & year==2002
replace year=2003 if country=="Senegal"  & year==2004
/* ************************************************************************************************************** */
generate group=0 if informalsurvey==1 & registered_ctral==0
replace  group=1 if informalsurvey==1 & registered_ctral==1
replace  group=size_new+1 if informalsurvey==0
replace  group=2 if size_new==. & formal==1 & employees<20
replace  group=4 if size_new==. & formal==1 & employees>100 & employees~=.
replace  group=3 if size_new==. & formal==1 & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)
/* ************************************************************************************************************** */
bysort code year file: egen cap=pctile(sales), p(95)
replace sales=cap if sales>=cap & sales~=.
drop cap

#delimit ;
local X gdp_pc_usd sales s employees;

save tmp, replace;
collapse (mean) sales gdp_pc_ppp  (count) obs=sales, by(country year group);
reshape wide sales obs gdp_pc_ppp, i(country year) j(group);
sort country year;
save output, replace;
use tmp, clear;
collapse (mean) sales gdp_pc_ppp (count) obs=sales, by(country year file);
reshape wide sales obs gdp_pc_ppp, i(country year) j(file);
rename sales0 sales_for;
rename obs0 obs_for;

rename sales1 sales_inf;
rename obs1 obs_inf;

sort country year;
merge country year using output;
edit country year sales0 obs0 sales1 obs1 sales_inf obs_inf sales2 obs2 sales3 obs3 sales4 obs4 sales_for obs_for gdp_pc_ppp*;

* collapse (mean) `X' (count) obs=sales, by(group);
* xpose, clear varname;
* save output, replace;

* use tmp, clear;
* collapse (mean) `X' (median) median_s=sales median_e=employees, by(country year file);
* collapse (mean) `X' (median) median_s=sales median_e=employees, by(file);
* xpose, clear varname;

* rename v1 formal;
* rename v2 informal;

* joinby _varname using output;

* edit _varname v1 v2 informal v3 v4 v5 formal;
/* ************************************************************************************************************** */
#delimit cr
use nick10, clear
keep if type=="Micro"

sort code
/* ************************************************************************************************************** */
merge code using ppp_conversion_formatted
tabulate _merge
drop if _merge==2
drop _merge

replace sales=sales/ppp_factor_2006 if country=="Angola"
replace sales=sales/ppp_factor_2006 if country=="Botswana"
replace sales=sales/ppp_factor_2006 if country=="Burundi"
replace sales=sales/ppp_factor_2006 if country=="Congo, Dem. Rep."
replace sales=sales/ppp_factor_2006 if country=="Gambia, The"
replace sales=sales/ppp_factor_2006 if country=="Guinea"
replace sales=sales/ppp_factor_2006 if country=="Guinea-Bissau"
replace sales=sales/ppp_factor_2006 if country=="India"
replace sales=sales/ppp_factor_2006 if country=="Mauritania"
replace sales=sales/ppp_factor_2006 if country=="Namibia"
replace sales=sales/ppp_factor_2006 if country=="Rwanda"
replace sales=sales/ppp_factor_2006 if country=="Swaziland"
replace sales=sales/ppp_factor_2006 if country=="Tanzania"
replace sales=sales/ppp_factor_2006 if country=="Uganda"
/* ************************************************************************************************************** */
egen big=rowmax(sales_customers sales_traders sales_smallbus sales_largebus sales_other)
replace buyer_largefirm=(sales_largebus==big) if (buyer_largefirm==.) & (sales_largebus+big~=.)

drop big
egen big=rowmax(salesgovt salesstateowned salesmnc salesparent saleslarge salesother)
replace buyer_largefirm=(saleslarge==big) if (buyer_largefirm==.) & (saleslarge+big~=.)
drop big
/* ************************************************************************************************************** */
generate group=0 if microinformal==1
replace  group=1 if microformal==1
replace  group=size_new+1 if enterprise_survey==1
replace  group=2 if size_new==. & (enterprise_survey==1) & employees<20
replace  group=4 if size_new==. & (enterprise_survey==1) & employees>100 & employees~=.
replace  group=3 if size_new==. & (enterprise_survey==1) & employees>=20 & employees<100 
/* ************************************************************************************************************** */
generate file=(group<2)

bysort code year file: egen cap=pctile(sales), p(95)
replace sales=cap if sales>=cap & sales~=.
drop cap

#delimit ;
local X gdp_pc_usd sales s employees;

save tmp, replace;
collapse (mean) sales gdp_pc_ppp  (count) obs=sales, by(country year group);
reshape wide sales obs gdp_pc_ppp , i(country year) j(group);
sort country year;
save output, replace;
use tmp, clear;
collapse (mean) sales gdp_pc_ppp (count) obs=sales, by(country year file);
reshape wide sales obs gdp_pc_ppp , i(country year) j(file);
rename sales0 sales_for;
rename obs0 obs_for;

rename sales1 sales_inf;
rename obs1 obs_inf;

sort country year;
merge country year using output;
edit country year sales0 obs0 sales1 obs1 sales_inf obs_inf sales2 obs2 sales3 obs3 sales4 obs4 sales_for obs_for gdp_pc_ppp*;
