/****************************************************************************************
This file performs simple regressions relating the S&P 500 stock index to the price of 
oil. Data come from Global Financial Data.
Modified by POG. 11/09/08
****************************************************************************************/

clear
#delimit;
set more off;
set mem 5m;
cd "d:\pog\ricardo\bpea\pog\";

use crude;
qui sort date;

merge date using dates;
tab _m;
drop _m;
sort date;
save x, replace;

use SP500;
qui sort date;
merge date using x;
tab _m;
drop _m;
sort date;
save x, replace;


use ip;
qui sort date;
merge date using x;
tab _m;
drop _m;
sort date;
save x, replace;

/**********
use gdpr;
qui sort date;
merge date using x;
tab _m;
drop _m;
sort date;
save x, replace;
**************/

**Format dates, create flag for business day;
sort date;
drop if date>d(08/11/2008);

gen DoW = dow(date)+1;
label define DoW_label 1 "Sunday" 2 "Monday" 3 "Tuesday" 4 "Wednesday" 5 "Thursday"
6 "Friday" 7 "Saturday";
label values DoW DoW_label;

tsset date;

qui gen day = day(date);
qui gen month = month(date);
qui gen year = year(date);


qui gen daily_flag = 0;
qui replace daily_flag = 1 if crude<. & SP500<.;


qui gen weekly_flag = 0;
qui replace weekly_flag = 1 if DoW == 6;
qui gen monthly_flag = 0;
qui replace monthly_flag = 2 if f.day == 1;
**qui gen annual_flag = 0;
**qui replace annual_flag = 1 if month == 12 & day == 31;
qui gen quarterly_flag = monthly_flag*3/2;
qui gen annual_flag = monthly_flag*12/2;



foreach var of varlist crude SP500 ipi {;
	qui replace `var' = l.`var' if `var'==.;
};


/****************************************************************************************
Regressions. Note that daily price data begin 4/4/1983, so regressions are 1984-2008
****************************************************************************************/

keep if year>=1984;
**keep if date<d(1/7/2008);
**keep if date>=d(1/7/2008);
sort date;
save x, replace;

**twoway (scatter crude SP500 if date>d(1/7/2007) & date<=d(1/7/2008))||(scatter crude SP500 if date>d(1/7/2008))||(scatter crude SP500 if date<=d(1/7/2007) & date>=d(1/1/2004));
**graph2tex, epsfile(cov2);


**Daily;
keep if daily_flag == 1;
foreach var of varlist SP500 crude {;
	gen d`var' = ln(`var'/`var'[_n-1]);
	drop `var';
	rename d`var' `var';
};
reg crude SP500, robust;
outreg using stock_market_temp, title("Table. Oil-Stock Market Regressions") ctitle("daily")
nonotes noparen noaster replace bdec(5) rdec(5);


**Weekly;
use x, clear;
keep if weekly_flag == 1;
foreach var of varlist SP500 crude {;
	gen d`var' = ln(`var'/`var'[_n-1]);
	drop `var';
	rename d`var' `var';
};
reg crude SP500, robust;
outreg using stock_market_temp, append ctitle("Weekly") nonotes noparen noaster bdec(5) rdec(5);

**Monthly;
use x, clear;
keep if monthly_flag == 2;
foreach var of varlist SP500 crude ipi {;
	gen d`var' = ln(`var'/`var'[_n-1]);
	drop `var';
	rename d`var' `var';
};
reg crude SP500 ipi, robust;
outreg using stock_market_temp, append ctitle("monthly") nonotes noparen noaster bdec(5) rdec(5);


**Quarterly;
use x, clear;
keep if quarterly_flag == 3;
foreach var of varlist SP500 crude ipi {;
	gen d`var' = ln(`var'/`var'[_n-3]);
	drop `var';
	rename d`var' `var';
};
gen date2 = _n;
tsset date2;
newey crude SP500 ipi, lag(2);
tsset, clear;
outreg using stock_market_temp, append ctitle("quarterly") nonotes noparen noaster bdec(5) rdec(5);


**annual;
use x, clear;
keep if annual_flag == 12;
foreach var of varlist SP500 crude ipi {;
	gen d`var' = ln(`var'/`var'[_n-12]);	
	drop `var';
	rename d`var' `var';
};
gen date2 = _n;
tsset date2;
newey crude SP500 ipi, lag(11);
tsset, clear;
outreg using stock_market_temp, append ctitle("annual") nonotes noparen noaster bdec(5) rdec(5);


**Regressions with lags;


foreach freq in daily weekly monthly quarterly annual {;
**foreach freq in daily weekly {;
	use x, clear;
	keep if `freq'_flag != 0;
	foreach var of varlist SP500 crude ipi {;
		gen d`var' = ln(`var'/`var'[_n-1]);
		replace d`var' = ln(`var'/`var'[_n-3]) if `freq'_flag == 3;
		replace d`var' = ln(`var'/`var'[_n-12]) if `freq'_flag == 12;	
		drop `var';
		rename d`var' `var';
	};
	qui gen l_SP500 = SP500[_n-1];
	qui gen l_ipi = ipi[_n-1];

	if `freq'_flag==1 {;
		reg crude SP500 l_SP500, robust;
	};
	else if `freq'_flag==2 {;
		reg crude SP500 l_SP500 ipi l_ipi, robust;
	};
	else if `freq'_flag==3 {;
		gen date2 = _n;
		tsset date2; 
		newey crude SP500 l_SP500 ipi l_ipi, lag(2);
		tsset, clear;
	};
	else {;
		gen date2 = _n;
		tsset date2;
		newey crude SP500 l_SP500 ipi l_ipi, lag(11);
		tsset, clear;
	};
	outreg using stock_market_temp, append ctitle("`freq'") nonotes noparen noaster bdec(5) rdec(5);
};
