/****************************************************************************************
This file performs simple regressions relating the S&P 500 stock index to the price of 
oil. Data come from Global Financial Data. It uses the price of gold and S&P financials
to instrument for the S&P 500. 
****************************************************************************************/

clear
#delimit;
set more off;
set mem 5m;
cd "d:\pog\ricardo\bpea\pog\";

use crude;
qui sort date;


merge date using dates;
tab _m;
drop _m;
sort date;
save x, replace;
clear;


foreach var in SP500 SPfin gold ip vox {;
	use `var';
	qui sort date;
	merge date using x;
	drop _m;
	sort date;
	save x, replace;
	clear;
};

/********************
use merrill-lynch;
rename day date;
sort date;
merge date using x;
drop _m;
sort date;
label variable mlcximer "Industrial metals";
label variable mlcxgrer "Grains et al";
*******************/

**Format dates, create flag for business day;
use x;
sort date;
drop if date>d(08/11/2008);

gen DoW = dow(date)+1;
label define DoW_label 1 "Sunday" 2 "Monday" 3 "Tuesday" 4 "Wednesday" 5 "Thursday"
6 "Friday" 7 "Saturday";
label values DoW DoW_label;

tsset date;

qui gen day = day(date);
qui gen month = month(date);
qui gen year = year(date);

qui gen daily_flag = 0;
qui replace daily_flag = 1 if crude<. & SP500<. & gold<. & spfin<.;
qui gen weekly_flag = 0;
qui replace weekly_flag = 1 if DoW == 6;
qui gen monthly_flag = 0;
qui replace monthly_flag = 2 if f.day == 1;
qui gen quarterly_flag = monthly_flag*3/2;
qui gen annual_flag = monthly_flag*12/2;


**qui gen quarterly_flag = 0;
**qui replace quarterly_flag = 1 if mod(month,3)==0 & f.day==1;
**qui gen annual_flag = 0;
**qui replace annual_flag = 1 if month == 12 & day == 31;


foreach var of varlist crude SP500 gold spfin ipi vox {;
	qui replace `var' = l.`var' if `var'==.;
};
tsset, clear;

/**********************************************************************Regressions. 
**********************************************************************/

foreach depvar in crude {;

keep if year>=1984;
**keep if date<=d(30/6/2008);
**keep if date>=d(1/7/2008);

save x, replace;

**Daily;
keep if daily_flag == 1;
foreach var of varlist SP500 `depvar' spfin gold vox {;
	gen d`var' = ln(`var'/`var'[_n-1]);
	drop `var';
	rename d`var' `var';
};
gen Financials = spfin - SP500;
ivreg `depvar' (SP500 = Financials gold vox), robust;
outreg using iv_stock_market_`depvar', title("`depvar'") 
ctitle("daily") nonotes noparen noaster bdec(4) replace;


**Weekly, monthly, quarterly, annual;
foreach freq in weekly monthly quarterly annual {;
**foreach freq in weekly {;
	use x, clear;
	keep if `freq'_flag != 0;
	foreach var of varlist SP500 `depvar' spfin gold ipi vox {;
		gen d`var' = ln(`var'/`var'[_n-1]);
		replace d`var' = ln(`var'/`var'[_n-3]) if `freq'_flag == 3;
		replace d`var' = ln(`var'/`var'[_n-12]) if `freq'_flag == 12;	
		drop `var';
		rename d`var' `var';
	};
	gen Financials = spfin - SP500;
	if `freq'_flag==1 {;
		ivreg `depvar' (SP500 = Financials gold vox), robust;
	};
	else if `freq'_flag==2 {;
		ivreg `depvar' (SP500 = Financials gold vox) ipi, robust;
	};
	else if `freq'_flag==3 {;
		sort date;
		gen date2 = _n;
		tsset date2; 
		newey2 `depvar' (SP500 = Financials gold vox) ipi, lag(2);
		tsset, clear;
	};
	else {;
		sort date;
		gen date2 = _n;
		tsset date2;
		newey2 `depvar' (SP500 = Financials gold vox) ipi, lag(11);
		tsset, clear;
	};
	outreg using iv_stock_market_`depvar', append ctitle("`freq'") nonotes noparen noaster bdec(4);
};


**First stage regressions;
foreach freq in daily {;
	use x, clear;
	keep if `freq'_flag == 1;
	foreach var of varlist SP500 spfin gold vox {;
		gen d`var' = ln(`var'/`var'[_n-1]);
		drop `var';
		rename d`var' `var';
	};
	gen Financials = spfin - SP500;
	reg SP500 Financials gold vox, robust;
	outreg using 1S_stock_market_`depvar', replace ctitle("`freq'") nonotes noparen noaster 
	title("First Stage Regressions for S&P 500") bdec(4);
};

foreach freq in weekly monthly quarterly annual {;
**foreach freq in weekly {;
	use x, clear;
	keep if `freq'_flag != 0;
	foreach var of varlist SP500 `depvar' spfin gold ipi vox {;
		gen d`var' = ln(`var'/`var'[_n-1]);
		replace d`var' = ln(`var'/`var'[_n-3]) if `freq'_flag == 3;
		replace d`var' = ln(`var'/`var'[_n-12]) if `freq'_flag == 12;	
		drop `var';
		rename d`var' `var';
	};
	gen Financials = spfin - SP500;
	if `freq'_flag==1 {;
		reg SP500 Financials gold vox, robust;
	};
	else if `freq'_flag==2 {;
		reg SP500 Financials gold vox, robust;
	};
	else if `freq'_flag==3 {;
		gen date2 = _n;
		tsset date2; 
		newey SP500 Financials gold vox, lag(2);
		tsset, clear;
	};
	else {;
		gen date2 = _n;
		tsset date2;
		newey SP500 Financials gold vox, lag(11);
		tsset, clear;
	};
	outreg using 1S_stock_market_`depvar', append ctitle("`freq'") nonotes noparen noaster bdec(4); 
};
};

