* transportation.do
* Prepare transportation data
* Joshua Gottlieb (jdgottl@fas.harvard.edu), 2/13/08

************************************************************
*** Top airports from BTS Airport Activity Statistics, compiled by Nina Tobio
************************************************************

use airports
gen msa = cmsapmsa
replace msa = necma if !mi(necma)
lab var msa "MSA"
sort msa
drop if mi(msa)

replace top_20_dummy = 0 if mi(top_20_dummy)
replace top_50_dummy = 0 if mi(top_50_dummy)

lab var top_20_dummy "Top 20 airport"
lab var top_50_dummy "Top 50 airport"

foreach year in 1995 2004 2005 {
	ren boardings_`year' boardings`year'
	lab var boardings`year' "Airplane boardings, `year'"
}

label data "Airport data from BTS Airport Activity Statistics"
save airports2, replace

foreach var of varlist boardings* top* {
	local l`var': var lab `var'
}

collapse (rawsum) boardings* (max) top*, by(msa)

foreach var of varlist boardings* top* {
	lab var `var' "`l`var''"
}

sort msa
label data "Airport data from BTS Airport Activity Statistics"
save msaairports, replace

************************************************************
*** Prepare the Baum-Snow highway data
************************************************************

use msa-final, clear
unab hwyvars: lena-raccytot rays_planm-cong
keep msa year `hwyvars'

foreach var of varlist `hwyvars' {
	local l`var': var lab `var'
}

reshape i msa
reshape j year
reshape xij `hwyvars'
reshape xi
reshape query
reshape wide

foreach var in `hwyvars' {
	forvalues yr=50(10)90 {
		lab var `var'`yr' "`l`var'', 19`yr'"
	}
}

sort msa
save BaumSnowMSAhighways, replace

************************************************************
*** 1850/1860 transportation availability data by county from Craig, Palmquist and Weiss (1998)
************************************************************

forvalues year = 1850(10)1860 {
	insheet using `trans'Craig-Transport-Data-`year'.csv, comma names clear

	gen cntyfips = floor(countycode / 10)
	drop if cntyfips != countycode / 10

	do ~/urban/geography/county-change-code.do

	gen fips = 1000 * statefips + cntyfips
	drop state statefips cntyfips countycode county

	ren stateabbrev state
	lab var state "State"

	order fips
	sort fips
	lab var fips "FIPS State/County Code"

	foreach var of varlist water rail ocean lake {
		ren `var' `var'`year'
		local varlab: var lab `var'
		lab var `var' "County on `varlab', `year' (Craig)"
	}

	tempfile transdata`year'
	label data "Transportation data from Craig, Palmquist and Weiss (1998)"
	save `transdata`year''
}

use `transdata1850'
merge fips using `transdata1860', sort _merge(_t)
tab1 _t
drop _t
sort fips
save `trans'Craig-Transport-Data, replace





