* ipumsts.do
* IPUMS time-series (repeated panel) wage regressions
* Edward L. Glaeser (eglaeser@harvard.edu) and Joshua D. Gottlieb (jdgottl@fas.harvard.edu),
* Brookings Papers on Economic Activity, Spring 2008

cd ~/urban/ipums/

local census "~/urban/census/"
local bulk "~/bulk/ipums/"

cap log close ipumsts

now
local date = r(date)
local time = r(time)
log using "~/urban/logs/ipumsts_`date'_`time'.log", text replace name(ipumsts)
clear

set more off
set mem 15g
set matsize 800

* I first need a smaller version of the MSA dataset in order to merge it with the IPUMS microdata; 
* merging hundreds of vars with tens of millions of observations doesn't work too well.

use `census'MSAchars99pmsa, clear
keep msa msaname pop1990 pop2000 lpop1970 lpop1990 lpop2000 JanTemp JulTemp Precipitation LogACCRA* houseValLogMedian???? GEO_LAT GEO_LNG pcwi5

* So coefficients are moved over by 2 decimals
replace JanTemp = JanTemp / 100
replace JulTemp = JulTemp / 100

gen popGr90s = lpop2000 - lpop1990
lab var popGr90s "Pop. growth 1990s"

* First agglomeration covariate: above median pop
gen top00 = 1 if pop2000 > 294597.5
replace top00 = 0 if pop2000 < 294597.5
replace top00 = . if mi(pop2000)
lab var top00 "In top half of cities by year 2000 pop"

gen lpop2000Xtop00 = lpop2000 * top00
lab var lpop2000Xtop00 "Log pop 2000 X above median pop 2000"

* First agglomeration covariate: above median pop, 1990
gen top90 = 1 if pop1990 >= 258761
replace top90 = 0 if pop1990 < 258761
replace top90 = . if mi(pop1990)
lab var top90 "In top half of cities by year 1990 pop"

gen lpop2000Xtop90 = lpop2000 * top90
lab var lpop2000Xtop90 "Log pop 2000 X above median pop 1990"

* Second agglomeration covariate: centralization
gen cent = pcwi5
lab var cent "Centralization (% of emp w/i 5mi of CBD)"
su cent, det

gen topcent = 1 if cent > .4997226 & !mi(cent)
replace topcent = 0 if cent <= .4997226
lab var topcent "MSA above median centralization"

gen topcentXpopGr90s = topcent * popGr90s
lab var topcentXpopGr90s "Pop growth 90s X above med. centralization"

* Third agglomeration covariate: prior growth (1970-1990)
gen popGr7090 = lpop1990 - lpop1970
lab var popGr7090 "Pop. growth 70-90"

su popGr7090, det
local gr7090q1 = r(p25)
di "The 25th percentile of pop growth 1970-1990 is `gr7090q1'."

gen popGr7090q1 = 1 if popGr7090 < `gr7090q1'
replace popGr7090q1 = 0 if popGr7090 >= `gr7090q1' & !mi(popGr7090)
lab var popGr7090q1 "In bottom quartile of pop gr. 70-90"

gen lpop2000XpopGr7090q1 = lpop2000 * popGr7090q1
lab var lpop2000XpopGr7090q1 "Log pop 2000 X bottom quartile gr 70-90"

compress
tempfile msadata
save `msadata'

************************************************************************
* Open microdata and run regressions
************************************************************************

* local t = "_001"
local t = ""

di "Using the `t' sample...."

use `bulk'MSAplusMicro90_00`t', clear

sort msa
merge msa using `msadata', _merge(_msacharacteristics)

gen i = 1

gen Linc_r = Linc - houseValLogMedian2000 if yr2000
replace Linc_r = Linc - houseValLogMedian1990 if yr1990
lab var Linc_r "Log real wage"

gen Linc_a = Linc - LogACCRA2000 if yr2000
replace Linc_a = Linc - LogACCRA1990 if yr1990
lab var Linc_a "Log ACCRA wage"

compress

foreach var of varlist lpop1990 lpop2000 JanTemp JulTemp Precipitation GEO_LAT GEO_LNG popGr* top* lpop2000Xtop00 lpop2000Xtop90 cent lpop2000XpopGr7090q1 {
        gen `var'X00 = `var' * yr2000
        local varlab: var lab `var'
        lab var `var'X00 "`varlab' X year 2000"
}

compress

* Prepare some interactions of instruments:

foreach ivar of varlist JanTemp JulTemp Precipitation GEO_LAT GEO_LNG {
	foreach interact of varlist top00 top90 topcent popGr7090q1 {
		gen `ivar'X`interact'X00 = `ivar' * `interact'X00
	}
}


foreach wt of varlist i {
*	foreach ss in "all" "pm" {
*	foreach ss in "all" {
	foreach ss in "pm" {
		if "`ss'" == "pm" {
			local cond = "if pm == 1 & !mi(msa) & msa != 0 & !mi(JanTemp) & !mi(JulTemp) & !mi(Precipitation)"
			local ages = "yr2000 age30s age30s2000 age40s age40s2000 age50s age50s2000 hsdiploma hsdiploma2000 college college2000"
		}
		else {
			local cond = "if !mi(msa) & msa != 0 & !mi(JanTemp) & !mi(JulTemp) & !mi(Precipitation)"
			local ages = "yr2000 male age30s age30s2000 age40s age40s2000 age50s age50s2000 age60s age60s2000 agegt70 agegt702000 hsdiploma hsdiploma2000 college college2000"
		}

/*
		***********************************************************************
		* JEL Table 3: Wage, real wage, house price on Jan temp (in 2000)
		***********************************************************************

		cap erase JEL3`ss'`t'.csv

		* Table 3 Reg 1: ipumsxs.do
		* Table 3 Reg 2: hpumsregs.do
		* Table 3 Reg 3: ipumsxs.do

		* Table 3 Reg 4
		prun areg Linc `ages' JanTempX00 `cond' , vce(cluster msa) absorb(msa)
		outrega using JEL3`ss'`t'.csv, se bracket bd(4) td(4) ctitle("JEL3r4")

		* Table 3 Reg 5: hpumsregs.do

		* Table 3 Reg 6
		prun areg Linc_r `ages' JanTempX00 `cond' , vce(cluster msa) absorb(msa)
		outrega using JEL3`ss'`t'.csv, se bracket bd(4) td(4) ctitle("JEL3r6")
*/

		******************************
		* BPEA Table 3: Agglomeration effects
		******************************		

*		foreach inst in "jp" "weather" "nat" {
*		foreach inst in "weather" "nat" {
		foreach inst in "weather" {
			di "Instrumenting for pop growth in 90s with `inst'...."

			if "`inst'" == "nat" {
				local ivars = "JanTempX00 JulTempX00 PrecipitationX00 GEO_LATX00 GEO_LNGX00"
				local ivarstop "JanTempXtop00X00 JulTempXtop00X00 PrecipitationXtop00X00 GEO_LATXtop00X00 GEO_LNGXtop00X00"
				local ivarstop90 "JanTempXtop90X00 JulTempXtop90X00 PrecipitationXtop90X00 GEO_LATXtop90X00 GEO_LNGXtop90X00"
				local ivarstopcent "JanTempXtopcentX00 JulTempXtopcentX00 PrecipitationXtopcentX00 GEO_LATXtopcentX00 GEO_LNGXtopcentX00"
				local ivars7090 "JanTempXpopGr7090q1X00 JulTempXpopGr7090q1X00 PrecipitationXpopGr7090q1X00 GEO_LATXpopGr7090q1X00 GEO_LNGXpopGr7090q1X00"

			}
			if "`inst'" == "weather" {
				local ivars = "JanTempX00 JulTempX00 PrecipitationX00"
				local ivarstop "JanTempXtop00X00 JulTempXtop00X00 PrecipitationXtop00X00"
				local ivarstop90 "JanTempXtop90X00 JulTempXtop90X00 PrecipitationXtop90X00"
				local ivarstopcent "JanTempXtopcentX00 JulTempXtopcentX00 PrecipitationXtopcentX00"
				local ivars7090 "JanTempXpopGr7090q1X00 JulTempXpopGr7090q1X00 PrecipitationXpopGr7090q1X00"
			}

 			cap erase BPEA3`ss'`t'_`inst'.csv

			************************************************************************
			** Preferred specification, with clustered standard errors
			************************************************************************

			* Table 3 Reg 1: OLS
			prun areg Linc `ages' lpop1990X00 lpop2000X00 `cond' , vce(cluster msa) absorb(msa)
			outrega lpop1990X00 lpop2000X00 using BPEA3`ss'`t'_`inst'.csv, se bracket bd(4) td(4) ctitle("BPEA3r1C")

			* Table 3 Reg 2: IV
			prun xi: ivregress 2sls Linc `ages' lpop1990X00 i.msa (lpop2000X00 = `ivars') `cond' , vce(cluster msa)
			outrega lpop1990X00 lpop2000X00 using BPEA3`ss'`t'_`inst'.csv, se bracket bd(4) td(4) ctitle("BPEA3r2C")

			* Table 3 Reg 3: Above median pop X size
			prun xi: ivregress 2sls Linc `ages' lpop1990X00 top90X00 i.msa (lpop2000X00 lpop2000Xtop90X00 = `ivars' `ivarstop90') `cond', vce(cluster msa)
			outrega lpop1990X00 lpop2000X00 lpop2000Xtop90X00 top90X00 using BPEA3`ss'`t'_`inst'.csv, se bracket bd(4) td(4) ctitle("BPEA3r3C")

			* Table 3 Reg 4: Above median centralization X growth
			prun xi: ivregress 2sls Linc `ages' lpop1990X00 centX00 topcentX00 i.msa (lpop2000X00 topcentXpopGr90sX00 = `ivars' `ivarstopcent') `cond', vce(cluster msa)
			outrega lpop1990X00 lpop2000X00 centX00 topcentX00 topcentXpopGr90sX00  using BPEA3`ss'`t'_`inst'.csv, se bracket bd(4) td(4) ctitle("BPEA3r4C")

			* Table 3 Reg 5: Shrinking X size
			prun xi: ivregress 2sls Linc `ages' lpop1990X00 popGr7090q1X00 i.msa (lpop2000X00 lpop2000XpopGr7090q1X00 = `ivars' `ivars7090') `cond', vce(cluster msa)
			outrega lpop1990X00 lpop2000X00 lpop2000XpopGr7090q1X00 popGr7090q1X00 using BPEA3`ss'`t'_`inst'.csv, se bracket bd(4) td(4) ctitle("BPEA3r5C")
		}
	}
}

