*************************************************
* This is sfit.ado by:                          *
*     Joshua D. Gottlieb                        *
*     (jdgottl@fas.harvard.edu)                 *
* The Taubman Center for State and Local        *
*      Government                               *
* The John F. Kennedy School of Government      *
* 79 John F. Kennedy St.                        *
* Cambridge, MA 02138                           *
*************************************************

*************************************************
* This program plots a scatterplot with a       *
* linear regression line through it.  Simply    *
* combines twoway scatter and twoway lfit.      *
*************************************************

program define sfit
  version 8
  syntax varlist(min=2 max=2) [if] [in] [using/] [, Controls(varlist)] [Robust] [Scatter(string)] [Lfit(string)] [Both(string)] [After(string)] [replace]  [Outreg(string)] [OUTOptions(string)]

  if "`robust'" != "" {
    reg `varlist' `controls' `if' `in' 
  }
  else {
    reg `varlist' `controls' `if' `in', robust
  }

  if "`outreg'" != "" {
    if "`outoptions'" != "" {
      outreg using `outreg', `outoptions'
    }
    else {
      outreg using `outreg'
    }
  }

  local commas = ""
  local commal = ""
  local commab = ""
  if "`after'" != "" {
    local commaa = ","
  }
  if "`scatter'" != "" | "`both'" != ""{
    local commas = ","
  }
  if "`lfit'" != "" | "`both'" != "" {
    local commal = ","
  }

  tokenize `varlist'
  local depvar `1'
  local indepvar `2'

  local deplab: var label `depvar'  

  graph twoway (scatter `varlist' `if' `in' `commas' `scatter' `both') (lfit `varlist' `if' `in' `commal' `lfit' `both'), ytitle("`deplab'") legend(off)`after'

if "`using'" != "" {
  if "`replace'" == "" {
    capture graph export "`using'"
    if _rc != 0 {
      di in red "Graph not exported because file `using' already exists"
    }
  }
  else {
    graph export "`using'", replace
  }
}
end




