* bpeatables.do
* Edward L. Glaeser (eglaeser@harvard.edu) and Joshua D. Gottlieb (jdgottl@fas.harvard.edu)
* Tables for Brookings Papers on Economic Activity, Spring 2008

cap log close bpea
now
local time=r(time)
local date=r(date)
* log using ~/urban/logs/bpea_`date'_`time'.log, text name(bpea) replace

cap set more off

clear
set mem 250m

local census "~/urban/census/"

***************************************************************************
*** Inline regressions
***************************************************************************

* Temperature and precipitation

use `census'MSAData99pmsa, clear
gen popgr70_00 = lpop2000 - lpop1970 
reg popgr70_00 JanTemp Precipitation 

* Regression (9): Erie Canal

use `census'ConsistentCountyData, clear
gen popgr20_40 = lpop1840 - lpop1820
gen WTR_CANAL = WTR_ERIE
replace WTR_CANAL = 1 if WTR_ERIEB == 1
reg popgr20_40 WTR_CANAL lpop1820 if ID_FIPST == 36

***************************************************************************
*** Table 1: Extreme MSAs
***************************************************************************

use `census'MSAData06msa, clear

gsort -gmppc2004
l msaname gmppc2004 in 1/5
gsort +gmppc2004
l msaname gmppc2004 in 1/5

use `census'MSAData06md, clear

gsort -incMedian2000
l msaname incMedian2000 in 1/5
gsort +incMedian2000
l msaname incMedian2000 in 1/5

gsort -baPct2000
l msaname baPct2000 in 1/8 if pop2000 >= 100000
gsort +baPct2000
l msaname baPct2000 in 1/5 if pop2000 >= 100000

gsort -houseValMedian2000
l msaname houseValMedian2000 in 1/5
gsort +houseValMedian2000
l msaname houseValMedian2000 in 1/5

***************************************************************************
*** Table 5: Water & Rail
***************************************************************************

use `census'ConsistentCountyData, clear

foreach s in 1850 1860 {
        foreach t in 1900 2000 {
                gen PopLogChg`s'_`t' = lpop`t' - lpop`s'
                lab var PopLogChg`s'_`t' "Change in log population, `s'-`t'"
        }
}

replace WTR_DO = WTR_DO / 100
lab var WTR_DO "Distance to ocean or Gulf in 100s of km"

cap erase BPEA5a.csv

reg popLogChg1850s lpop1850 WTR_DO rail1850 congregationalistsPerCap1850
outrega using BPEA5a.csv, se bracket
reg PopLogChg1850_1900 lpop1850 WTR_DO rail1850 congregationalistsPerCap1850
outrega using BPEA5a.csv, se bracket

cap erase BPEA5s.csv

reg popLogChg1850s lpop1850 rail1850 water1850
outrega using BPEA5s.csv, se bracket

***************************************************************************
*** Table 7: ARC
***************************************************************************

forvalues year=1980(10)2000 {
        gen popLogChg1970_`year' = lpop`year' - lpop1970
        gen incLogChg1970_`year' = lincPerCap`year' - lincPerCap1970
        lab var popLogChg1970_`year' "Change in log population, 1970-`year'"
        lab var incLogChg1970_`year' "Change in log income per capita, 1970-`year'"
}

gen linc1970 = lincPerCap1970
lab var linc1970 "Log income per capita, 1970"

cap erase BPEA7.csv

foreach d in pop inc {
	forvalues year=1980(20)2000 {
		reg `d'LogChg1970_`year' POL_ARC l`d'1970 if POL_ARCST == 1 & WTR_DO > 0.9
		outrega using BPEA7.csv, se bracket bd(3) td(3)
	}
}

***************************************************************************
*** Table 5: Highways
***************************************************************************

use `census'MSAchars99pmsa, clear

foreach s in 50 60 {
        foreach f in 80 90 {
                gen NewHwy`s'_`f' = lenc`f' - lenc`s'
                lab var NewHwy`s'_`f' "New miles of highway, 19`s'-19`f'"

                gen LogNewHwy`s'_`f' = log(NewHwy`s'_`f')
                lab var LogNewHwy`s'_`f' "Log new miles of highway, 19`s'-19`f'"
        }
}

foreach f in 1990 2000 {
        foreach s in 1960 1970 {
                gen ChgLogIncPC`s'_`f' = lincPerCap`f' - lincPerCap`s'
                gen ChgLogPop`s'_`f' = lpop`f' -lpop`s'
                lab var ChgLogIncPC`s'_`f' "Income per capita growth, `s'-`f'"
                lab var ChgLogPop`s'_`f' "Population growth, `s'-`f'"

                gen ChgHSPct`s'_`f' = hsPct`f' - hsPct`s'
                lab var ChgHSPct`s'_`f' "Change in percent high school graduates, `s'-`f'"
        }
        gen ChgLogPop1950_`f' = lpop`f' - lpop1950
        lab var ChgLogPop1950_`f' "Population growth, 1950-`f'"

        gen ChgBAPct1950_`f' = baPct`f' - baPct1950
        gen ChgHSPct1950_`f' = hsPct`f' - hsPct1950
        lab var ChgBAPct1950_`f' "Change in percent college graduates, 1950-`f'"
        lab var ChgHSPct1950_`f' "Change in percent high school graduates, 1950-`f'"
}

recode top_50_dummy (.=0)

gen msalabel = msaname if wharton > 6 | wharton < -5
gen msalabele = msaname if baPct2000 > 0.4 | wharton > 7 | strpos(msaname, "Orange") > 0 | strpos(msaname, "Buffalo") > 0 | baPct2000 < 0.2
        
replace WTR_DO = WTR_DO / 100
lab var WTR_DO "Distance to ocean or Gulf in 100s of km"

gen lboardingsPC1995 = log(boardingsPC1995)
lab var lboardingsPC1995 "Log boardings per capita, 1995"

cap erase BPEA5b.csv

reg ChgLogPop1960_1990 lpop1960 WTR_DO LogNewHwy60_90 , r
outrega using BPEA5b.csv, se bracket
reg ChgLogIncPC1960_1990 lpop1960 WTR_DO LogNewHwy60_90 , r
outrega using BPEA5b.csv, se bracket 
reg popLogChg1990s lpop1990 top_50_dummy baPct1990
outrega using BPEA5b.csv, se bracket 
reg incPCLogChg1990s lpop1990 top_50_dummy baPct1990
outrega using BPEA5b.csv, se bracket 

***************************************************************************
*** Table 4: Urban disamenities
***************************************************************************

drop if mi(pop2000)
gen top00 = 1 if pop2000 > 294597.5
recode top00 .=0
lab var top00 "City size above median, 2000"

gen q1 = 1 if pop2000 < 150355
recode q1 .=0
lab var q1 "City size in bottom quartile, 2000"

gen popXtop00 = lpop2000 * top00
lab var popXtop00 "Log population X above median, 2000"

gen popXcent = lpop2000 * pcwi5
lab var popXcent "Log population 2000 X % within 5 mi of CBD"

gen realwage00 = lincPerCap2000 - LogACCRA2000
lab var realwage00 "Log real wage, 2000"

cap erase BPEA4.csv

reg logcommute2000 lpop2000 popXtop00
outrega using BPEA4.csv, se bracket

reg logcommute2000 lpop2000 pcwi5 popXcent
outrega using BPEA4.csv, se bracket

reg logtsp2000 lpop2000 popXtop00
outrega using BPEA4.csv, se bracket

reg logtsp2000 lpop2000 pcwi5 popXcent
outrega using BPEA4.csv, se bracket

reg logcrime lpop2000 popXtop00
outrega using BPEA4.csv, se bracket

reg logcrime lpop2000 pcwi5 popXcent
outrega using BPEA4.csv, se bracket

reg realwage00 lpop2000 popXtop00
outrega using BPEA4.csv, se bracket

reg realwage00 lpop2000 pcwi5 popXcent
outrega using BPEA4.csv, se bracket

***************************************************************************
*** Table 6: Federal transportation spending by state
***************************************************************************

use `census'StateData, clear
drop if mi(fips)

di "Correlations for BPEA Table 6:"

foreach var of varlist lhighwaygrossPC lhighwayPC lairPC lrailroadPC lpubtransPC {
	corr `var' lpop2000
	corr `var' ldens2000
	corr `var' lincPerCap2000
}

**************************************************************************
**** Table 7: Urban Renewal
**************************************************************************

use "MSAchars99pmsa plus urban renewal.dta", clear

cap drop popLogChg????_2000

forvalues year=1960(10)1970 {
        gen popLogChg`year'_2000 = lpop2000 - lpop`year'
        gen incLogChg`year'_2000 = lincPerCap2000 - lincPerCap`year'
	gen hsgLogChg`year'_2000 = houseValLogMedian2000 - houseValLogMedian`year'
}

cap erase BPEA8.csv

reg popLogChg1960_2000 urpc lpop1960
outrega using BPEA8.csv, se bracket bd(4) td(4)

reg incLogChg1960_2000 urpc lincPerCap1960
outrega using BPEA8.csv, se bracket bd(4) td(4)

reg popLogChg1970_2000 modelcity lpop1970
outrega using BPEA8.csv, se bracket bd(4) td(4)

reg incLogChg1970_2000 modelcity lincPerCap1970
outrega using BPEA8.csv, se bracket bd(4) td(4)



