* bpeagraphs.do
* Create Figures for BPEA paper
* Edward L. Glaeser (eglaeser@harvard.edu) and Joshua D. Gottlieb (jdgottl@fas.harvard.edu)

local census "~/urban/census/"

cd ~/urban/BPEA

use `census'MSAData06msa, clear
gen msalabel = msaname if gmppc2005 > 59000 | strpos(msaname, "Boston") > 0 | strpos(msaname, "Brownsville") > 0 | strpos(msaname, "McAllen") > 0
sfit incPerCap2000 gmppc2005 using Fig1.tif, after(title(Income and Gross Metropolitan Product)) scatter(mlabel(msalabel)) replace

use `census'MSAData06md, clear
sfit houseValMedian2000 incPerCap2000 using Fig2.tif, after(title(House prices and income)) replace

use `census'MSAchars99pmsa, clear
lab var LogACCRA2000 "Log of ACCRA cost of living index, 2000"
sfit lincPerCap2000 LogACCRA2000 using Fig3.tif, replace after(title(Income and cost of living))

gen realwage00 = lincPerCap2000 - LogACCRA2000
lab var realwage00 "Log real wage, 2000"
lab var JanTemp "Mean January temperature"
sfit realwage00 JanTemp using Fig4.tif, replace after(title(Real income and quality of life))

use `census'MSAData06msa, clear
gen popGr8000 = lpop2000 - lpop1980
lab var popGr8000 "Population growth, 1980-2000"
sfit popGr8000 lincPerCap1980 using Fig5.tif, replace after(title(Population growth on initial income))

** Figure 6: Hapipness vs. income.  Code available with documentation to Glaeser, Gottlieb, Redlick and Sacerdote (2008, mimeo.)

sfit lgmppc2005 lpop2000 using Fig7.tif, replace after(title(Gross metropolitan product and city size))

use "~/urban/cyclesdata/Figure18data.dta", clear
lab var hsgval "Housing price, 2005"
lab var perm_stock "Ratio of new permits 2000-2005 to existing stock in 2000"
gen msalabel = msaname if strpos(msaname, "Santa Cruz") > 0 | strpos(msaname, "San Francisco") > 0 |strpos(msaname, "Honolulu") > 0 | strpos(msaname, "New York") > 0 | strpos(msaname, "Naples") > 0 | perm_stock >= .29
scatter hsgval perm_stock, mlabel(msalabel) title("Permits and housing prices")
graph export Fig10.tif, replace

gen lhsgdens = log(hsgunits / totarea)
gen lpermitdens = log(permits / totarea)
lab var lhsgdens "Log housing units per square mile, 2000"
lab var lpermitdens "Log new housing permits after 2000 per square mile"
sfit lpermitdens lhsgdens using Fig11.tif, replace after(title(Density of construction and density of housing stock))

use `census'MSAchars99pmsa, clear
gen msalabel = msaname if wharton < -5 | strpos(msaname, "Los Ang") > 0 | strpos(msaname, "Francisco") > 0 | strpos(msaname, "San Dieg") > 0 
sfit houseValLogMedian2000 wharton using Fig12.tif, replace after(title(Land use regulation and housing prices)) scatter(mlabel(msalabel))

gen msalabel2 = msaname if strpos(msaname, "Buffalo") > 0 | strpos(msaname, "Orange") > 0 | baPct2000 >= .39 | wharton > 9 | strpos(msaname, "Gary") > 0 | strpos(msaname, "Youngstown" ) > 0
sfit wharton baPct2000 using Fig13.tif, replace after(title(Land use regulation and education)) scatter(mlabel(msalabel2))

use `census'MSAData06md, clear
gen popGr4000 = lpop2000 - lpop1940
lab var popGr4000 "Population growth, 1940-2000"
sfit popGr4000 baPct1940 using Fig14.tif, replace after(title(Population growth on initial education 1940-2000))

gen baChg8000 = baPct2000-baPct1980
lab var baChg8000 "Change in percent college graduates, 1980-2000"
sfit baChg8000 baPct1980 using Fig15.tif, replace after(title(Education growth on initial level 1980-2000))

use `census'MSAchars99pmsa, clear
sfit l_all_yr00 baPct2000 using Fig16.tif, replace after(title(Wage residual and human caiptal))