cd "C:\Documents and Settings\Charlie Redlick\My Documents\RA Files for Prof. Glaeser\Happiness Paper"

set mem 500m
set maxvar 9000
set more off

use gss2

sort sampcode
merge sampcode using geoKEY_wSAMPCODE.dta, uniqusing
keep if _merge == 3
drop _merge

rename msapmsa msa

replace msa = 1123 if msa == 1120
replace msa = 8003 if msa == 8000
replace msa = 5483 if msa == 8040
replace msa = 5483 if msa == 5480
replace msa = 1303 if msa == 1305
replace msa = 3290 if msa == 2390
replace msa = 3283 if msa == 3280
replace msa = 5945 if msa == 360
replace msa = 6483 if msa == 6480
replace msa = 1123 if msa == 9240

sort msa
merge msa using MSAData99pmsa.dta, uniqusing
keep if _merge == 3
drop _merge

sort msa
by msa: egen num_obs = count(msa)

gen happy_binary = .
replace happy_binary = 1 if happy == 1
replace happy_binary = 0 if happy == 2 | happy == 3

gen happy7_binary = .
replace happy7_binary = 1 if happy7 == 1 | happy7 == 2
replace happy7_binary = 0 if happy7 >= 3 & happy7 <= 7

gen hapunhap_binary = .
replace hapunhap_binary = 1 if hapunhap == 1
replace hapunhap_binary = 0 if hapunhap >= 2 & hapunhap <= 4

by msa: egen percent_happy = mean(happy_binary)
by msa: egen percent_happy7 = mean(happy7_binary)
by msa: egen percent_hapunhap = mean(hapunhap_binary)

keep msa msatrim num_obs percent_happy percent_happy7 percent_hapunhap incPerCap2000 incPerCap1990 incPerCap1980 incPerCap1970 lincPerCap2000 lincPerCap1990 lincPerCap1980 lincPerCap1970

duplicates drop

label variable percent_happy "Percent happy in MSA"
label variable percent_happy7 "Percent happy in MSA"
label variable percent_hapunhap "Percent happy in MSA"

gen msalabel = msatrim if strpos(msatrim, "Wilmington") > 0 | strpos(msatrim, "San Fran") > 0 | strpos(msatrim, "Fresno") > 0 | strpos(msatrim, "Corpus") >0 | strpos(msatrim, "Jackson") > 0 | strpos(msatrim, "Gary") > 0 | strpos(msatrim, "Jersey") > 0 | strpos(msatrim, "Hartford") > 0 | strpos(msatrim, "Des Moines") > 0 | strpos(msatrim, "Boca") > 0
twoway (scatter percent_happy lincPerCap2000, mlabel(msalabel) title("Happiness and Income") ytitle("Percent happy in MSA")) (lfit percent_happy lincPerCap2000), legend(off)
twoway (scatter percent_happy lincPerCap1980, mlabel(msalabel) title("Happiness and Income") ytitle("Percent happy in MSA")) (lfit percent_happy lincPerCap1980), legend(off)
drop msalabel

gen msalabel = msatrim if strpos(msatrim, "Charleston") > 0 | strpos(msatrim, "San Fran") > 0 | strpos(msatrim, "Pittsburgh") > 0 | strpos(msatrim, "New Haven") >0 | strpos(msatrim, "Jackson") > 0 | strpos(msatrim, "Corpus") > 0 | strpos(msatrim, "Burlington") > 0 | strpos(msatrim, "San Diego") > 0 | strpos(msatrim, "Washington") > 0 | strpos(msatrim, "Boca") > 0
twoway (scatter percent_happy7 lincPerCap2000, mlabel(msalabel) ytitle("Percent happy in MSA")) (lfit percent_happy7 lincPerCap2000), legend(off)
twoway (scatter percent_happy7 lincPerCap1980, mlabel(msalabel) ytitle("Percent happy in MSA")) (lfit percent_happy7 lincPerCap1980), legend(off)
drop msalabel

gen msalabel = msatrim if strpos(msatrim, "Wilmington") > 0 | strpos(msatrim, "Riverside") > 0 | strpos(msatrim, "Tuscon") > 0 | strpos(msatrim, "Milwaukee") >0 | strpos(msatrim, "Fresno") > 0 | strpos(msatrim, "Philadelphia") > 0 | strpos(msatrim, "Waco") > 0 | strpos(msatrim, "Corpus") > 0 | strpos(msatrim, "Seattle") > 0 | strpos(msatrim, "Boca") > 0
twoway (scatter percent_hapunhap lincPerCap2000, mlabel(msalabel) ytitle("Percent happy in MSA")) (lfit percent_hapunhap lincPerCap2000), legend(off)
twoway (scatter percent_hapunhap lincPerCap1980, mlabel(msalabel) ytitle("Percent happy in MSA")) (lfit percent_hapunhap lincPerCap1980), legend(off)
drop msalabel
















