* vardecomp.do
* Standard deviations of income
* Joshua Gottlieb (jdgottl@fas.harvard.edu), 3/1/08-5/20/08

clear
cap log close vardecomp
now
local time=r(time)
local date=r(date)
log using ~/urban/logs/vardemoc_`date'_`time'.log, text name(vardecomp)

cap set more off

set mem 6g

* local s = "_001"
local s = ""

/*
** Individual variation controlling for MSA FEs

foreach yr in 80 90 00 {
	use ~/bulk/ipums/IPUMSprepped`yr', clear
	drop if mi(msa) | msa == 0

	gen incyr = inc
	gen Lyrinc = Linc

	foreach t in yr {
		prun su L`t'inc if pm, det
	
		prun areg L`t'inc if pm, a(msa)
		predict L`t'inc_r if pm, resid

		prun su L`t'inc_r if pm, det



		prun su inc`t' if pm, det
	
		prun areg inc`t' if pm, a(msa)
		predict inc`t'_r if pm, resid

		prun su inc`t'_r if pm, det
	}

}
*/

** MSA variation controlling for individual chars

* foreach yr in 80 90 00 {
foreach yr in 00 {
	foreach z in hhincome Lhhinc inc Linc {

		if "`z'" == "inc" | "`z'" == "Linc" {
			local langvar = "english"
			local wt = "perwt"
		}
		else {
			local langvar = "lingisol"
			local wt = "hhwt"
		}

		use ~/bulk/ipums/IPUMSprepped`yr'`s', clear
		drop if mi(msa) | msa == 0

		gen i = 1
		gen Lhhinc = log(hhincome)
		lab var Lhhinc "Log household income"

		reg `z' age30s age40s age50s age60s agegt70 male `langvar' hsdiploma college 
		predict `z'_r_w, resid
		lab var `z'_r_w "`z' controlling for indiv. chars. (weighted reg)"

		collapse (sum) `z'_tot_w=`z' `z'_totr_w=`z'_r_w num_w=i (rawsum) `z'_tot_unw=`z' `z'_totr_unw=`z'_r_w num_unw=i [fw=`wt'], by(msa)

		gen `z'_mean_w = `z'_tot_w / num_w
		gen `z'_meanr_w = `z'_totr_w / num_w
		gen `z'_mean_unw = `z'_tot_unw / num_unw
		gen `z'_meanr_unw = `z'_totr_unw / num_unw

		l msa `z'_mean*
		l msa `z'_mean*, nol

		su `z'_mean*, det
	}
}



