* ipumsxs.do
* Cross-section wage regressions for BPEA & JEL
* Joshua Gottlieb (jdgottl@fas.harvard.edu), 11/12/07-4/27/08

cap log close ipumsxs
now
local date = r(date)
local time = r(time)
log using ~/urban/logs/ipumsxs_`date'_`time'.log, text name(ipumsxs)

clear
cap set more off

set mem 10g
set matsize 400

	** The part of groupindustries.do that I want:

	cap program drop groupadd
	program define groupadd
	        args c b t d group
	        if ("`group'" == "") local group = "indgroup"
	        replace `group' = `c' if ind1990 >= `b' & ind1990 <= `t'
        	label define `group'lbl `c' "`d'", modify
	end

local times "yr"
* local times "yr wk hr"
local def "99pmsa"
* local t "_001"
local t ""

use ~/urban/census/MSAData99pmsa, clear
keep msa msaname baEnroll1850 baPct???? hsPct???? dens???? pop???? lpop???? congregationalistsPerCap1850 illitPct1850 *incPerCap???? JanTemp JulTemp Precipitation LogACCRA* houseValLogMedian???? GEO_LAT GEO_LNG logcommute2000 pcwi5 logcrime logpm102000 logtsp2000 MSApct* MSA*Herf*

gen ldens2000 = log(dens2000)

mkspline lpopspline_ 2 = lpop2000, displayknots pctile
mkspline ldenspline_ 2 = ldens2000, displayknots pctile
mkspline baPctSpline2000_ 2 = baPct2000, displayknots pctile
mkspline MSApctEmpHighHCSpline00_ 2 = MSApctEmpHighHC00, displayknots pctile

lab var lpopspline_1 "Log population 2000, below median"
lab var lpopspline_2 "Log population 2000, above median"
lab var ldenspline_1 "Log density 2000, below median"
lab var ldenspline_2 "Log density 2000, above median"

replace JanTemp = JanTemp / 100
replace JulTemp = JulTemp / 100

foreach s in 1990 2000 {
        foreach r in 1850 1880 1900 {
                reg lpop`s' lpop`r'
                predict lpop`s'hat`r'
                lab var lpop`s'hat`r' "Log pop. `s' pred. from `r' pop."
        }

        reg lpop`s' JanTemp Precipitation 
        predict lpop`s'hat_jp
        lab var lpop`s'hat_jp "Log pop. `s' pred. from JanTemp+Precip"

        reg lpop`s' JanTemp JulTemp Precipitation 
        predict lpop`s'hat_weather
        lab var lpop`s'hat_weather "Log pop. `s' pred. from weather"

        reg lpop`s' JanTemp JulTemp Precipitation GEO_LAT GEO_LNG
        predict lpop`s'hat_nat
        lab var lpop`s'hat_nat "Log pop. `s' pred. from weather+loc."
}

tempfile msadata
save `msadata'

* foreach yr in 80 90 00 {
foreach yr in 00 {

	if `yr' == 80 local year = "1980"
	else if `yr' == 90 local year = "1990"
	else local year = "2000"

	use ~/bulk/ipums/IPUMSprepped`yr'`t', clear
	gen i = 1
	sort msa
	merge msa using `msadata'
	drop if _merge == 2

	gen Linc_r = Linc - houseValLogMedian`year'
	lab var Linc_r "Log real wage"

	gen Linc_a = Linc - LogACCRA`year'
	lab var Linc_a "Log ACCRA wage"

	gen popq2 = 1 if pop2000 >= 150355 & pop2000 < 294597.5	
	gen popq3 = 1 if pop2000 >= 294597.5 & pop2000 < 661645
	gen popq4 = 1 if pop2000 >= 661645 & pop2000 < .
	recode popq? (.=0)

	gen lpop2000q2 = lpop2000 * popq2
	gen lpop2000q3 = lpop2000 * popq3
	gen lpop2000q4 = lpop2000 * popq4

	gen collegeXbaPct`year' = college * baPct`year'
	lab var collegeXbaPct`year' "College graduate x Percent college graduate"

	cap gen ldens`year' = log(dens`year')
	lab var ldens`year' "Log density, `year'"

	gen sector = .
	lab var sector "Sector (most aggregated industry grouping)"

	groupadd 1 010 050 "Extraction" sector                  * Agriculture & Mining
	groupadd 3 060 392 "Manufacturing" sector               * Includes Construction
	groupadd 7 400 432 "Services" sector                    * Transportation
	groupadd 7 440 442 "Services" sector                    * Communications
	groupadd 7 450 472 "Services" sector                    * Utilities and sanitary services
	groupadd 5 500 691 "Sales" sector
	groupadd 7 700 893 "Services" sector
	groupadd 9 900 960 "Public" sector

	label values sector sectorlbl

	gen MSASecHerf`yr' = MSASecHerf`yr'1 if sector == 1
	gen MSASecUnwHerf`yr' = MSASecHerf`yr'1 if sector == 1
        
        forvalues s=3(2)9 {
                foreach var of varlist MSApctEmpHighHCsec`yr' MSApctEmpLowHCsec`yr' MSASecHerf`yr' MSASecUnwHerf`yr' {
			di "`var'"
                        replace `var' = `var'`s' if sector == `s'
                }
        }

	************************************************************************
	** Run wage regressions with individual & MSA characteristics
	************************************************************************

	egen clgr = group(msa ind1990)

	foreach wt in i {
	        foreach ss in "all" "pm" {
	                if "`ss'" == "pm" {
	                        local cond = "if pm & !mi(msa) & msa != 0 & !mi(ldens`year')"
	                        local ages = "age30s age40s age50s hsdiploma college"
	                }
	                else {
	                        local cond = "if !mi(msa) & msa != 0 & !mi(ldens`year')"
	                        local ages = "male age30s age40s age50s age60s agegt70 hsdiploma college"
	                }

/*
			******************************************************************
			*** BPEA Table 2: Income versus size and density
			******************************************************************

			cap erase BPEA2`ss'`t'.csv

			prun reg Linc `ages' lpop`year' `cond' , cluster(msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2A1")

			prun reg Linc `ages' lpopspline_1 lpopspline_2 `cond' , cluster(msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2A2")

			prun reg Linc `ages' lpop`year' ldens`year' `cond' , cluster(msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2A3")

			prun reg Linc `ages' lpopspline_1 lpopspline_2 ldenspline_1 ldenspline_2 `cond' , cluster(msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2A4")

			prun ivregress 2sls Linc `ages' (lpop2000 = lpop1850) `cond' , vce(cluster msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2A5(IV)")

			prun reg Linc_a `ages' lpop`year' `cond' , cluster(msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2B1")

			prun reg Linc_a `ages' lpopspline_1 lpopspline_2 `cond' , cluster(msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2B2")

			prun reg Linc_a `ages' lpop`year' ldens`year' `cond' , cluster(msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2B3")

			prun reg Linc_a `ages' lpopspline_1 lpopspline_2 ldenspline_1 ldenspline_2 `cond' , cluster(msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2B4")

			prun ivregress 2sls Linc_a `ages' (lpop2000 = lpop1850) `cond' , vce(cluster msa)
			outrega using BPEA2`ss'`t'.csv, se bracket tdec(4) ctitle("BPEA2B5(IV)")

			******************************************************************
			*** BPEA Table 8: Human capital and industrial structure
			******************************************************************

			cap erase BPEA8`ss'`t'.csv

		        prun areg Linc `ages' baPct`year' , absorb(ind1990) vce(cluster clgr)
		        outrega using BPEA8`ss'`t'.csv, se bracket ctitle("BPEA8r1")

		        prun areg Linc `ages' baPctSpline`year'_1 baPctSpline`year'_2 , absorb(ind1990) vce(cluster clgr)
		        outrega using BPEA8`ss'`t'.csv, se bracket ctitle("BPEA8r2")
		
		        prun areg Linc `ages' MSApctEmpHighHC`yr' , absorb(ind1990) vce(cluster clgr)
		        outrega using BPEA8`ss'`t'.csv, se bracket ctitle("BPEA8r3")

		        prun areg Linc `ages' MSApctEmpHighHCSpline`yr'_1 MSApctEmpHighHCSpline`yr'_2 , absorb(ind1990) vce(cluster clgr)
		        outrega using BPEA8`ss'`t'.csv, se bracket ctitle("BPEA8r4")

		        prun areg Linc `ages' baPct`year' MSAHerf`yr' , absorb(ind1990) vce(cluster clgr)
		        outrega using BPEA8`ss'`t'.csv, se bracket ctitle("BPEA8r5")

		        prun xi: areg Linc `ages' MSASecHerf`yr' i.msa , absorb(ind1990) vce(cluster clgr)
		        outrega `ages' MSASecHerf`yr' using BPEA8`ss'`t'.csv, se bracket ctitle("BPEA8r6")

		        prun xi: ivregress 2sls Linc `ages' i.ind1990 (baPct`year' = congregationalistsPerCap1850 lpop1850) [fw=`wt'], vce(cluster clgr)
		        outreg `ages' baPct`year' using BPEA8s_`ss'`t'.csv, se bracket replace  ctitle("8r1i")

		        prun xi: ivregress 2sls Linc `ages' i.ind1990 (baPctSpline`year'_1 baPctSpline`year'_2 = congregationalistsPerCap1850 lpop1850) [fw=`wt'], vce(cluster clgr)
		        outreg `ages' baPctSpline`year'_1 baPctSpline`year'_2 using BPEA8s_`ss'`t'.csv, se bracket append  ctitle("8r2i")

*/
			* Repeat, clustering on MSA

			cap erase BPEA8`ss'`t'_cmsa.csv

		        prun areg Linc `ages' baPct`year' , absorb(ind1990) vce(cluster msa)
		        prun areg Linc `ages' baPctSpline`year'_1 baPctSpline`year'_2 , absorb(ind1990) vce(cluster msa)
		        prun areg Linc `ages' MSApctEmpHighHC`yr' , absorb(ind1990) vce(cluster msa)
		        prun areg Linc `ages' MSApctEmpHighHCSpline`yr'_1 MSApctEmpHighHCSpline`yr'_2 , absorb(ind1990) vce(cluster msa)
		        prun areg Linc `ages' baPct`year' MSAHerf`yr' , absorb(ind1990) vce(cluster msa)
		        prun xi: areg Linc `ages' MSASecHerf`yr' i.msa , absorb(ind1990) vce(cluster msa)

/*
			********************************************************************
			*** JEL Table 4: Nominal wages, house prices & real wages vs. size
			********************************************************************

                        cap erase JEL4a`t'.csv

                        * Table 4 Reg 1
                        prun reg Linc `ages' lpop2000 `cond' [fw = `wt'], cluster(msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) replace ctitle("4r1")

                        * Table 4 Reg 2
                        prun reg Linc `ages' lpop2000hat1880 `cond', cluster(msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r2")

			prun ivregress 2sls Linc `ages' (lpop2000 = lpop1880) `cond', vce(cluster msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r2i")

                        * Table 4 Reg 3
                        prun reg Linc `ages' lpop2000hat_weather `cond', cluster(msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r3")

			prun ivregress 2sls Linc `ages' (lpop2000 = JanTemp JulTemp Precipitation) `cond', vce(cluster msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r3i")

			* Table 4 Regs 4-6: JEL4b`t'.csv from hpumsregs.do

                        * Table 4 Reg 7
                        prun reg Linc_a `ages' lpop2000 `cond' [fw = `wt'], cluster(msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r7")

                        * Table 4 Reg 8
                        prun reg Linc_a `ages' lpop2000hat1880 `cond', cluster(msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r8")

			prun ivregress 2sls Linc_a `ages' (lpop2000 = lpop1880) `cond', vce(cluster msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r8i")

                        * Table 4 Reg 9
                        prun reg Linc_a `ages' lpop2000hat_weather `cond', cluster(msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r9")

			prun ivregress 2sls Linc_a `ages' (lpop2000 = JanTemp JulTemp Precipitation) `cond', vce(cluster msa)
                        outreg using JEL4a`t'.csv, se bracket bd(4) td(4) append ctitle("4r9i")
*/
		}
	}
}
	

