/* Important: you need to put the .dat and .do files in one folder/
   directory and then set the working folder to that folder. */

set mem 10g

set more off

clear
infix ///
 byte    year                                 1-2 ///
 double  serial                               3-10 ///
 int     hhwt                                11-14 ///
 byte    statefip                            15-16 ///
 byte    metro                               17 ///
 int     metarea                             18-20 ///
 int     metaread                            18-21 ///
 int     city                                22-25 ///
 long    citypop                             26-30 ///
 long    puma                                31-35 ///
 long    pumasupr                            36-40 ///
 byte    gq                                  41 ///
 byte    farm                                42 ///
 byte    ownershd                            43-44 ///
 byte    mortgage                            45 ///
 byte    mortgag2                            46 ///
 byte    commuse                             47 ///
 byte    acreprop                            48 ///
 long    mortamt1                            49-53 ///
 int     mortamt2                            54-57 ///
 byte    taxincl                             58 ///
 byte    insincl                             59 ///
 int     proptxin                            60-63 ///
 int     propinsr                            64-67 ///
 byte    proptx99                            68-69 ///
 int     rent                                70-73 ///
 int     rentgrs                             74-77 ///
 byte    rentmeal                            78 ///
 byte    condo                               79 ///
 int     condofee                            80-83 ///
 int     moblhome                            84-87 ///
 int     moblhom2                            88-91 ///
 int     costfuel                            92-95 ///
 long    ftotinc                             96-101 ///
 long    hhincome                           102-107 ///
 long    valueh                             108-113 ///
 byte    lingisol                           114 ///
 byte    vacancy                            115 ///
 byte    rooms                              116 ///
 byte    builtyr                            117 ///
 byte    unitsstr                           118-119 ///
 byte    bedrooms                           120 ///
 byte    vehicles                           121 ///
 byte    pernum                             122-123 ///
 int     perwt                              124-127 ///
 int     age                                128-130 ///
 byte    sex                                131 ///
 int     race                               132 ///
 byte    citizen                            133 ///
 byte    speakeng                           134 ///
 int     hispand                            135-137 ///
 byte    educrec                            138 ///
 byte    empstatd                           139-140 ///
 int     occ                                141-143 ///
 int     ind                                144-146 ///
 int     ind1950                            147-149 ///
 int     ind1990                            150-152 ///
 str    occsoc                             153-158 ///
 str    indnaics                           159-166 ///
 byte    wkswork1                           167-168 ///
 byte    uhrswork                           169-170 ///
 byte    workedyr                           171 ///
 long    inctot                             172-177 ///
 long    incwage                            178-183 ///
 long    incearn                            184-189 ///
 byte    migrate5                           190 ///
 int     migplac5                           191-193 ///
 int     migmet5                            194-197 ///
 byte    migtype5                           198 ///
 byte    samemet5                           199 ///
 byte    movedin                            200 ///
 byte    tranwork                           201-202 ///
 byte    carpool                            203 ///
 byte    trantime                           204-205 ///
 using jdgottl_fas_harvard_edu_010.dat

label var year "Census year"
label var serial "Household serial number"
label var hhwt "Household weight"
label var statefip "State (FIPS code)"
label var metro "Metropolitan status"
label var metarea "Metropolitan area [general version]"
label var metaread "Metropolitan area [detailed version]"
label var city "City"
label var citypop "City population"
label var puma "Public Use Microdata Area"
label var pumasupr "Super Public Use Microdata Area"
label var gq "Group quarters status"
label var farm "Farm status"
label var ownershd "Ownership of dwelling [detailed version]"
label var mortgage "Mortgage status"
label var mortgag2 "Second mortgage status"
label var commuse "Commercial use"
label var acreprop "Acreage of property"
label var mortamt1 "First mortgage monthly payment"
label var mortamt2 "Second mortgage monthly payment"
label var taxincl "Mortgage payment includes property taxes"
label var insincl "Mortgage payment includes property insurance"
label var proptxin "Annual property tax and insurance cost"
label var propinsr "Annual property insurance cost"
label var proptx99 "Annual property taxes, 1990"
label var rent "Monthly contract rent"
label var rentgrs "Monthly gross rent"
label var rentmeal "Meals included in rent"
label var condo "Condominium status"
label var condofee "Monthly condominium fee"
label var moblhome "Annual mobile home costs"
label var moblhom2 "Annual mobile home costs including loan payments"
label var costfuel "Annual home heating fuel cost"
label var ftotinc "Total family income"
label var hhincome "Total household income"
label var valueh "House value"
label var lingisol "Linguistic isolation"
label var vacancy "Vacancy status"
label var rooms "Number of rooms"
label var builtyr "Age of structure"
label var unitsstr "Units in structure"
label var bedrooms "Number of bedrooms"
label var vehicles "Vehicles available"
label var pernum "Person number in sample unit"
label var perwt "Person weight"
label var age "Age"
label var sex "Sex"
label var race "Race [general version]"
label var citizen "Citizenship status"
label var speakeng "Speaks English"
label var hispand "Hispanic origin [detailed version]"
label var educrec "Educational attainment recode"
label var empstatd "Employment status [detailed version]"
label var occ "Occupation"
label var ind "Industry"
label var ind1950 "Industry, 1950 basis"
label var ind1990 "Industry, 1990 basis"
label var occsoc "Occupation, SOC"
label var indnaics "Industry, NAICS"
label var wkswork1 "Weeks worked last year"
label var uhrswork "Usual hours worked per week"
label var workedyr "Worked last year"
label var inctot "Total personal income"
label var incwage "Wage and salary income"
label var incearn "Total personal earned income"
label var migrate5 "Migration status, 5 years [general version]"
label var migplac5 "State or country of residence 5 years ago"
label var migmet5 "Metropolitan area of residence 5 years ago"
label var migtype5 "Metropolitan status 5 years ago"
label var samemet5 "Lived same metropolitan area 5 years ago"
label var movedin "When occupant moved into residence"
label var tranwork "Means of transportation to work"
label var carpool "Carpooling"
label var trantime "Travel time to work"

label define yearlbl 00 "2000"
label define yearlbl 01 "2001", add
label define yearlbl 02 "2002", add
label define yearlbl 03 "2003", add
label define yearlbl 04 "2004", add
label define yearlbl 05 "2005", add
label define yearlbl 06 "2006", add
label define yearlbl 85 "1850", add
label define yearlbl 86 "1860", add
label define yearlbl 87 "1870", add
label define yearlbl 88 "1880", add
label define yearlbl 90 "1900", add
label define yearlbl 91 "1910", add
label define yearlbl 92 "1920", add
label define yearlbl 93 "1930", add
label define yearlbl 94 "1940", add
label define yearlbl 95 "1950", add
label define yearlbl 96 "1960", add
label define yearlbl 97 "1970", add
label define yearlbl 98 "1980", add
label define yearlbl 99 "1990", add
label values year yearlbl

label values serial seriallbl

label values hhwt hhwtlbl

label define statefiplbl 01 "Alabama", add
label define statefiplbl 02 "Alaska", add
label define statefiplbl 04 "Arizona", add
label define statefiplbl 05 "Arkansas", add
label define statefiplbl 06 "California", add
label define statefiplbl 08 "Colorado", add
label define statefiplbl 09 "Connecticut", add
label define statefiplbl 10 "Delaware", add
label define statefiplbl 11 "District of Columbia", add
label define statefiplbl 12 "Florida", add
label define statefiplbl 13 "Georgia", add
label define statefiplbl 15 "Hawaii", add
label define statefiplbl 16 "Idaho", add
label define statefiplbl 17 "Illinois", add
label define statefiplbl 18 "Indiana", add
label define statefiplbl 19 "Iowa", add
label define statefiplbl 20 "Kansas", add
label define statefiplbl 21 "Kentucky", add
label define statefiplbl 22 "Louisiana", add
label define statefiplbl 23 "Maine", add
label define statefiplbl 24 "Maryland", add
label define statefiplbl 25 "Massachusetts", add
label define statefiplbl 26 "Michigan", add
label define statefiplbl 27 "Minnesota", add
label define statefiplbl 28 "Mississippi", add
label define statefiplbl 29 "Missouri", add
label define statefiplbl 30 "Montana", add
label define statefiplbl 31 "Nebraska", add
label define statefiplbl 32 "Nevada", add
label define statefiplbl 33 "New Hampshire", add
label define statefiplbl 34 "New Jersey", add
label define statefiplbl 35 "New Mexico", add
label define statefiplbl 36 "New York", add
label define statefiplbl 37 "North Carolina", add
label define statefiplbl 38 "North Dakota", add
label define statefiplbl 39 "Ohio", add
label define statefiplbl 40 "Oklahoma", add
label define statefiplbl 41 "Oregon", add
label define statefiplbl 42 "Pennsylvania", add
label define statefiplbl 44 "Rhode island", add
label define statefiplbl 45 "South Carolina", add
label define statefiplbl 46 "South Dakota", add
label define statefiplbl 47 "Tennessee", add
label define statefiplbl 48 "Texas", add
label define statefiplbl 49 "Utah", add
label define statefiplbl 50 "Vermont", add
label define statefiplbl 51 "Virginia", add
label define statefiplbl 53 "Washington", add
label define statefiplbl 54 "West Virginia", add
label define statefiplbl 55 "Wisconsin", add
label define statefiplbl 56 "Wyoming", add
label define statefiplbl 61 "Maine-New Hampshire-Vermont", add
label define statefiplbl 62 "Massachusetts-Rhode Island", add
label define statefiplbl 63 "Minnesota-Iowa-Missouri-Kansas-Nebraska-S.Dakota-N.Dakota", add
label define statefiplbl 64 "Maryland-Delaware", add
label define statefiplbl 65 "Montana-Idaho-Wyoming", add
label define statefiplbl 66 "Utah-Nevada", add
label define statefiplbl 67 "Arizona-New Mexico", add
label define statefiplbl 68 "Alaska-Hawaii", add
label define statefiplbl 72 "Puerto Rico", add
label define statefiplbl 97 "Military/Mil. Reservation", add
label define statefiplbl 99 "State not identified", add
label values statefip statefiplbl

label define metrolbl 0 "Not identifiable", add
label define metrolbl 1 "Not in metro area", add
label define metrolbl 2 "In metro area, central city", add
label define metrolbl 3 "In metro, area, outside central city", add
label define metrolbl 4 "Central city status unknown", add
label values metro metrolbl

label define metarealbl 000 "Not identifiable or not in an MSA"
label define metarealbl 004 "Abilene, TX", add
label define metarealbl 006 "Aguadilla, PR", add
label define metarealbl 008 "Akron, OH", add
label define metarealbl 012 "Albany, GA", add
label define metarealbl 016 "Albany-Schenectady-Troy, NY", add
label define metarealbl 020 "Albuquerque, NM", add
label define metarealbl 022 "Alexandria, LA", add
label define metarealbl 024 "Allentown-Bethlehem-Easton, PA/NJ", add
label define metarealbl 028 "Altoona, PA", add
label define metarealbl 032 "Amarillo, TX", add
label define metarealbl 038 "Anchorage, AK", add
label define metarealbl 040 "Anderson, IN", add
label define metarealbl 044 "Ann Arbor, MI", add
label define metarealbl 045 "Anniston, AL", add
label define metarealbl 046 "Appleton-Oskosh-Neenah, WI", add
label define metarealbl 047 "Arecibo, PR", add
label define metarealbl 048 "Asheville, NC", add
label define metarealbl 050 "Athens, GA", add
label define metarealbl 052 "Atlanta, GA", add
label define metarealbl 056 "Atlantic City, NJ", add
label define metarealbl 058 "Auburn-Opekika, AL", add
label define metarealbl 060 "Augusta-Aiken, GA-SC", add
label define metarealbl 064 "Austin, TX", add
label define metarealbl 068 "Bakersfield, CA", add
label define metarealbl 072 "Baltimore, MD", add
label define metarealbl 073 "Bangor, ME", add
label define metarealbl 074 "Barnstable-Yarmouth, MA", add
label define metarealbl 076 "Baton Rouge, LA", add
label define metarealbl 078 "Battle Creek, MI", add
label define metarealbl 084 "Beaumont-Port Arthur-Orange,TX", add
label define metarealbl 086 "Bellingham, WA", add
label define metarealbl 087 "Benton Harbor, MI", add
label define metarealbl 088 "Billings, MT", add
label define metarealbl 092 "Biloxi-Gulfport, MS", add
label define metarealbl 096 "Binghamton, NY", add
label define metarealbl 100 "Birmingham, AL", add
label define metarealbl 102 "Bloomington, IN", add
label define metarealbl 104 "Bloomington-Normal, IL", add
label define metarealbl 108 "Boise City, ID", add
label define metarealbl 112 "Boston, MA-NH", add
label define metarealbl 114 "Bradenton, FL", add
label define metarealbl 115 "Bremerton, WA", add
label define metarealbl 116 "Bridgeport, CT", add
label define metarealbl 120 "Brockton, MA", add
label define metarealbl 124 "Brownsville-Harlingen-San Benito, TX", add
label define metarealbl 126 "Bryan-College Station, TX", add
label define metarealbl 128 "Buffalo-Niagara Falls, NY", add
label define metarealbl 130 "Burlington, NC", add
label define metarealbl 131 "Burlington, VT", add
label define metarealbl 132 "Canton, OH", add
label define metarealbl 133 "Caguas, PR", add
label define metarealbl 135 "Casper, WY", add
label define metarealbl 136 "Cedar Rapids, IA", add
label define metarealbl 140 "Champaign-Urbana-Rantoul, IL", add
label define metarealbl 144 "Charleston-N.Charleston,SC", add
label define metarealbl 148 "Charleston, WV", add
label define metarealbl 152 "Charlotte-Gastonia-Rock Hill, NC-SC", add
label define metarealbl 154 "Charlottesville, VA", add
label define metarealbl 156 "Chattanooga, TN/GA", add
label define metarealbl 158 "Cheyenne, WY", add
label define metarealbl 160 "Chicago, IL", add
label define metarealbl 162 "Chico, CA", add
label define metarealbl 164 "Cincinnati-Hamilton, OH/KY/IN", add
label define metarealbl 166 "Clarksville- Hopkinsville, TN/KY", add
label define metarealbl 168 "Cleveland, OH", add
label define metarealbl 172 "Colorado Springs, CO", add
label define metarealbl 174 "Columbia, MO", add
label define metarealbl 176 "Columbia, SC", add
label define metarealbl 180 "Columbus, GA/AL", add
label define metarealbl 184 "Columbus, OH", add
label define metarealbl 188 "Corpus Christi, TX", add
label define metarealbl 190 "Cumberland, MD/WV", add
label define metarealbl 192 "Dallas-Fort Worth, TX", add
label define metarealbl 193 "Danbury, CT", add
label define metarealbl 195 "Danville, VA", add
label define metarealbl 196 "Davenport, IA-Rock Island -Moline, IL", add
label define metarealbl 200 "Dayton-Springfield, OH", add
label define metarealbl 202 "Daytona Beach, FL", add
label define metarealbl 203 "Decatur, AL", add
label define metarealbl 204 "Decatur, IL", add
label define metarealbl 208 "Denver-Boulder, CO", add
label define metarealbl 212 "Des Moines, IA", add
label define metarealbl 216 "Detroit, MI", add
label define metarealbl 218 "Dothan, AL", add
label define metarealbl 219 "Dover, DE", add
label define metarealbl 220 "Dubuque, IA", add
label define metarealbl 224 "Duluth-Superior, MN/WI", add
label define metarealbl 228 "Dutchess Co., NY", add
label define metarealbl 229 "Eau Claire, WI", add
label define metarealbl 231 "El Paso, TX", add
label define metarealbl 232 "Elkhart-Goshen, IN", add
label define metarealbl 233 "Elmira, NY", add
label define metarealbl 234 "Enid, OK", add
label define metarealbl 236 "Erie, PA", add
label define metarealbl 240 "Eugene-Springfield, OR", add
label define metarealbl 244 "Evansville, IN/KY", add
label define metarealbl 252 "Fargo-Morehead, ND/MN", add
label define metarealbl 256 "Fayetteville, NC", add
label define metarealbl 258 "Fayetteville-Springdale, AR", add
label define metarealbl 260 "Fitchburg-Leominster, MA", add
label define metarealbl 262 "Flagstaff, AZ-UT", add
label define metarealbl 264 "Flint, MI", add
label define metarealbl 265 "Florence, AL", add
label define metarealbl 266 "Florence, SC", add
label define metarealbl 267 "Fort Collins-Loveland, CO", add
label define metarealbl 268 "Fort Lauderdale-Hollywood-Pompano Beach, FL", add
label define metarealbl 270 "Fort Myers-Cape Coral, FL", add
label define metarealbl 271 "Fort Pierce, FL", add
label define metarealbl 272 "Fort Smith, AR/OK", add
label define metarealbl 275 "Fort Walton Beach, FL", add
label define metarealbl 276 "Fort Wayne, IN", add
label define metarealbl 284 "Fresno, CA", add
label define metarealbl 288 "Gadsden, AL", add
label define metarealbl 290 "Gainesville, FL", add
label define metarealbl 292 "Galveston-Texas City, TX", add
label define metarealbl 297 "Glens Falls, NY", add
label define metarealbl 298 "Goldsboro, NC", add
label define metarealbl 299 "Grand Forks, ND", add
label define metarealbl 300 "Grand Rapids, MI", add
label define metarealbl 301 "Grand Junction, CO", add
label define metarealbl 304 "Great Falls, MT", add
label define metarealbl 306 "Greeley, CO", add
label define metarealbl 308 "Green Bay, WI", add
label define metarealbl 312 "Greensboro-Winston Salem-High Point, NC", add
label define metarealbl 315 "Greenville, NC", add
label define metarealbl 316 "Greenville-Spartanburg-Anderson SC", add
label define metarealbl 318 "Hagerstown, MD", add
label define metarealbl 320 "Hamilton-Middleton, OH", add
label define metarealbl 324 "Harrisburg-Lebanon--Carlisle, PA", add
label define metarealbl 328 "Hartford-Bristol-Middleton- New Britain, CT", add
label define metarealbl 329 "Hickory-Morgantown, NC", add
label define metarealbl 330 "Hattiesburg, MS", add
label define metarealbl 332 "Honolulu, HI", add
label define metarealbl 335 "Houma-Thibodoux, LA", add
label define metarealbl 336 "Houston-Brazoria, TX", add
label define metarealbl 340 "Huntington-Ashland, WV/KY/OH", add
label define metarealbl 344 "Huntsville, AL", add
label define metarealbl 348 "Indianapolis, IN", add
label define metarealbl 350 "Iowa City, IA", add
label define metarealbl 352 "Jackson, MI", add
label define metarealbl 356 "Jackson, MS", add
label define metarealbl 358 "Jackson, TN", add
label define metarealbl 359 "Jacksonville, FL", add
label define metarealbl 360 "Jacksonville, NC", add
label define metarealbl 361 "Jamestown-Dunkirk, NY", add
label define metarealbl 362 "Janesville-Beloit, WI", add
label define metarealbl 366 "Johnson City-Kingsport--Bristol, TN/VA", add
label define metarealbl 368 "Johnstown, PA", add
label define metarealbl 371 "Joplin, MO", add
label define metarealbl 372 "Kalamazoo-Portage, MI", add
label define metarealbl 374 "Kankakee, IL", add
label define metarealbl 376 "Kansas City, MO-KS", add
label define metarealbl 380 "Kenosha, WI", add
label define metarealbl 381 "Kileen-Temple, TX", add
label define metarealbl 384 "Knoxville, TN", add
label define metarealbl 385 "Kokomo, IN", add
label define metarealbl 387 "LaCrosse, WI", add
label define metarealbl 388 "Lafayette, LA", add
label define metarealbl 392 "Lafayette-W. Lafayette, IN", add
label define metarealbl 396 "Lake Charles, LA", add
label define metarealbl 398 "Lakeland-Winterhaven, FL", add
label define metarealbl 400 "Lancaster, PA", add
label define metarealbl 404 "Lansing-E. Lansing, MI", add
label define metarealbl 408 "Laredo, TX", add
label define metarealbl 410 "Las Cruces, NM", add
label define metarealbl 412 "Las Vegas, NV", add
label define metarealbl 415 "Lawrence, KS", add
label define metarealbl 420 "Lawton, OK", add
label define metarealbl 424 "Lewiston-Auburn, ME", add
label define metarealbl 428 "Lexington-Fayette, KY", add
label define metarealbl 432 "Lima, OH", add
label define metarealbl 436 "Lincoln, NE", add
label define metarealbl 440 "Little Rock--North Little Rock, AR", add
label define metarealbl 441 "Long Branch-Asbury Park,NJ", add
label define metarealbl 442 "Longview-Marshall, TX", add
label define metarealbl 444 "Lorain-Elyria, OH", add
label define metarealbl 448 "Los Angeles-Long Beach, CA", add
label define metarealbl 452 "Louisville, KY/IN", add
label define metarealbl 460 "Lubbock, TX", add
label define metarealbl 464 "Lynchburg, VA", add
label define metarealbl 468 "Macon-Warner Robins, GA", add
label define metarealbl 472 "Madison, WI", add
label define metarealbl 476 "Manchester, NH", add
label define metarealbl 480 "Mansfield, OH", add
label define metarealbl 484 "Mayaguez, PR", add
label define metarealbl 488 "McAllen-Edinburg-Pharr-Mission, TX", add
label define metarealbl 489 "Medford, OR", add
label define metarealbl 490 "Melbourne-Titusville-Cocoa-Palm Bay, FL", add
label define metarealbl 492 "Memphis, TN/AR/MS", add
label define metarealbl 494 "Merced, CA", add
label define metarealbl 500 "Miami-Hialeah, FL", add
label define metarealbl 504 "Midland, TX", add
label define metarealbl 508 "Milwaukee, WI", add
label define metarealbl 512 "Minneapolis-St. Paul, MN", add
label define metarealbl 514 "Missoula, MT", add
label define metarealbl 516 "Mobile, AL", add
label define metarealbl 517 "Modesto, CA", add
label define metarealbl 519 "Monmouth-Ocean, NJ", add
label define metarealbl 520 "Monroe, LA", add
label define metarealbl 524 "Montgomery, AL", add
label define metarealbl 528 "Muncie, IN", add
label define metarealbl 532 "Muskegon-Norton Shores-Muskegon Heights, MI", add
label define metarealbl 533 "Myrtle Beach, SC", add
label define metarealbl 534 "Naples, FL", add
label define metarealbl 535 "Nashua, NH", add
label define metarealbl 536 "Nashville, TN", add
label define metarealbl 540 "New Bedford, MA", add
label define metarealbl 546 "New Brunswick-Perth Amboy-Sayreville, NJ", add
label define metarealbl 548 "New Haven-Meriden, CT", add
label define metarealbl 552 "New London-Norwich, CT/RI", add
label define metarealbl 556 "New Orleans, LA", add
label define metarealbl 560 "New York-Northeastern NJ", add
label define metarealbl 564 "Newark, OH", add
label define metarealbl 566 "Newburgh-Middletown, NY", add
label define metarealbl 572 "Norfolk-VA Beach--Newport News, VA", add
label define metarealbl 576 "Norwalk, CT", add
label define metarealbl 579 "Ocala, FL", add
label define metarealbl 580 "Odessa, TX", add
label define metarealbl 588 "Oklahoma City, OK", add
label define metarealbl 591 "Olympia, WA", add
label define metarealbl 592 "Omaha, NE/IA", add
label define metarealbl 595 "Orange, NY", add
label define metarealbl 596 "Orlando, FL", add
label define metarealbl 599 "Owensboro, KY", add
label define metarealbl 601 "Panama City, FL", add
label define metarealbl 602 "Parkersburg-Marietta,WV/OH", add
label define metarealbl 603 "Pascagoula-Moss Point, MS", add
label define metarealbl 608 "Pensacola, FL", add
label define metarealbl 612 "Peoria, IL", add
label define metarealbl 616 "Philadelphia, PA/NJ", add
label define metarealbl 620 "Phoenix, AZ", add
label define metarealbl 628 "Pittsburgh, PA", add
label define metarealbl 632 "Pittsfield, MA", add
label define metarealbl 636 "Ponse, PR", add
label define metarealbl 640 "Portland, ME", add
label define metarealbl 644 "Portland, OR-WA", add
label define metarealbl 645 "Portsmouth-Dover--Rochester, NH/ME", add
label define metarealbl 646 "Poughkeepsie, NY", add
label define metarealbl 648 "Providence-Fall River-Pawtucket, MA/RI", add
label define metarealbl 652 "Provo-Orem, UT", add
label define metarealbl 656 "Pueblo, CO", add
label define metarealbl 658 "Punta Gorda, FL", add
label define metarealbl 660 "Racine, WI", add
label define metarealbl 664 "Raleigh-Durham, NC", add
label define metarealbl 666 "Rapid City, SD", add
label define metarealbl 668 "Reading, PA", add
label define metarealbl 669 "Redding, CA", add
label define metarealbl 672 "Reno, NV", add
label define metarealbl 674 "Richland-Kennewick-Pasco, WA", add
label define metarealbl 676 "Richmond-Petersburg, VA", add
label define metarealbl 678 "Riverside-San Bernadino, CA", add
label define metarealbl 680 "Roanoke, VA", add
label define metarealbl 682 "Rochester, MN", add
label define metarealbl 684 "Rochester, NY", add
label define metarealbl 688 "Rockford, IL", add
label define metarealbl 689 "Rocky Mount, NC", add
label define metarealbl 692 "Sacramento, CA", add
label define metarealbl 696 "Saginaw-Bay City-Midland, MI", add
label define metarealbl 698 "St. Cloud, MN", add
label define metarealbl 700 "St. Joseph, MO", add
label define metarealbl 704 "St. Louis, MO-IL", add
label define metarealbl 708 "Salem, OR", add
label define metarealbl 712 "Salinas-Sea Side-Monterey, CA", add
label define metarealbl 714 "Salisbury-Concord, NC", add
label define metarealbl 716 "Salt Lake City-Ogden, UT", add
label define metarealbl 720 "San Angelo, TX", add
label define metarealbl 724 "San Antonio, TX", add
label define metarealbl 732 "San Diego, CA", add
label define metarealbl 736 "San Francisco-Oakland-Vallejo, CA", add
label define metarealbl 740 "San Jose, CA", add
label define metarealbl 744 "San Juan-Bayamon, PR", add
label define metarealbl 746 "San Luis Obispo-Atascad-P Robles, CA", add
label define metarealbl 747 "Santa Barbara-Santa Maria-Lompoc, CA", add
label define metarealbl 748 "Santa Cruz, CA", add
label define metarealbl 749 "Santa Fe, NM", add
label define metarealbl 750 "Santa Rosa-Petaluma, CA", add
label define metarealbl 751 "Sarasota, FL", add
label define metarealbl 752 "Savannah, GA", add
label define metarealbl 756 "Scranton-Wilkes-Barre, PA", add
label define metarealbl 760 "Seattle-Everett, WA", add
label define metarealbl 761 "Sharon, PA", add
label define metarealbl 762 "Sheboygan, WI", add
label define metarealbl 764 "Sherman-Davidson, TX", add
label define metarealbl 768 "Shreveport, LA", add
label define metarealbl 772 "Sioux City, IA/NE", add
label define metarealbl 776 "Sioux Falls, SD", add
label define metarealbl 780 "South Bend-Mishawaka, IN", add
label define metarealbl 784 "Spokane, WA", add
label define metarealbl 788 "Springfield, IL", add
label define metarealbl 792 "Springfield, MO", add
label define metarealbl 800 "Springfield-Holyoke-Chicopee, MA", add
label define metarealbl 804 "Stamford, CT", add
label define metarealbl 805 "State College, PA", add
label define metarealbl 808 "Steubenville-Weirton,OH/WV", add
label define metarealbl 812 "Stockton, CA", add
label define metarealbl 814 "Sumter, SC", add
label define metarealbl 816 "Syracuse, NY", add
label define metarealbl 820 "Tacoma, WA", add
label define metarealbl 824 "Tallahassee, FL", add
label define metarealbl 828 "Tampa-St. Petersburg-Clearwater, FL", add
label define metarealbl 832 "Terre Haute, IN", add
label define metarealbl 836 "Texarkana, TX/AR", add
label define metarealbl 840 "Toledo, OH/MI", add
label define metarealbl 844 "Topeka, KS", add
label define metarealbl 848 "Trenton, NJ", add
label define metarealbl 852 "Tucson, AZ", add
label define metarealbl 856 "Tulsa, OK", add
label define metarealbl 860 "Tuscaloosa, AL", add
label define metarealbl 864 "Tyler, TX", add
label define metarealbl 868 "Utica-Rome, NY", add
label define metarealbl 873 "Ventura-Oxnard-Simi Valley, CA", add
label define metarealbl 875 "Victoria, TX", add
label define metarealbl 876 "Vineland-Milville-Bridgetown, NJ", add
label define metarealbl 878 "Visalia-Tulare-Porterville, CA", add
label define metarealbl 880 "Waco, TX", add
label define metarealbl 884 "Washington, DC/MD/VA", add
label define metarealbl 888 "Waterbury, CT", add
label define metarealbl 892 "Waterloo-Cedar Falls, IA", add
label define metarealbl 894 "Wausau, WI", add
label define metarealbl 896 "West Palm Beach-Boca Raton-Delray Beach, FL", add
label define metarealbl 900 "Wheeling, WV/OH", add
label define metarealbl 904 "Wichita, KS", add
label define metarealbl 908 "Wichita Falls, TX", add
label define metarealbl 914 "Williamsport, PA", add
label define metarealbl 916 "Wilmington, DE/NJ/MD", add
label define metarealbl 920 "Wilmington, NC", add
label define metarealbl 924 "Worcester, MA", add
label define metarealbl 926 "Yakima, WA", add
label define metarealbl 927 "Yolo, CA", add
label define metarealbl 928 "York, PA", add
label define metarealbl 932 "Youngstown-Warren, OH-PA", add
label define metarealbl 934 "Yuba City, CA", add
label define metarealbl 936 "Yuma, AZ", add
label values metarea metarealbl

label define metareadlbl 0000 "Not identifiable or not in an MSA", add
label define metareadlbl 0040 "Abilene, TX", add
label define metareadlbl 0060 "Aguadilla, PR", add
label define metareadlbl 0080 "Akron, OH", add
label define metareadlbl 0120 "Albany, GA", add
label define metareadlbl 0160 "Albany-Schenectady-Troy, NY", add
label define metareadlbl 0200 "Albuquerque, NM", add
label define metareadlbl 0220 "Alexandria, LA", add
label define metareadlbl 0240 "Allentown-Bethlehem-Easton, PA/NJ", add
label define metareadlbl 0280 "Altoona, PA", add
label define metareadlbl 0320 "Amarillo, TX", add
label define metareadlbl 0380 "Anchorage, AK", add
label define metareadlbl 0400 "Anderson, IN", add
label define metareadlbl 0440 "Ann Arbor, MI", add
label define metareadlbl 0450 "Anniston, AL", add
label define metareadlbl 0460 "Appleton-Oskosh-Neenah, WI", add
label define metareadlbl 0470 "Arecibo, PR", add
label define metareadlbl 0480 "Asheville, NC", add
label define metareadlbl 0500 "Athens, GA", add
label define metareadlbl 0520 "Atlanta, GA", add
label define metareadlbl 0560 "Atlantic City, NJ", add
label define metareadlbl 0580 "Auburn-Opelika, AL", add
label define metareadlbl 0600 "Augusta-Aiken, GA-SC", add
label define metareadlbl 0640 "Austin, TX", add
label define metareadlbl 0680 "Bakersfield, CA", add
label define metareadlbl 0720 "Baltimore, MD", add
label define metareadlbl 0730 "Bangor, ME", add
label define metareadlbl 0740 "Barnstable-Yarmouth, MA", add
label define metareadlbl 0760 "Baton Rouge, LA", add
label define metareadlbl 0780 "Battle Creek, MI", add
label define metareadlbl 0840 "Beaumont-Port Arthur-Orange,TX", add
label define metareadlbl 0860 "Bellingham, WA", add
label define metareadlbl 0870 "Benton Harbor, MI", add
label define metareadlbl 0880 "Billings, MT", add
label define metareadlbl 0920 "Biloxi-Gulfport, MS", add
label define metareadlbl 0960 "Binghamton, NY", add
label define metareadlbl 1000 "Birmingham, AL", add
label define metareadlbl 1010 "Bismarck,ND", add
label define metareadlbl 1020 "Bloomington, IN", add
label define metareadlbl 1040 "Bloomington-Normal, IL", add
label define metareadlbl 1080 "Boise City, ID", add
label define metareadlbl 1120 "Boston, MA", add
label define metareadlbl 1121 "Lawrence-Haverhill, MA/NH", add
label define metareadlbl 1122 "Lowell, MA/NH", add
label define metareadlbl 1123 "Salem-Gloucester, MA", add
label define metareadlbl 1140 "Bradenton, FL", add
label define metareadlbl 1150 "Bremerton, WA", add
label define metareadlbl 1160 "Bridgeport, CT", add
label define metareadlbl 1200 "Brockton, MA", add
label define metareadlbl 1240 "Brownsville-Harlingen-San Benito, TX", add
label define metareadlbl 1260 "Bryan-College Station, TX", add
label define metareadlbl 1280 "Buffalo-Niagara Falls, NY", add
label define metareadlbl 1281 "Niagara Falls, NY", add
label define metareadlbl 1300 "Burlington, NC", add
label define metareadlbl 1310 "Burlington, VT", add
label define metareadlbl 1320 "Canton, OH", add
label define metareadlbl 1330 "Caguas, PR", add
label define metareadlbl 1350 "Casper, WY", add
label define metareadlbl 1360 "Cedar Rapids, IA", add
label define metareadlbl 1400 "Champaign-Urbana-Rantoul, IL", add
label define metareadlbl 1440 "Charleston-N.Charleston,SC", add
label define metareadlbl 1480 "Charleston, WV", add
label define metareadlbl 1520 "Charlotte-Gastonia-Rock Hill, SC", add
label define metareadlbl 1521 "Rock Hill, SC", add
label define metareadlbl 1540 "Charlottesville, VA", add
label define metareadlbl 1560 "Chattanooga, TN/GA", add
label define metareadlbl 1580 "Cheyenne, WY", add
label define metareadlbl 1600 "Chicago-Gary-Lake, IL", add
label define metareadlbl 1601 "Aurora-Elgin, IL", add
label define metareadlbl 1602 "Gary-Hammond-East Chicago, IN", add
label define metareadlbl 1603 "Joliet IL", add
label define metareadlbl 1604 "Lake County, IL", add
label define metareadlbl 1620 "Chico, CA", add
label define metareadlbl 1640 "Cincinnati OH/KY/IN", add
label define metareadlbl 1660 "Clarksville-Hopkinsville, TN/KY", add
label define metareadlbl 1680 "Cleveland, OH", add
label define metareadlbl 1720 "Colorado Springs, CO", add
label define metareadlbl 1740 "Columbia, MO", add
label define metareadlbl 1760 "Columbia, SC", add
label define metareadlbl 1800 "Columbus, GA/AL", add
label define metareadlbl 1840 "Columbus, OH", add
label define metareadlbl 1880 "Corpus Christi, TX", add
label define metareadlbl 1900 "Cumberland, MD/WV", add
label define metareadlbl 1920 "Dallas-Fort Worth, TX", add
label define metareadlbl 1921 "Fort Worth-Arlington, TX", add
label define metareadlbl 1930 "Danbury, CT", add
label define metareadlbl 1950 "Danville, VA", add
label define metareadlbl 1960 "Davenport, IA Rock Island-Moline, IL", add
label define metareadlbl 2000 "Dayton-Springfield, OH", add
label define metareadlbl 2001 "Springfield, OH", add
label define metareadlbl 2020 "Daytona Beach, FL", add
label define metareadlbl 2030 "Decatur, AL", add
label define metareadlbl 2040 "Decatur, IL", add
label define metareadlbl 2080 "Denver-Boulder-Longmont, CO", add
label define metareadlbl 2081 "Boulder-Longmont, CO", add
label define metareadlbl 2120 "Des Moines, IA", add
label define metareadlbl 2121 "Polk, IA", add
label define metareadlbl 2160 "Detroit, MI", add
label define metareadlbl 2180 "Dothan, AL", add
label define metareadlbl 2190 "Dover, DE", add
label define metareadlbl 2200 "Dubuque, IA", add
label define metareadlbl 2240 "Duluth-Superior, MN/WI", add
label define metareadlbl 2281 "Dutchess Co., NY", add
label define metareadlbl 2290 "Eau Claire, WI", add
label define metareadlbl 2310 "El Paso, TX", add
label define metareadlbl 2320 "Elkhart-Goshen, IN", add
label define metareadlbl 2330 "Elmira, NY", add
label define metareadlbl 2340 "Enid, OK", add
label define metareadlbl 2360 "Erie, PA", add
label define metareadlbl 2400 "Eugene-Springfield, OR", add
label define metareadlbl 2440 "Evansville, IN/KY", add
label define metareadlbl 2520 "Fargo-Morehead, ND/MN", add
label define metareadlbl 2560 "Fayetteville, NC", add
label define metareadlbl 2580 "Fayetteville-Springdale, AR", add
label define metareadlbl 2600 "Fitchburg-Leominster, MA", add
label define metareadlbl 2620 "Flagstaff, AZ-UT", add
label define metareadlbl 2640 "Flint, MI", add
label define metareadlbl 2650 "Florence, AL", add
label define metareadlbl 2660 "Florence, SC", add
label define metareadlbl 2670 "Fort Collins-Loveland, CO", add
label define metareadlbl 2680 "Fort Lauderdale-Hollywood-Pompano Beach, FL", add
label define metareadlbl 2700 "Fort Myers-Cape Coral, FL", add
label define metareadlbl 2710 "Fort Pierce, FL", add
label define metareadlbl 2720 "Fort Smith, AR/OK", add
label define metareadlbl 2750 "Fort Walton Beach, FL", add
label define metareadlbl 2760 "Fort Wayne, IN", add
label define metareadlbl 2840 "Fresno, CA", add
label define metareadlbl 2880 "Gadsden, AL", add
label define metareadlbl 2900 "Gainesville, FL", add
label define metareadlbl 2920 "Galveston-Texas City, TX", add
label define metareadlbl 2970 "Glens Falls, NY", add
label define metareadlbl 2980 "Goldsboro, NC", add
label define metareadlbl 2990 "Grand Forks, ND/MN", add
label define metareadlbl 3000 "Grand Rapids, MI", add
label define metareadlbl 3010 "Grand Junction, CO", add
label define metareadlbl 3040 "Great Falls, MT", add
label define metareadlbl 3060 "Greeley, CO", add
label define metareadlbl 3080 "Green Bay, WI", add
label define metareadlbl 3120 "Greensboro-Winston Salem-High Point, NC", add
label define metareadlbl 3121 "Winston-Salem, NC", add
label define metareadlbl 3150 "Greenville, NC", add
label define metareadlbl 3160 "Greenville-Spartanburg-Anderson SC", add
label define metareadlbl 3161 "Anderson, SC", add
label define metareadlbl 3180 "Hagerstown, MD", add
label define metareadlbl 3200 "Hamilton-Middleton, OH", add
label define metareadlbl 3240 "Harrisburg-Lebanon-Carlisle, PA", add
label define metareadlbl 3280 "Hartford-Bristol-Middleton-New Britain, CT", add
label define metareadlbl 3281 "Bristol, CT", add
label define metareadlbl 3282 "Middletown, CT", add
label define metareadlbl 3283 "New Britain, CT", add
label define metareadlbl 3290 "Hickory-Morgantown, NC", add
label define metareadlbl 3300 "Hattiesburg, MS", add
label define metareadlbl 3320 "Honolulu, HI", add
label define metareadlbl 3350 "Houma-Thibodoux, LA", add
label define metareadlbl 3360 "Houston-Brazoria, TX", add
label define metareadlbl 3361 "Brazoria, TX", add
label define metareadlbl 3400 "Huntington-Ashland, WV/KY/OH", add
label define metareadlbl 3440 "Huntsville, AL", add
label define metareadlbl 3480 "Indianapolis, IN", add
label define metareadlbl 3500 "Iowa City, IA", add
label define metareadlbl 3520 "Jackson, MI", add
label define metareadlbl 3560 "Jackson, MS", add
label define metareadlbl 3580 "Jackson, TN", add
label define metareadlbl 3590 "Jacksonville, FL", add
label define metareadlbl 3600 "Jacksonville, NC", add
label define metareadlbl 3610 "Jamestown-Dunkirk, NY", add
label define metareadlbl 3620 "Janesville-Beloit, WI", add
label define metareadlbl 3660 "Johnson City-Kingsport-Bristol, TN/VA", add
label define metareadlbl 3680 "Johnstown, PA", add
label define metareadlbl 3710 "Joplin, MO", add
label define metareadlbl 3720 "Kalamazoo-Portage, MI", add
label define metareadlbl 3740 "Kankakee, IL", add
label define metareadlbl 3760 "Kansas City, MO-KS", add
label define metareadlbl 3800 "Kenosha, WI", add
label define metareadlbl 3810 "Kileen-Temple, TX", add
label define metareadlbl 3840 "Knoxville, TN", add
label define metareadlbl 3850 "Kokomo, IN", add
label define metareadlbl 3870 "LaCrosse, WI", add
label define metareadlbl 3880 "Lafayette, LA", add
label define metareadlbl 3920 "Lafayette-W. Lafayette, IN", add
label define metareadlbl 3960 "Lake Charles, LA", add
label define metareadlbl 3980 "Lakeland-Winterhaven, FL", add
label define metareadlbl 4000 "Lancaster, PA", add
label define metareadlbl 4040 "Lansing-E. Lansing, MI", add
label define metareadlbl 4080 "Laredo, TX", add
label define metareadlbl 4100 "Las Cruces, NM", add
label define metareadlbl 4120 "Las Vegas, NV", add
label define metareadlbl 4150 "Lawrence, KS", add
label define metareadlbl 4200 "Lawton, OK", add
label define metareadlbl 4240 "Lewiston-Auburn, ME", add
label define metareadlbl 4280 "Lexington-Fayette, KY", add
label define metareadlbl 4320 "Lima, OH", add
label define metareadlbl 4360 "Lincoln, NE", add
label define metareadlbl 4400 "Little Rock-North Little Rock, AR", add
label define metareadlbl 4410 "Long Branch-Asbury Park,NJ", add
label define metareadlbl 4420 "Longview-Marshall, TX", add
label define metareadlbl 4440 "Lorain-Elyria, OH", add
label define metareadlbl 4480 "Los Angeles-Long Beach, CA", add
label define metareadlbl 4481 "Anaheim-Santa Ana-Garden Grove, CA", add
label define metareadlbl 4482 "Orange County, CA", add
label define metareadlbl 4520 "Louisville, KY/IN", add
label define metareadlbl 4600 "Lubbock, TX", add
label define metareadlbl 4640 "Lynchburg, VA", add
label define metareadlbl 4680 "Macon-Warner Robins, GA", add
label define metareadlbl 4720 "Madison, WI", add
label define metareadlbl 4760 "Manchester, NH", add
label define metareadlbl 4800 "Mansfield, OH", add
label define metareadlbl 4840 "Mayaguez, PR", add
label define metareadlbl 4880 "McAllen-Edinburg-Pharr-Mission, TX", add
label define metareadlbl 4890 "Medford, OR", add
label define metareadlbl 4900 "Melbourne-Titusville-Cocoa-Palm Bay, FL", add
label define metareadlbl 4920 "Memphis, TN/AR/MS", add
label define metareadlbl 4940 "Merced, CA", add
label define metareadlbl 5000 "Miami-Hialeah, FL", add
label define metareadlbl 5040 "Midland, TX", add
label define metareadlbl 5080 "Milwaukee, WI", add
label define metareadlbl 5120 "Minneapolis-St. Paul, MN", add
label define metareadlbl 5140 "Missoula, MT", add
label define metareadlbl 5160 "Mobile, AL", add
label define metareadlbl 5170 "Modesto, CA", add
label define metareadlbl 5190 "Monmouth-Ocean, NJ", add
label define metareadlbl 5200 "Monroe, LA", add
label define metareadlbl 5240 "Montgomery, AL", add
label define metareadlbl 5280 "Muncie, IN", add
label define metareadlbl 5320 "Muskegon-Norton Shores-Muskegon Heights, MI", add
label define metareadlbl 5330 "Myrtle Beach, SC", add
label define metareadlbl 5340 "Naples, FL", add
label define metareadlbl 5350 "Nashua, NH", add
label define metareadlbl 5360 "Nashville, TN", add
label define metareadlbl 5400 "New Bedford, MA", add
label define metareadlbl 5460 "New Brunswick-Perth Amboy-Sayreville, NJ", add
label define metareadlbl 5480 "New Haven-Meriden, CT", add
label define metareadlbl 5481 "Meriden", add
label define metareadlbl 5482 "New Haven, CT", add
label define metareadlbl 5520 "New London-Norwich, CT/RI", add
label define metareadlbl 5560 "New Orleans, LA", add
label define metareadlbl 5600 "New York-Northeastern NJ", add
label define metareadlbl 5601 "Nassau Co, NY", add
label define metareadlbl 5602 "Bergen-Passaic, NJ", add
label define metareadlbl 5603 "Jersey City, NJ", add
label define metareadlbl 5604 "Middlesex-Somerset-Hunterdon, NJ", add
label define metareadlbl 5605 "Newark, NJ", add
label define metareadlbl 5640 "Newark, OH", add
label define metareadlbl 5660 "Newburgh-Middletown, NY", add
label define metareadlbl 5720 "Norfolk-VA Beach-Newport News, VA", add
label define metareadlbl 5721 "Newport News-Hampton", add
label define metareadlbl 5722 "Norfolk- VA Beach-Portsmouth", add
label define metareadlbl 5760 "Norwalk, CT", add
label define metareadlbl 5790 "Ocala, FL", add
label define metareadlbl 5800 "Odessa, TX", add
label define metareadlbl 5880 "Oklahoma City, OK", add
label define metareadlbl 5910 "Olympia, WA", add
label define metareadlbl 5920 "Omaha, NE/IA", add
label define metareadlbl 5950 "Orange, NY", add
label define metareadlbl 5960 "Orlando, FL", add
label define metareadlbl 5990 "Owensboro, KY", add
label define metareadlbl 6010 "Panama City, FL", add
label define metareadlbl 6020 "Parkersburg-Marietta,WV/OH", add
label define metareadlbl 6030 "Pascagoula-Moss Point, MS", add
label define metareadlbl 6080 "Pensacola, FL", add
label define metareadlbl 6120 "Peoria, IL", add
label define metareadlbl 6160 "Philadelphia, PA/NJ", add
label define metareadlbl 6200 "Phoenix, AZ", add
label define metareadlbl 6240 "Pine Bluff, AR", add
label define metareadlbl 6280 "Pittsburgh-Beaver Valley, PA", add
label define metareadlbl 6281 "Beaver County, PA", add
label define metareadlbl 6320 "Pittsfield, MA", add
label define metareadlbl 6360 "Ponce, PR", add
label define metareadlbl 6400 "Portland, ME", add
label define metareadlbl 6440 "Portland-Vancouver, OR", add
label define metareadlbl 6441 "Vancouver, WA", add
label define metareadlbl 6450 "Portsmouth-Dover-Rochester, NH/ME", add
label define metareadlbl 6460 "Poughkeepsie, NY", add
label define metareadlbl 6480 "Providence-Fall River-Pawtucket, MA/RI", add
label define metareadlbl 6481 "Fall River, MA/RI", add
label define metareadlbl 6482 "Pawtuckett-Woonsocket-Attleboro, RI/MA", add
label define metareadlbl 6520 "Provo-Orem, UT", add
label define metareadlbl 6560 "Pueblo, CO", add
label define metareadlbl 6580 "Punta Gorda, FL", add
label define metareadlbl 6600 "Racine, WI", add
label define metareadlbl 6640 "Raleigh-Durham, NC", add
label define metareadlbl 6641 "Durham, NC", add
label define metareadlbl 6660 "Rapid City, SD", add
label define metareadlbl 6680 "Reading, PA", add
label define metareadlbl 6690 "Redding, CA", add
label define metareadlbl 6720 "Reno, NV", add
label define metareadlbl 6740 "Richland-Kennewick-Pasco, WA", add
label define metareadlbl 6760 "Richmond-Petersburg, VA", add
label define metareadlbl 6761 "Petersburg-Colonial Heights, VA", add
label define metareadlbl 6780 "Riverside-San Bernadino, CA", add
label define metareadlbl 6781 "San Bernadino, CA", add
label define metareadlbl 6800 "Roanoke, VA", add
label define metareadlbl 6820 "Rochester, MN", add
label define metareadlbl 6840 "Rochester, NY", add
label define metareadlbl 6880 "Rockford, IL", add
label define metareadlbl 6895 "Rocky Mount, NC", add
label define metareadlbl 6920 "Sacramento, CA", add
label define metareadlbl 6960 "Saginaw-Bay City-Midland, MI", add
label define metareadlbl 6961 "Bay City, MI", add
label define metareadlbl 6980 "St. Cloud, MN", add
label define metareadlbl 7000 "St. Joseph, MO", add
label define metareadlbl 7040 "St. Louis, MO-IL", add
label define metareadlbl 7080 "Salem, OR", add
label define metareadlbl 7120 "Salinas-Sea Side-Monterey, CA", add
label define metareadlbl 7140 "Salisbury-Concord, NC", add
label define metareadlbl 7160 "Salt Lake City-Ogden, UT", add
label define metareadlbl 7161 "Ogden", add
label define metareadlbl 7200 "San Angelo, TX", add
label define metareadlbl 7240 "San Antonio, TX", add
label define metareadlbl 7320 "San Diego, CA", add
label define metareadlbl 7360 "San Francisco-Oakland-Vallejo, CA", add
label define metareadlbl 7361 "Oakland, CA", add
label define metareadlbl 7362 "Vallejo-Fairfield-Napa, CA", add
label define metareadlbl 7400 "San Jose, CA", add
label define metareadlbl 7440 "San Juan-Bayamon, PR", add
label define metareadlbl 7460 "San Luis Obispo-Atascad-P Robles, CA", add
label define metareadlbl 7470 "Santa Barbara-Santa Maria-Lompoc, CA", add
label define metareadlbl 7480 "Santa Cruz, CA", add
label define metareadlbl 7490 "Santa Fe, NM", add
label define metareadlbl 7500 "Santa Rosa-Petaluma, CA", add
label define metareadlbl 7510 "Sarasota, FL", add
label define metareadlbl 7520 "Savannah, GA", add
label define metareadlbl 7560 "Scranton-Wilkes-Barre, PA", add
label define metareadlbl 7561 "Wilkes-Barre-Hazelton, PA", add
label define metareadlbl 7600 "Seattle-Everett, WA", add
label define metareadlbl 7610 "Sharon, PA", add
label define metareadlbl 7620 "Sheboygan, WI", add
label define metareadlbl 7640 "Sherman-Denison, TX", add
label define metareadlbl 7680 "Shreveport, LA", add
label define metareadlbl 7720 "Sioux City, IA/NE", add
label define metareadlbl 7760 "Sioux Falls, SD", add
label define metareadlbl 7800 "South Bend-Mishawaka, IN", add
label define metareadlbl 7840 "Spokane, WA", add
label define metareadlbl 7880 "Springfield, IL", add
label define metareadlbl 7920 "Springfield, MO", add
label define metareadlbl 8000 "Springfield-Holyoke-Chicopee, MA", add
label define metareadlbl 8040 "Stamford, CT", add
label define metareadlbl 8050 "State College, PA", add
label define metareadlbl 8080 "Steubenville-Weirton,OH/WV", add
label define metareadlbl 8120 "Stockton, CA", add
label define metareadlbl 8140 "Sumter, SC", add
label define metareadlbl 8160 "Syracuse, NY", add
label define metareadlbl 8200 "Tacoma, WA", add
label define metareadlbl 8240 "Tallahassee, FL", add
label define metareadlbl 8280 "Tampa-St. Petersburg-Clearwater, FL", add
label define metareadlbl 8320 "Terre Haute, IN", add
label define metareadlbl 8360 "Texarkana, TX/AR", add
label define metareadlbl 8400 "Toledo, OH/MI", add
label define metareadlbl 8440 "Topeka, KS", add
label define metareadlbl 8480 "Trenton, NJ", add
label define metareadlbl 8520 "Tucson, AZ", add
label define metareadlbl 8560 "Tulsa, OK", add
label define metareadlbl 8600 "Tuscaloosa, AL", add
label define metareadlbl 8640 "Tyler, TX", add
label define metareadlbl 8680 "Utica-Rome, NY", add
label define metareadlbl 8730 "Ventura-Oxnard-Simi Valley, CA", add
label define metareadlbl 8750 "Victoria, TX", add
label define metareadlbl 8760 "Vineland-Milville-Bridgetown, NJ", add
label define metareadlbl 8780 "Visalia-Tulare-Porterville, CA", add
label define metareadlbl 8800 "Waco, TX", add
label define metareadlbl 8840 "Washington, DC/MD/VA", add
label define metareadlbl 8880 "Waterbury, CT", add
label define metareadlbl 8920 "Waterloo-Cedar Falls, IA", add
label define metareadlbl 8940 "Wausau, WI", add
label define metareadlbl 8960 "West Palm Beach-Boca Raton-Delray Beach, FL", add
label define metareadlbl 9000 "Wheeling, WV/OH", add
label define metareadlbl 9040 "Wichita, KS", add
label define metareadlbl 9080 "Wichita Falls, TX", add
label define metareadlbl 9140 "Williamsport, PA", add
label define metareadlbl 9160 "Wilmington, DE/NJ/MD", add
label define metareadlbl 9200 "Wilmington, NC", add
label define metareadlbl 9240 "Worcester, MA", add
label define metareadlbl 9260 "Yakima, WA", add
label define metareadlbl 9270 "Yolo, CA", add
label define metareadlbl 9280 "York, PA", add
label define metareadlbl 9320 "Youngstown-Warren, OH-PA", add
label define metareadlbl 9340 "Yuba City, CA", add
label define metareadlbl 9360 "Yuma, AZ", add
label values metaread metareadlbl

label define citylbl 0000 "Not in identifiable city (or size group)", add
label define citylbl 0001 "Aberdeen, SD", add
label define citylbl 0002 "Aberdeen, WA", add
label define citylbl 0003 "Abilene, TX", add
label define citylbl 0004 "Ada, OK", add
label define citylbl 0005 "Adams, MA", add
label define citylbl 0006 "Adrian, MI", add
label define citylbl 0010 "Akron, OH", add
label define citylbl 0030 "Alameda, CA", add
label define citylbl 0050 "Albany, NY", add
label define citylbl 0051 "Albany, GA", add
label define citylbl 0052 "Albert Lea, MN", add
label define citylbl 0070 "Albuquerque, NM", add
label define citylbl 0090 "Alexandria, VA", add
label define citylbl 0091 "Alexandria, LA", add
label define citylbl 0100 "Alhambra, CA", add
label define citylbl 0101 "Aliquippa, PA", add
label define citylbl 0110 "Allegheny, PA", add
label define citylbl 0120 "Aliquippa, PA", add
label define citylbl 0130 "Allentown, PA", add
label define citylbl 0131 "Alliance, OH", add
label define citylbl 0132 "Alpena, MI", add
label define citylbl 0140 "Alton, IL", add
label define citylbl 0150 "Altoona, PA", add
label define citylbl 0160 "Amarillo, TX", add
label define citylbl 0161 "Ambridge, PA", add
label define citylbl 0162 "Ames, IA", add
label define citylbl 0163 "Amesbury, MA", add
label define citylbl 0170 "Amsterdam, NY", add
label define citylbl 0171 "Anaconda, MT", add
label define citylbl 0190 "Anaheim, CA", add
label define citylbl 0210 "Anchorage, AK", add
label define citylbl 0230 "Anderson, IN", add
label define citylbl 0231 "Anderson, SC", add
label define citylbl 0250 "Andover, MA", add
label define citylbl 0270 "Ann Arbor, MI", add
label define citylbl 0271 "Annapolis, MD", add
label define citylbl 0272 "Anniston, AL", add
label define citylbl 0273 "Ansonia, CT", add
label define citylbl 0280 "Appleton, WI", add
label define citylbl 0281 "Ardmore, OK", add
label define citylbl 0282 "Argenta, AR", add
label define citylbl 0283 "Arkansas, KS", add
label define citylbl 0290 "Arlington, TX", add
label define citylbl 0310 "Arlington, VA", add
label define citylbl 0311 "Arlington, MA", add
label define citylbl 0312 "Arnold, PA", add
label define citylbl 0313 "Asbury Park, NJ", add
label define citylbl 0330 "Asheville, NC", add
label define citylbl 0331 "Ashland, OH", add
label define citylbl 0340 "Ashland, KY", add
label define citylbl 0341 "Ashland, WI", add
label define citylbl 0342 "Ashtabula, OH", add
label define citylbl 0343 "Astoria, OR", add
label define citylbl 0344 "Atchison, KS", add
label define citylbl 0345 "Athens, GA", add
label define citylbl 0346 "Athol, MA", add
label define citylbl 0350 "Atlanta, GA", add
label define citylbl 0370 "Atlantic City, NJ", add
label define citylbl 0371 "Attleboro, MA", add
label define citylbl 0390 "Auburn, NY", add
label define citylbl 0391 "Auburn, ME", add
label define citylbl 0410 "Augusta, GA", add
label define citylbl 0430 "Augusta, ME", add
label define citylbl 0450 "Aurora, CO", add
label define citylbl 0470 "Aurora, IL", add
label define citylbl 0490 "Austin, TX", add
label define citylbl 0491 "Austin, MN", add
label define citylbl 0510 "Bakersfield, CA", add
label define citylbl 0530 "Baltimore, MD", add
label define citylbl 0550 "Bangor, ME", add
label define citylbl 0551 "Barberton, OH", add
label define citylbl 0552 "Barre, VT", add
label define citylbl 0553 "Bartlesville, OK", add
label define citylbl 0554 "Batavia, NY", add
label define citylbl 0570 "Bath, ME", add
label define citylbl 0590 "Baton Rouge, LA", add
label define citylbl 0610 "Battle Creek, MI", add
label define citylbl 0630 "Bay City, MI", add
label define citylbl 0640 "Bayamon, PR", add
label define citylbl 0650 "Bayonne, NJ", add
label define citylbl 0651 "Beacon, NY", add
label define citylbl 0652 "Beatrice, NE", add
label define citylbl 0660 "Belleville, IL", add
label define citylbl 0670 "Beaumont, TX", add
label define citylbl 0671 "Beaver Falls, PA", add
label define citylbl 0672 "Bedford, IN", add
label define citylbl 0673 "Bellaire, OH", add
label define citylbl 0680 "Bellevue, WA", add
label define citylbl 0690 "Bellingham, WA", add
label define citylbl 0700 "Belleville, NJ", add
label define citylbl 0701 "Bellevue, PA", add
label define citylbl 0702 "Belmont, OH", add
label define citylbl 0703 "Belmont, MA", add
label define citylbl 0704 "Beloit, WI", add
label define citylbl 0705 "Bennington, VT", add
label define citylbl 0706 "Benton Harbor, MI", add
label define citylbl 0710 "Berkeley, CA", add
label define citylbl 0711 "Berlin, NH", add
label define citylbl 0712 "Berwick, PA", add
label define citylbl 0720 "Berwyn, IL", add
label define citylbl 0721 "Bessemer, AL", add
label define citylbl 0730 "Bethlehem, PA", add
label define citylbl 0740 "Biddeford, ME", add
label define citylbl 0741 "Big Spring, TX", add
label define citylbl 0742 "Billings, MT", add
label define citylbl 0743 "Biloxi, MS", add
label define citylbl 0750 "Binghamton, NY", add
label define citylbl 0760 "Beverly, MA", add
label define citylbl 0761 "Beverly Hills, CA", add
label define citylbl 0770 "Birmingham, AL", add
label define citylbl 0771 "Birmingham, CT", add
label define citylbl 0772 "Bismarck, ND", add
label define citylbl 0780 "Bloomfield, NJ", add
label define citylbl 0790 "Bloomington, IL", add
label define citylbl 0791 "Bloomington, IN", add
label define citylbl 0792 "Blue Island, IL", add
label define citylbl 0793 "Bluefield, WV", add
label define citylbl 0794 "Blytheville, AR", add
label define citylbl 0795 "Bogalusa, LA", add
label define citylbl 0800 "Boise, ID", add
label define citylbl 0801 "Boone, IA", add
label define citylbl 0810 "Boston, MA", add
label define citylbl 0811 "Boulder, CO", add
label define citylbl 0812 "Bowling Green, KY", add
label define citylbl 0813 "Braddock, PA", add
label define citylbl 0814 "Braden, WA", add
label define citylbl 0815 "Bradford, PA", add
label define citylbl 0816 "Brainerd, MN", add
label define citylbl 0817 "Braintree, MA", add
label define citylbl 0818 "Brawley, CA", add
label define citylbl 0819 "Bremerton, WA", add
label define citylbl 0830 "Bridgeport, CT", add
label define citylbl 0831 "Bridgeton, NJ", add
label define citylbl 0832 "Bristol, CT", add
label define citylbl 0833 "Bristol, PA", add
label define citylbl 0834 "Bristol, VA", add
label define citylbl 0835 "Bristol, TN", add
label define citylbl 0837 "Bristol, RI", add
label define citylbl 0850 "Brockton, MA", add
label define citylbl 0851 "Brookfield, IL", add
label define citylbl 0870 "Brookline, MA", add
label define citylbl 0880 "Brownsville, TX", add
label define citylbl 0881 "Brownwood, TX", add
label define citylbl 0882 "Brunswick, GA", add
label define citylbl 0883 "Bucyrus, OH", add
label define citylbl 0890 "Buffalo, NY", add
label define citylbl 0900 "Burlington, IA", add
label define citylbl 0905 "Burlington, VT", add
label define citylbl 0906 "Burlington, NJ", add
label define citylbl 0907 "Bushkill, PA", add
label define citylbl 0910 "Butte, MT", add
label define citylbl 0911 "Butler, PA", add
label define citylbl 0920 "Burbank, CA", add
label define citylbl 0921 "Burlingame, CA", add
label define citylbl 0926 "Cairo, IL", add
label define citylbl 0927 "Calumet City, IL", add
label define citylbl 0930 "Cambridge, MA", add
label define citylbl 0931 "Cambridge, OH", add
label define citylbl 0950 "Camden, NJ", add
label define citylbl 0951 "Campbell, OH", add
label define citylbl 0952 "Canonsburg, PA", add
label define citylbl 0970 "Camden, NY", add
label define citylbl 0990 "Canton, OH", add
label define citylbl 0991 "Canton, IL", add
label define citylbl 0992 "Cape Girardeau, MO", add
label define citylbl 0993 "Carbondale, PA", add
label define citylbl 0994 "Carlisle, PA", add
label define citylbl 0995 "Carnegie, PA", add
label define citylbl 0996 "Carrick, PA", add
label define citylbl 0997 "Carteret, NJ", add
label define citylbl 0998 "Carthage, MO", add
label define citylbl 0999 "Casper, WY", add
label define citylbl 1000 "Cape Coral, FL", add
label define citylbl 1010 "Cedar Rapids, IA", add
label define citylbl 1020 "Central Falls, RI", add
label define citylbl 1021 "Centralia, IL", add
label define citylbl 1023 "Chambersburg, PA", add
label define citylbl 1024 "Champaign, IL", add
label define citylbl 1025 "Chanute, KS", add
label define citylbl 1026 "Charleroi, PA", add
label define citylbl 1030 "Charlestown, MA", add
label define citylbl 1050 "Charleston, SC", add
label define citylbl 1060 "Carolina, PR", add
label define citylbl 1070 "Charleston, WV", add
label define citylbl 1090 "Charlotte, NC", add
label define citylbl 1091 "Charlottesville, VA", add
label define citylbl 1110 "Chattanooga, TN", add
label define citylbl 1130 "Chelsea, MA", add
label define citylbl 1150 "Chesapeake, VA", add
label define citylbl 1170 "Chester, PA", add
label define citylbl 1171 "Cheyenne, WY", add
label define citylbl 1190 "Chicago, IL", add
label define citylbl 1191 "Chicago Heights, IL", add
label define citylbl 1192 "Chickasha, OK", add
label define citylbl 1210 "Chicopee, MA", add
label define citylbl 1230 "Chillicothe, OH", add
label define citylbl 1250 "Chula Vista, CA", add
label define citylbl 1270 "Cicero, IL", add
label define citylbl 1290 "Cincinnati, OH", add
label define citylbl 1291 "Clairton, PA", add
label define citylbl 1292 "Claremont, NH", add
label define citylbl 1310 "Clarksburg, WV", add
label define citylbl 1311 "Clarksdale, MS", add
label define citylbl 1312 "Cleburne, TX", add
label define citylbl 1330 "Cleveland, OH", add
label define citylbl 1340 "Cleveland Heights, OH", add
label define citylbl 1341 "Cliffside Park, NJ", add
label define citylbl 1350 "Clifton, NJ", add
label define citylbl 1351 "Clinton, IN", add
label define citylbl 1370 "Clinton, IA", add
label define citylbl 1371 "Clinton, MA", add
label define citylbl 1372 "Coatesville, PA", add
label define citylbl 1373 "Coffeyville, KS", add
label define citylbl 1374 "Cohoes, NY", add
label define citylbl 1375 "Collingswood, NJ", add
label define citylbl 1390 "Colorado Springs, CO", add
label define citylbl 1400 "Cohoes, NY", add
label define citylbl 1410 "Columbia, SC", add
label define citylbl 1411 "Columbia, PA", add
label define citylbl 1412 "Columbia, MO", add
label define citylbl 1420 "Columbia City, IN", add
label define citylbl 1430 "Columbus, GA", add
label define citylbl 1450 "Columbus, OH", add
label define citylbl 1451 "Columbus, MS", add
label define citylbl 1452 "Compton, CA", add
label define citylbl 1470 "Concord, CA", add
label define citylbl 1490 "Concord, NH", add
label define citylbl 1491 "Concord, NC", add
label define citylbl 1492 "Connellsville, PA", add
label define citylbl 1493 "Connersville, IN", add
label define citylbl 1494 "Conshohocken, PA", add
label define citylbl 1495 "Coraopolis, PA", add
label define citylbl 1496 "Corning, NY", add
label define citylbl 1500 "Corona, CA", add
label define citylbl 1510 "Council Bluffs, IA", add
label define citylbl 1520 "Corpus Christi, TX", add
label define citylbl 1521 "Corsicana, TX", add
label define citylbl 1522 "Cortland, NY", add
label define citylbl 1523 "Coshocton, OH", add
label define citylbl 1530 "Covington, KY", add
label define citylbl 1540 "Costa Mesa, CA", add
label define citylbl 1550 "Cranston, RI", add
label define citylbl 1551 "Crawfordsville, IN", add
label define citylbl 1552 "Cripple Creek, CO", add
label define citylbl 1553 "Cudahy, WI", add
label define citylbl 1570 "Cumberland, MD", add
label define citylbl 1571 "Cumberland, RI", add
label define citylbl 1572 "Cuyahoga Falls, OH", add
label define citylbl 1590 "Dallas, TX", add
label define citylbl 1591 "Danbury, CT", add
label define citylbl 1610 "Danvers, MA", add
label define citylbl 1630 "Danville, IL", add
label define citylbl 1631 "Danville, VA", add
label define citylbl 1650 "Davenport, IA", add
label define citylbl 1670 "Dayton, OH", add
label define citylbl 1671 "Daytona Beach, FL", add
label define citylbl 1680 "Dearborn, MI", add
label define citylbl 1690 "Decatur, IL", add
label define citylbl 1691 "Decatur, AL", add
label define citylbl 1692 "Decatur, GA", add
label define citylbl 1693 "Dedham, MA", add
label define citylbl 1694 "Del Rio, TX", add
label define citylbl 1695 "Denison, TX", add
label define citylbl 1710 "Denver, CO", add
label define citylbl 1711 "Derby, CT", add
label define citylbl 1713 "Derry, PA", add
label define citylbl 1730 "Des Moines, IA", add
label define citylbl 1750 "Detroit, MI", add
label define citylbl 1751 "Dickson City, PA", add
label define citylbl 1752 "Dodge, KS", add
label define citylbl 1753 "Donora, PA", add
label define citylbl 1754 "Dormont, PA", add
label define citylbl 1755 "Dothan, AL", add
label define citylbl 1770 "Dorchester, MA", add
label define citylbl 1790 "Dover, NH", add
label define citylbl 1791 "Dover, NJ", add
label define citylbl 1792 "Du Bois, PA", add
label define citylbl 1800 "Downey, CA", add
label define citylbl 1810 "Dubuque, IA", add
label define citylbl 1830 "Duluth, MN", add
label define citylbl 1831 "Dunkirk, NY", add
label define citylbl 1832 "Dunmore, PA", add
label define citylbl 1833 "Duquesne, PA", add
label define citylbl 1850 "Durham, NC", add
label define citylbl 1870 "East Chicago, IN", add
label define citylbl 1890 "East Cleveland, OH", add
label define citylbl 1891 "East Hartford, CT", add
label define citylbl 1892 "East Liverpool, OH", add
label define citylbl 1893 "East Moline, IL", add
label define citylbl 1910 "East Los Angeles, CA", add
label define citylbl 1930 "East Orange, NJ", add
label define citylbl 1931 "East Providence, RI", add
label define citylbl 1940 "East Saginaw, MI", add
label define citylbl 1950 "East St. Louis, IL", add
label define citylbl 1951 "East Youngstown, OH", add
label define citylbl 1952 "Easthampton, MA", add
label define citylbl 1970 "Easton, PA", add
label define citylbl 1971 "Eau Claire, WI", add
label define citylbl 1972 "Ecorse, MI", add
label define citylbl 1973 "El Dorado, KS", add
label define citylbl 1974 "El Dorado, AR", add
label define citylbl 1990 "El Monte, CA", add
label define citylbl 2010 "El Paso, TX", add
label define citylbl 2030 "Elgin, IL", add
label define citylbl 2040 "Elyria, OH", add
label define citylbl 2050 "Elizabeth, NJ", add
label define citylbl 2051 "Elizabeth City, NC", add
label define citylbl 2060 "Elkhart, IN", add
label define citylbl 2061 "Ellwood City, PA", add
label define citylbl 2062 "Elmhurst, IL", add
label define citylbl 2070 "Elmira, NY", add
label define citylbl 2071 "Elmwood Park, IL", add
label define citylbl 2072 "Elwood, IN", add
label define citylbl 2073 "Emporia, KS", add
label define citylbl 2074 "Endicott, NY", add
label define citylbl 2075 "Enfield, CT", add
label define citylbl 2076 "Englewood, NJ", add
label define citylbl 2080 "Enid, OK", add
label define citylbl 2090 "Erie, PA", add
label define citylbl 2091 "Escanaba, MI", add
label define citylbl 2092 "Euclid, OH", add
label define citylbl 2110 "Escondido, CA", add
label define citylbl 2130 "Eugene, OR", add
label define citylbl 2131 "Eureka, CA", add
label define citylbl 2150 "Evanston, IL", add
label define citylbl 2170 "Evansville, IN", add
label define citylbl 2190 "Everett, MA", add
label define citylbl 2210 "Everett, WA", add
label define citylbl 2211 "Fairfield, AL", add
label define citylbl 2212 "Fairfield, CT", add
label define citylbl 2213 "Fairhaven, MA", add
label define citylbl 2214 "Fairmont, WV", add
label define citylbl 2220 "Fargo, ND", add
label define citylbl 2221 "Faribault, MN", add
label define citylbl 2222 "Farrell, PA", add
label define citylbl 2230 "Fall River, MA", add
label define citylbl 2240 "Fayetteville, NC", add
label define citylbl 2241 "Ferndale, MI", add
label define citylbl 2242 "Findlay, OH", add
label define citylbl 2250 "Fitchburg, MA", add
label define citylbl 2260 "Fontana, CA", add
label define citylbl 2270 "Flint, MI", add
label define citylbl 2271 "Floral Park, NY", add
label define citylbl 2273 "Florence, AL", add
label define citylbl 2274 "Florence, SC", add
label define citylbl 2275 "Flushing, NY", add
label define citylbl 2280 "Fond du Lac, WI", add
label define citylbl 2281 "Forest Park, IL", add
label define citylbl 2290 "Fort Lauderdale, FL", add
label define citylbl 2300 "Fort Collins, CO", add
label define citylbl 2301 "Fort Dodge, IA", add
label define citylbl 2302 "Fort Madison, IA", add
label define citylbl 2303 "Fort Scott, KS", add
label define citylbl 2310 "Fort Smith, AR", add
label define citylbl 2311 "Fort Thomas, KY", add
label define citylbl 2330 "Fort Wayne, IN", add
label define citylbl 2350 "Fort Worth, TX", add
label define citylbl 2351 "Fostoria, OH", add
label define citylbl 2352 "Framingham, MA", add
label define citylbl 2353 "Frankfort, IN", add
label define citylbl 2354 "Frankfort, KY", add
label define citylbl 2355 "Franklin, PA", add
label define citylbl 2356 "Frederick, MD", add
label define citylbl 2357 "Freeport, NY", add
label define citylbl 2358 "Freeport, IL", add
label define citylbl 2359 "Fremont, OH", add
label define citylbl 2360 "Fremont, NE", add
label define citylbl 2370 "Fresno, CA", add
label define citylbl 2390 "Fullerton, CA", add
label define citylbl 2391 "Fulton, NY", add
label define citylbl 2392 "Gadsden, AL", add
label define citylbl 2393 "Galena, KS", add
label define citylbl 2400 "Galesburg, IL", add
label define citylbl 2410 "Galveston, TX", add
label define citylbl 2411 "Gardner, MA", add
label define citylbl 2430 "Garden Grove, CA", add
label define citylbl 2440 "Garfield, NJ", add
label define citylbl 2441 "Garfield Heights, OH", add
label define citylbl 2450 "Garland, TX", add
label define citylbl 2470 "Gary, IN", add
label define citylbl 2471 "Gastonia, NC", add
label define citylbl 2472 "Geneva, NY", add
label define citylbl 2473 "Glen Cove, NY", add
label define citylbl 2490 "Glendale, CA", add
label define citylbl 2491 "Glens Falls, NY", add
label define citylbl 2510 "Gloucester, MA", add
label define citylbl 2511 "Gloucester, NJ", add
label define citylbl 2512 "Gloversville, NY", add
label define citylbl 2513 "Goldsboro, NC", add
label define citylbl 2514 "Goshen, IN", add
label define citylbl 2515 "Grand Forks, ND", add
label define citylbl 2516 "Grand Island, NE", add
label define citylbl 2517 "Grand Junction, CO", add
label define citylbl 2520 "Granite City, IL", add
label define citylbl 2530 "Grand Rapids, MI", add
label define citylbl 2531 "Grandville, MI", add
label define citylbl 2540 "Great Falls, MT", add
label define citylbl 2541 "Greeley, CO", add
label define citylbl 2550 "Green Bay, WI", add
label define citylbl 2551 "Greenfield, MA", add
label define citylbl 2570 "Greensboro, NC", add
label define citylbl 2571 "Greensburg, PA", add
label define citylbl 2572 "Greenville, MS", add
label define citylbl 2573 "Greenville, SC", add
label define citylbl 2574 "Greenville, TX", add
label define citylbl 2575 "Greenwich, CT", add
label define citylbl 2576 "Greenwood, MS", add
label define citylbl 2577 "Greenwood, SC", add
label define citylbl 2578 "Griffin, GA", add
label define citylbl 2579 "Grosse Pointe Park, MI", add
label define citylbl 2580 "Guynabo, PR", add
label define citylbl 2581 "Groton, CT", add
label define citylbl 2582 "Gulfport, MS", add
label define citylbl 2583 "Guthrie, OK", add
label define citylbl 2584 "Hackensack, NJ", add
label define citylbl 2590 "Hagerstown, MD", add
label define citylbl 2591 "Hamden, CT", add
label define citylbl 2610 "Hamilton, OH", add
label define citylbl 2630 "Hammond, IN", add
label define citylbl 2650 "Hampton, VA", add
label define citylbl 2670 "Hamtramck Village, MI", add
label define citylbl 2680 "Hannibal, MO", add
label define citylbl 2681 "Hanover, PA", add
label define citylbl 2682 "Harlingen, TX", add
label define citylbl 2690 "Harrisburg, PA", add
label define citylbl 2691 "Harrisburg, IL", add
label define citylbl 2692 "Harrison, NJ", add
label define citylbl 2710 "Hartford, CT", add
label define citylbl 2711 "Harvey, IL", add
label define citylbl 2712 "Hastings, NE", add
label define citylbl 2713 "Hattiesburg, MS", add
label define citylbl 2730 "Haverhill, MA", add
label define citylbl 2731 "Hawthorne, NJ", add
label define citylbl 2750 "Hazleton, PA", add
label define citylbl 2751 "Helena, MT", add
label define citylbl 2752 "Hempstead, NY", add
label define citylbl 2753 "Henderson, KY", add
label define citylbl 2754 "Herkimer, NY", add
label define citylbl 2755 "Herrin, IL", add
label define citylbl 2756 "Hibbing, MN", add
label define citylbl 2770 "Hialeah, FL", add
label define citylbl 2780 "High Point, NC", add
label define citylbl 2781 "Highland Park, IL", add
label define citylbl 2790 "Highland Park, MI", add
label define citylbl 2791 "Hilo, HI", add
label define citylbl 2810 "Hoboken, NJ", add
label define citylbl 2811 "Holland, MI", add
label define citylbl 2830 "Hollywood, FL", add
label define citylbl 2850 "Holyoke, MA", add
label define citylbl 2851 "Homestead, PA", add
label define citylbl 2870 "Honolulu, HI", add
label define citylbl 2871 "Hopewell, VA", add
label define citylbl 2872 "Hopkinsville, KY", add
label define citylbl 2873 "Hoquiam, WA", add
label define citylbl 2874 "Hornell, NY", add
label define citylbl 2875 "Hot Springs, AR", add
label define citylbl 2890 "Houston, TX", add
label define citylbl 2891 "Hudson, NY", add
label define citylbl 2892 "Huntington, IN", add
label define citylbl 2910 "Huntington, WV", add
label define citylbl 2930 "Huntingon Beach, CA", add
label define citylbl 2950 "Huntsville, AL", add
label define citylbl 2951 "Huron, SD", add
label define citylbl 2960 "Hutchinson, KS", add
label define citylbl 2961 "Hyde Park, MA", add
label define citylbl 2962 "Ilion, NY", add
label define citylbl 2963 "Independence, KS", add
label define citylbl 2970 "Independence, MO", add
label define citylbl 2990 "Indianapolis, IN", add
label define citylbl 3010 "Inglewood, CA", add
label define citylbl 3011 "Iowa City, IA", add
label define citylbl 3012 "Iron Mountain, MI", add
label define citylbl 3013 "Ironton, OH", add
label define citylbl 3014 "Ironwood, MI", add
label define citylbl 3020 "Irvine, CA", add
label define citylbl 3030 "Irving, TX", add
label define citylbl 3050 "Irvington, NJ", add
label define citylbl 3051 "Ishpeming, MI", add
label define citylbl 3052 "Ithaca, NY", add
label define citylbl 3070 "Jackson, MI", add
label define citylbl 3071 "Jackson, MN", add
label define citylbl 3090 "Jackson, MS", add
label define citylbl 3091 "Jackson, TN", add
label define citylbl 3110 "Jacksonville, FL", add
label define citylbl 3111 "Jacksonville, IL", add
label define citylbl 3130 "Jamestown , NY", add
label define citylbl 3131 "Janesville, WI", add
label define citylbl 3132 "Jeannette, PA", add
label define citylbl 3133 "Jefferson City, MO", add
label define citylbl 3134 "Jeffersonville, IN", add
label define citylbl 3150 "Jersey City, NJ", add
label define citylbl 3151 "Johnson City, NY", add
label define citylbl 3160 "Johnson City, TN", add
label define citylbl 3161 "Johnstown, NY", add
label define citylbl 3170 "Johnstown, PA", add
label define citylbl 3190 "Joliet, IL", add
label define citylbl 3191 "Jonesboro, AR", add
label define citylbl 3210 "Joplin, MO", add
label define citylbl 3230 "Kalamazoo, MI", add
label define citylbl 3231 "Kankakee, IL", add
label define citylbl 3250 "Kansas City, KS", add
label define citylbl 3260 "Kansas City, MO", add
label define citylbl 3270 "Kearny, NJ", add
label define citylbl 3271 "Keene, NH", add
label define citylbl 3272 "Kenmore, NY", add
label define citylbl 3273 "Kenmore, OH", add
label define citylbl 3290 "Kenosha, WI", add
label define citylbl 3291 "Keokuk, IA", add
label define citylbl 3292 "Kewanee, IL", add
label define citylbl 3293 "Key West, FL", add
label define citylbl 3294 "Kingsport, TN", add
label define citylbl 3310 "Kingston, NY", add
label define citylbl 3311 "Kingston, PA", add
label define citylbl 3312 "Kinston, NC", add
label define citylbl 3313 "Klamath Falls, OR", add
label define citylbl 3330 "Knoxville, TN", add
label define citylbl 3350 "Kokomo, IN", add
label define citylbl 3370 "La Crosse, WI", add
label define citylbl 3380 "Lafayette, IL", add
label define citylbl 3390 "Lafayette, LA", add
label define citylbl 3391 "La Grange, IL", add
label define citylbl 3392 "La Grange, GA", add
label define citylbl 3393 "La Porte, IN", add
label define citylbl 3394 "La Salle, IL", add
label define citylbl 3395 "Lackawanna, NY", add
label define citylbl 3396 "Laconia, NH", add
label define citylbl 3410 "Lakewood, CO", add
label define citylbl 3430 "Lakewood, OH", add
label define citylbl 3440 "Lancaster, CA", add
label define citylbl 3450 "Lancaster, PA", add
label define citylbl 3451 "Lancaster, OH", add
label define citylbl 3470 "Lansing, MI", add
label define citylbl 3471 "Lansingburgh, NY", add
label define citylbl 3480 "Laredo, TX", add
label define citylbl 3481 "Latrobe, PA", add
label define citylbl 3482 "Laurel, MS", add
label define citylbl 3490 "Las Vegas, NV", add
label define citylbl 3510 "Lawrence, MA", add
label define citylbl 3511 "Lawrence, KS", add
label define citylbl 3512 "Lawton, OK", add
label define citylbl 3513 "Leadville, CO", add
label define citylbl 3520 "Leavenworth, KS", add
label define citylbl 3521 "Lebanon, PA", add
label define citylbl 3522 "Leominster, MA", add
label define citylbl 3530 "Lehigh, PA", add
label define citylbl 3540 "Lebanon, PA", add
label define citylbl 3550 "Lewiston, ME", add
label define citylbl 3551 "Lewistown, PA", add
label define citylbl 3570 "Lexington, KY", add
label define citylbl 3590 "Lexington-Fayette, KY", add
label define citylbl 3610 "Lima, OH", add
label define citylbl 3630 "Lincoln, NE", add
label define citylbl 3631 "Lincoln, IL", add
label define citylbl 3632 "Lincoln Park, MI", add
label define citylbl 3633 "Lincoln, RI", add
label define citylbl 3634 "Linden, NJ", add
label define citylbl 3635 "Little Falls, NY", add
label define citylbl 3638 "Lodi, NJ", add
label define citylbl 3639 "Logansport, IN", add
label define citylbl 3650 "Little Rock, AR", add
label define citylbl 3670 "Livonia, MI", add
label define citylbl 3680 "Lockport, NY", add
label define citylbl 3690 "Long Beach, CA", add
label define citylbl 3691 "Long Branch, NJ", add
label define citylbl 3692 "Long Island City, NY", add
label define citylbl 3693 "Longview, WA", add
label define citylbl 3710 "Lorain, OH", add
label define citylbl 3730 "Los Angeles, CA", add
label define citylbl 3750 "Louisville, KY", add
label define citylbl 3770 "Lowell, MA", add
label define citylbl 3771 "Lubbock, TX", add
label define citylbl 3772 "Lynbrook, NY", add
label define citylbl 3790 "Lynchburg, VA", add
label define citylbl 3810 "Lynn, MA", add
label define citylbl 3830 "Macon, GA", add
label define citylbl 3850 "Madison, IN", add
label define citylbl 3870 "Madison, WI", add
label define citylbl 3871 "Mahanoy City, PA", add
label define citylbl 3890 "Malden, MA", add
label define citylbl 3891 "Mamaroneck, NY", add
label define citylbl 3910 "Manchester, NH", add
label define citylbl 3911 "Manchester, CT", add
label define citylbl 3912 "Manhattan, KS", add
label define citylbl 3913 "Manistee, MI", add
label define citylbl 3914 "Manitowoc, WI", add
label define citylbl 3915 "Mankato, MN", add
label define citylbl 3930 "Mansfield, OH", add
label define citylbl 3931 "Maplewood, MO", add
label define citylbl 3932 "Marietta, OH", add
label define citylbl 3933 "Marinette, WI", add
label define citylbl 3934 "Marion, IN", add
label define citylbl 3940 "Maywood, IL", add
label define citylbl 3950 "Marion, OH", add
label define citylbl 3951 "Marlborough, MA", add
label define citylbl 3952 "Marquette, MI", add
label define citylbl 3953 "Marshall, TX", add
label define citylbl 3954 "Marshalltown, IA", add
label define citylbl 3955 "Martins Ferry, OH", add
label define citylbl 3956 "Martinsburg, WV", add
label define citylbl 3957 "Mason City, IA", add
label define citylbl 3958 "Massena, NY", add
label define citylbl 3959 "Massillon, OH", add
label define citylbl 3960 "McAllen, TX", add
label define citylbl 3961 "Mattoon, IL", add
label define citylbl 3962 "Mcalester, OK", add
label define citylbl 3963 "Mccomb, MS", add
label define citylbl 3964 "Mckees Rocks, PA", add
label define citylbl 3970 "McKeesport, PA", add
label define citylbl 3971 "Meadville, PA", add
label define citylbl 3990 "Medford, MA", add
label define citylbl 3991 "Medford, OR", add
label define citylbl 3992 "Melrose, MA", add
label define citylbl 3993 "Melrose Park, IL", add
label define citylbl 4010 "Memphis, TN", add
label define citylbl 4011 "Menominee, MI", add
label define citylbl 4030 "Meriden, CT", add
label define citylbl 4040 "Meridian, MS", add
label define citylbl 4041 "Methuen, MA", add
label define citylbl 4050 "Mesa, AZ", add
label define citylbl 4070 "Mesquite, TX", add
label define citylbl 4090 "Metairie, LA", add
label define citylbl 4110 "Miami, FL", add
label define citylbl 4120 "Michigan City, IN", add
label define citylbl 4121 "Middlesborough, KY", add
label define citylbl 4122 "Middletown, CT", add
label define citylbl 4123 "Middletown, NY", add
label define citylbl 4124 "Middletown, OH", add
label define citylbl 4125 "Milford, CT", add
label define citylbl 4126 "Milford, MA", add
label define citylbl 4127 "Millville, NJ", add
label define citylbl 4128 "Milton, MA", add
label define citylbl 4130 "Milwaukee, WI", add
label define citylbl 4150 "Minneapolis, MN", add
label define citylbl 4151 "Minot, ND", add
label define citylbl 4160 "Mishawaka, IN", add
label define citylbl 4161 "Missoula, MT", add
label define citylbl 4162 "Mitchell, SD", add
label define citylbl 4163 "Moberly, MO", add
label define citylbl 4170 "Mobile, AL", add
label define citylbl 4190 "Modesto, CA", add
label define citylbl 4210 "Moline, IL", add
label define citylbl 4211 "Monessen, PA", add
label define citylbl 4212 "Monroe, MI", add
label define citylbl 4213 "Monroe, LA", add
label define citylbl 4214 "Monrovia, CA", add
label define citylbl 4230 "Montclair, NJ", add
label define citylbl 4250 "Montgomery, AL", add
label define citylbl 4251 "Morgantown, WV", add
label define citylbl 4252 "Morristown, NJ", add
label define citylbl 4253 "Moundsville, WV", add
label define citylbl 4254 "Mount Arlington, NJ", add
label define citylbl 4255 "Mount Carmel, PA", add
label define citylbl 4256 "Mount Clemens, MI", add
label define citylbl 4270 "Moreno Valley, CA", add
label define citylbl 4290 "Mount Vernon, NY", add
label define citylbl 4291 "Mount Vernon, IL", add
label define citylbl 4310 "Muncie, IN", add
label define citylbl 4311 "Munhall, PA", add
label define citylbl 4312 "Murphysboro, IL", add
label define citylbl 4313 "Muscatine, IA", add
label define citylbl 4330 "Muskegon, MI", add
label define citylbl 4331 "Muskegon Heights, MI", add
label define citylbl 4350 "Muskogee, OK", add
label define citylbl 4351 "Nanticoke, PA", add
label define citylbl 4370 "Nantucket, MA", add
label define citylbl 4390 "Nashua, NH", add
label define citylbl 4410 "Nashville-Davidson, TN", add
label define citylbl 4411 "Nashville, TN", add
label define citylbl 4413 "Natchez, MS", add
label define citylbl 4414 "Natick, MA", add
label define citylbl 4415 "Naugatuck, CT", add
label define citylbl 4416 "Needham, MA", add
label define citylbl 4430 "New Albany, IN", add
label define citylbl 4450 "New Bedford, MA", add
label define citylbl 4451 "New Bern, NC", add
label define citylbl 4452 "New Brighton, NY", add
label define citylbl 4470 "New Britain, CT", add
label define citylbl 4490 "New Brunswick, NJ", add
label define citylbl 4510 "New Castle, PA", add
label define citylbl 4511 "New Castle, IN", add
label define citylbl 4530 "New Haven, CT", add
label define citylbl 4550 "New London, CT", add
label define citylbl 4570 "New Orleans, LA", add
label define citylbl 4571 "New Philadelphia, OH", add
label define citylbl 4590 "New Rochelle, NY", add
label define citylbl 4610 "New York, NY", add
label define citylbl 4611 "Brooklyn (only in census years before 1900)", add
label define citylbl 4630 "Newark, NJ", add
label define citylbl 4650 "Newark, OH", add
label define citylbl 4670 "Newburgh, NY", add
label define citylbl 4690 "Newburyport, MA", add
label define citylbl 4710 "Newport, KY", add
label define citylbl 4730 "Newport, RI", add
label define citylbl 4750 "Newport News, VA", add
label define citylbl 4770 "Newton, MA", add
label define citylbl 4771 "Newton, IA", add
label define citylbl 4772 "Newton, KS", add
label define citylbl 4790 "Niagara Falls, NY", add
label define citylbl 4791 "Niles, MI", add
label define citylbl 4792 "Niles, OH", add
label define citylbl 4810 "Norfolk, VA", add
label define citylbl 4811 "Norfolk, NE", add
label define citylbl 4820 "North Las Vegas, NV", add
label define citylbl 4830 "Norristown Borough, PA", add
label define citylbl 4831 "North Adams, MA", add
label define citylbl 4832 "North Attleborough, MA", add
label define citylbl 4833 "North Bennington, VT", add
label define citylbl 4834 "North Braddock, PA", add
label define citylbl 4835 "North Branford, CT", add
label define citylbl 4836 "North Haven, CT", add
label define citylbl 4837 "North Little Rock, AR", add
label define citylbl 4838 "North Platte, NE", add
label define citylbl 4839 "North Providence, RI", add
label define citylbl 4840 "Northampton, MA", add
label define citylbl 4841 "North Tonawanda, NY", add
label define citylbl 4842 "North Yakima, WA", add
label define citylbl 4843 "Northbridge, MA", add
label define citylbl 4850 "North Providence, RI", add
label define citylbl 4860 "Norwalk, CA", add
label define citylbl 4870 "Norwalk, CT", add
label define citylbl 4890 "Norwich, CT", add
label define citylbl 4900 "Norwood, OH", add
label define citylbl 4901 "Norwood, MA", add
label define citylbl 4902 "Nutley, NJ", add
label define citylbl 4910 "Oak Park Village", add
label define citylbl 4930 "Oakland, CA", add
label define citylbl 4950 "Oceanside, CA", add
label define citylbl 4970 "Ogden, UT", add
label define citylbl 4971 "Ogdensburg, NY", add
label define citylbl 4972 "Oil City, PA", add
label define citylbl 4990 "Oklahoma City, OK", add
label define citylbl 4991 "Okmulgee, OK", add
label define citylbl 4992 "Old Bennington, VT", add
label define citylbl 4993 "Old Forge, PA", add
label define citylbl 4994 "Olean, NY", add
label define citylbl 4995 "Olympia, WA", add
label define citylbl 4996 "Olyphant, PA", add
label define citylbl 5010 "Omaha, NE", add
label define citylbl 5011 "Oneida, NY", add
label define citylbl 5012 "Oneonta, NY", add
label define citylbl 5030 "Ontario, CA", add
label define citylbl 5040 "Orange, CA", add
label define citylbl 5050 "Orange, NJ", add
label define citylbl 5051 "Orange, CT", add
label define citylbl 5070 "Orlando, FL", add
label define citylbl 5090 "Oshkosh, WI", add
label define citylbl 5091 "Oskaloosa, IA", add
label define citylbl 5092 "Ossining, NY", add
label define citylbl 5110 "Oswego, NY", add
label define citylbl 5111 "Ottawa, IL", add
label define citylbl 5112 "Ottumwa, IA", add
label define citylbl 5113 "Owensboro, KY", add
label define citylbl 5114 "Owosso, MI", add
label define citylbl 5116 "Painesville, OH", add
label define citylbl 5117 "Palestine, TX", add
label define citylbl 5118 "Palo Alto, CA", add
label define citylbl 5119 "Pampa, TX", add
label define citylbl 5121 "Paris, TX", add
label define citylbl 5122 "Park Ridge, IL", add
label define citylbl 5123 "Parkersburg, WV", add
label define citylbl 5124 "Parma, OH", add
label define citylbl 5125 "Parsons, KS", add
label define citylbl 5130 "Oxnard, CA", add
label define citylbl 5140 "Palmdale, CA", add
label define citylbl 5150 "Pasadena, CA", add
label define citylbl 5170 "Pasadena, TX", add
label define citylbl 5180 "Paducah, KY", add
label define citylbl 5190 "Passaic, NJ", add
label define citylbl 5210 "Paterson, NJ", add
label define citylbl 5230 "Pawtucket, RI", add
label define citylbl 5231 "Peabody, MA", add
label define citylbl 5232 "Peekskill, NY", add
label define citylbl 5233 "Pekin, IL", add
label define citylbl 5250 "Pensacola, FL", add
label define citylbl 5270 "Peoria, IL", add
label define citylbl 5271 "Peoria Heights, IL", add
label define citylbl 5290 "Perth Amboy, NJ", add
label define citylbl 5291 "Peru, IN", add
label define citylbl 5310 "Petersburg, VA", add
label define citylbl 5311 "Phenix City, AL", add
label define citylbl 5330 "Philadelphia, PA", add
label define citylbl 5331 "Kensington", add
label define citylbl 5332 "Mayamensing", add
label define citylbl 5333 "Northern Liberties", add
label define citylbl 5334 "Southwark", add
label define citylbl 5335 "Spring Garden", add
label define citylbl 5341 "Phillipsburg, NJ", add
label define citylbl 5350 "Phoenix, AZ", add
label define citylbl 5351 "Phoenixville, PA", add
label define citylbl 5352 "Pine Bluff, AR", add
label define citylbl 5353 "Piqua, OH", add
label define citylbl 5354 "Pittsburg, KS", add
label define citylbl 5370 "Pittsburgh, PA", add
label define citylbl 5390 "Pittsfield, MA", add
label define citylbl 5391 "Pittston, PA", add
label define citylbl 5410 "Plainfield, NJ", add
label define citylbl 5411 "Plattsburg, NY", add
label define citylbl 5412 "Pleasantville, NJ", add
label define citylbl 5413 "Plymouth, PA", add
label define citylbl 5414 "Plymouth, MA", add
label define citylbl 5415 "Pocatello, ID", add
label define citylbl 5430 "Plano, TX", add
label define citylbl 5450 "Pomona, CA", add
label define citylbl 5451 "Ponca City, OK", add
label define citylbl 5460 "Ponce, PR", add
label define citylbl 5470 "Pontiac, MI", add
label define citylbl 5471 "Port Angeles, WA", add
label define citylbl 5480 "Port Arthur, TX", add
label define citylbl 5481 "Port Chester, NY", add
label define citylbl 5490 "Port Huron, MI", add
label define citylbl 5491 "Port Jervis, NY", add
label define citylbl 5510 "Portland, ME", add
label define citylbl 5511 "Portland, IL", add
label define citylbl 5530 "Portland, OR", add
label define citylbl 5550 "Portsmouth, NH", add
label define citylbl 5570 "Portsmouth, OH", add
label define citylbl 5590 "Portsmouth, VA", add
label define citylbl 5591 "Pottstown, PA", add
label define citylbl 5610 "Pottsville, PA", add
label define citylbl 5630 "Poughkeepsie, NY", add
label define citylbl 5650 "Providence, RI", add
label define citylbl 5660 "Provo, UT", add
label define citylbl 5670 "Pueblo, CO", add
label define citylbl 5671 "Punxsutawney, PA", add
label define citylbl 5690 "Quincy, IL", add
label define citylbl 5710 "Quincy, MA", add
label define citylbl 5730 "Racine, WI", add
label define citylbl 5731 "Rahway, NJ", add
label define citylbl 5750 "Raleigh, NC", add
label define citylbl 5751 "Ranger, TX", add
label define citylbl 5752 "Rapid City, SD", add
label define citylbl 5770 "Rancho Cucamonga, CA", add
label define citylbl 5790 "Reading, PA", add
label define citylbl 5791 "Red Bank, NJ", add
label define citylbl 5792 "Redlands, CA", add
label define citylbl 5810 "Reno, NV", add
label define citylbl 5811 "Rensselaer, NY", add
label define citylbl 5830 "Revere, MA", add
label define citylbl 5850 "Richmond, IN", add
label define citylbl 5870 "Richmond, VA", add
label define citylbl 5871 "Richmond, CA", add
label define citylbl 5872 "Ridgefield Park, NJ", add
label define citylbl 5873 "Ridgewood, NJ", add
label define citylbl 5874 "River Rouge, MI", add
label define citylbl 5890 "Riverside, CA", add
label define citylbl 5910 "Roanoke, VA", add
label define citylbl 5930 "Rochester, NY", add
label define citylbl 5931 "Rochester, NH", add
label define citylbl 5932 "Rochester, MN", add
label define citylbl 5933 "Rock Hill, SC", add
label define citylbl 5950 "Rock Island, IL", add
label define citylbl 5970 "Rockford, IL", add
label define citylbl 5971 "Rockland, ME", add
label define citylbl 5972 "Rockton, IL", add
label define citylbl 5973 "Rockville Centre, NY", add
label define citylbl 5974 "Rocky Mount, NC", add
label define citylbl 5990 "Rome, NY", add
label define citylbl 5991 "Rome, GA", add
label define citylbl 5992 "Roosevelt, NJ", add
label define citylbl 5993 "Roselle, NJ", add
label define citylbl 5994 "Roswell, NM", add
label define citylbl 6010 "Roxbury, MA", add
label define citylbl 6011 "Royal Oak, MI", add
label define citylbl 6012 "Rumford Falls, ME", add
label define citylbl 6013 "Rutherford, NJ", add
label define citylbl 6014 "Rutland, VT", add
label define citylbl 6030 "Sacramento, CA", add
label define citylbl 6050 "Saginaw, MI", add
label define citylbl 6070 "Saint Joseph, MO", add
label define citylbl 6090 "Saint Louis, MO", add
label define citylbl 6110 "Saint Paul, MN", add
label define citylbl 6130 "Saint Petersburg, FL", add
label define citylbl 6150 "Salem, MA", add
label define citylbl 6170 "Salem, OR", add
label define citylbl 6171 "Salem, OH", add
label define citylbl 6172 "Salina, KS", add
label define citylbl 6190 "Salinas, CA", add
label define citylbl 6191 "Salisbury, NC", add
label define citylbl 6192 "Salisbury, MD", add
label define citylbl 6210 "Salt Lake City, UT", add
label define citylbl 6211 "San Angelo, TX", add
label define citylbl 6220 "San Angelo, TX", add
label define citylbl 6230 "San Antonio, TX", add
label define citylbl 6231 "San Benito, TX", add
label define citylbl 6250 "San Bernadino, CA", add
label define citylbl 6260 "San Buenaventura (Ventura), CA", add
label define citylbl 6270 "San Diego, CA", add
label define citylbl 6280 "Sandusky, OH", add
label define citylbl 6281 "Sanford, FL", add
label define citylbl 6282 "Sanford, ME", add
label define citylbl 6290 "San Francisco, CA", add
label define citylbl 6300 "San Juan, PR", add
label define citylbl 6310 "San Jose, CA", add
label define citylbl 6311 "San Leandro, CA", add
label define citylbl 6312 "San Mateo, CA", add
label define citylbl 6320 "Santa Barbara, CA", add
label define citylbl 6321 "Santa Cruz, CA", add
label define citylbl 6322 "Santa Fe, NM", add
label define citylbl 6330 "Santa Ana, CA", add
label define citylbl 6340 "Santa Clarita, CA", add
label define citylbl 6350 "Santa Rosa, CA", add
label define citylbl 6351 "Sapulpa, OK", add
label define citylbl 6352 "Saratoga Springs, NY", add
label define citylbl 6353 "Saugus, MA", add
label define citylbl 6354 "Sault Ste. Marie, MI", add
label define citylbl 6360 "Santa Monica, CA", add
label define citylbl 6370 "Savannah, GA", add
label define citylbl 6390 "Schenectedy, NY", add
label define citylbl 6410 "Scranton, PA", add
label define citylbl 6430 "Seattle, WA", add
label define citylbl 6431 "Sedalia, MO", add
label define citylbl 6432 "Selma, AL", add
label define citylbl 6433 "Seminole, OK", add
label define citylbl 6434 "Shaker Heights, OH", add
label define citylbl 6435 "Shamokin, PA", add
label define citylbl 6437 "Sharpsville, PA", add
label define citylbl 6438 "Shawnee, OK", add
label define citylbl 6440 "Sharon, PA", add
label define citylbl 6450 "Sheboygan, WI", add
label define citylbl 6451 "Shelby, NC", add
label define citylbl 6452 "Shelbyville, IN", add
label define citylbl 6453 "Shelton, CT", add
label define citylbl 6470 "Shenandoah Borough, PA", add
label define citylbl 6471 "Sherman, TX", add
label define citylbl 6472 "Shorewood, WI", add
label define citylbl 6490 "Shreveport, LA", add
label define citylbl 6500 "Simi Valley, CA", add
label define citylbl 6510 "Sioux City, IA", add
label define citylbl 6530 "Sioux Falls, SD", add
label define citylbl 6550 "Smithfield, RI (1850)", add
label define citylbl 6570 "Somerville, MA", add
label define citylbl 6590 "South Bend, IN", add
label define citylbl 6591 "South Bethlehem, PA", add
label define citylbl 6592 "South Boise, ID", add
label define citylbl 6593 "South Gate, CA", add
label define citylbl 6594 "South Milwaukee, WI", add
label define citylbl 6595 "South Norwalk, CT", add
label define citylbl 6610 "South Omaha, NE", add
label define citylbl 6611 "South Orange, NJ", add
label define citylbl 6612 "South Pasadena, CA", add
label define citylbl 6613 "South Pittsburgh, PA", add
label define citylbl 6614 "South Portland, ME", add
label define citylbl 6615 "South River, NJ", add
label define citylbl 6616 "South St. Paul, MN", add
label define citylbl 6617 "Southbridge, MA", add
label define citylbl 6620 "Spartanburg, SC", add
label define citylbl 6630 "Spokane, WA", add
label define citylbl 6650 "Springfield, IL", add
label define citylbl 6670 "Springfield, MA", add
label define citylbl 6690 "Springfield, MO", add
label define citylbl 6691 "St. Augustine, FL", add
label define citylbl 6692 "St. Charles, MO", add
label define citylbl 6693 "St. Cloud, MN", add
label define citylbl 6710 "Springfield, OH", add
label define citylbl 6730 "Stamford, CT", add
label define citylbl 6731 "Statesville, NC", add
label define citylbl 6732 "Staunton, VA", add
label define citylbl 6733 "Steelton, PA", add
label define citylbl 6734 "Sterling, IL", add
label define citylbl 6750 "Sterling Heights, MI", add
label define citylbl 6770 "Steubenville, OH", add
label define citylbl 6771 "Stevens Point, WI", add
label define citylbl 6772 "Stillwater, MN", add
label define citylbl 6790 "Stockton, CA", add
label define citylbl 6791 "Stoneham, MA", add
label define citylbl 6792 "Stonington, CT", add
label define citylbl 6793 "Stratford, CT", add
label define citylbl 6794 "Streator, IL", add
label define citylbl 6795 "Struthers, OH", add
label define citylbl 6796 "Suffolk, VA", add
label define citylbl 6797 "Summit, NJ", add
label define citylbl 6798 "Sumter, SC", add
label define citylbl 6799 "Sunbury, PA", add
label define citylbl 6810 "Sunnyvale, CA", add
label define citylbl 6830 "Superior, WI", add
label define citylbl 6831 "Swampscott, MA", add
label define citylbl 6832 "Sweetwater, TX", add
label define citylbl 6833 "Swissvale, PA", add
label define citylbl 6850 "Syracuse, NY", add
label define citylbl 6870 "Tacoma, WA", add
label define citylbl 6871 "Tallahassee, FL", add
label define citylbl 6872 "Tamaqua, PA", add
label define citylbl 6890 "Tampa, FL", add
label define citylbl 6910 "Taunton, MA", add
label define citylbl 6911 "Taylor, PA", add
label define citylbl 6912 "Temple, TX", add
label define citylbl 6930 "Tempe, AZ", add
label define citylbl 6950 "Terre Haute, IN", add
label define citylbl 6951 "Texarkana, TX", add
label define citylbl 6952 "Thomasville, GA", add
label define citylbl 6953 "Thomasville, NC", add
label define citylbl 6954 "Tiffin, OH", add
label define citylbl 6960 "Thousand Oaks, CA", add
label define citylbl 6970 "Toledo, OH", add
label define citylbl 6971 "Tonawanda, NY", add
label define citylbl 6990 "Topeka, KS", add
label define citylbl 6991 "Torrington, CT", add
label define citylbl 6992 "Traverse City, MI", add
label define citylbl 7000 "Torrance, CA", add
label define citylbl 7010 "Trenton, NJ", add
label define citylbl 7011 "Trinidad, CO", add
label define citylbl 7030 "Troy, NY", add
label define citylbl 7050 "Tucson, AZ", add
label define citylbl 7070 "Tulsa, OK", add
label define citylbl 7071 "Turtle Creek, PA", add
label define citylbl 7072 "Tuscaloosa, AL", add
label define citylbl 7073 "Two Rivers, WI", add
label define citylbl 7074 "Tyler, TX", add
label define citylbl 7080 "Union City, NJ", add
label define citylbl 7081 "Uniontown, PA", add
label define citylbl 7082 "University City, MO", add
label define citylbl 7083 "Urbana, IL", add
label define citylbl 7090 "Utica, NY", add
label define citylbl 7091 "Valdosta, GA", add
label define citylbl 7092 "Vallejo, CA", add
label define citylbl 7093 "Valley Stream, NY", add
label define citylbl 7100 "Vancouver, WA", add
label define citylbl 7110 "Vallejo, CA", add
label define citylbl 7111 "Vandergrift, PA", add
label define citylbl 7112 "Venice, CA", add
label define citylbl 7120 "Vicksburg, MS", add
label define citylbl 7121 "Vincennes, IN", add
label define citylbl 7122 "Virginia, MN", add
label define citylbl 7123 "Virginia City, NV", add
label define citylbl 7130 "Virginia Beach, VA", add
label define citylbl 7140 "University City, MO", add
label define citylbl 7150 "Waco, TX", add
label define citylbl 7151 "Wakefield, MA", add
label define citylbl 7152 "Walla Walla, WA", add
label define citylbl 7153 "Wallingford, CT", add
label define citylbl 7170 "Waltham, MA", add
label define citylbl 7180 "Warren, MI", add
label define citylbl 7190 "Warren, OH", add
label define citylbl 7191 "Warren, PA", add
label define citylbl 7210 "Warwick Town, RI", add
label define citylbl 7230 "Washington, DC", add
label define citylbl 7231 "Georgetown, DC", add
label define citylbl 7240 "Waukegan, IL", add
label define citylbl 7241 "Washington, PA", add
label define citylbl 7242 "Washington, VA", add
label define citylbl 7250 "Waterbury, CT", add
label define citylbl 7270 "Waterloo, IA", add
label define citylbl 7290 "Waterloo, NY", add
label define citylbl 7310 "Watertown, NY", add
label define citylbl 7311 "Watertown, WI", add
label define citylbl 7312 "Watertown, SD", add
label define citylbl 7313 "Watertown, MA", add
label define citylbl 7314 "Waterville, ME", add
label define citylbl 7315 "Watervliet, NY", add
label define citylbl 7316 "Waukegan, IL", add
label define citylbl 7317 "Waukesha, WI", add
label define citylbl 7318 "Wausau, WI", add
label define citylbl 7319 "Wauwatosa, WI", add
label define citylbl 7320 "West Covina, CA", add
label define citylbl 7321 "Waycross, GA", add
label define citylbl 7322 "Waynesboro, PA", add
label define citylbl 7323 "Webb City, MO", add
label define citylbl 7324 "Webster Groves, MO", add
label define citylbl 7325 "Webster, MA", add
label define citylbl 7326 "Wellesley, MA", add
label define citylbl 7327 "Wenatchee, WA", add
label define citylbl 7329 "West Bay City, MI", add
label define citylbl 7330 "West Hoboken, NJ", add
label define citylbl 7331 "West Bethlehem, PA", add
label define citylbl 7332 "West Chester, PA", add
label define citylbl 7333 "West Frankfort, IL", add
label define citylbl 7334 "West Hartford, CT", add
label define citylbl 7335 "West Haven, CT", add
label define citylbl 7340 "West Allis, WI", add
label define citylbl 7350 "West New York, NJ", add
label define citylbl 7351 "West Orange, NJ", add
label define citylbl 7352 "West Palm Beach, FL", add
label define citylbl 7353 "West Springfield, MA", add
label define citylbl 7370 "West Troy, NY", add
label define citylbl 7371 "West Warwick, RI", add
label define citylbl 7372 "Westbrook, ME", add
label define citylbl 7373 "Westerly, RI", add
label define citylbl 7374 "Westfield, MA", add
label define citylbl 7375 "Westfield, NJ", add
label define citylbl 7376 "Wewoka, OK", add
label define citylbl 7377 "Weymouth, MA", add
label define citylbl 7390 "Wheeling, WV", add
label define citylbl 7400 "White Plains, NY", add
label define citylbl 7401 "Whiting, IN", add
label define citylbl 7402 "Whittier, CA", add
label define citylbl 7410 "Wichita, KS", add
label define citylbl 7430 "Wichita Falls, TX", add
label define citylbl 7450 "Wilkes-Barre, PA", add
label define citylbl 7451 "Wilkinsburg, PA", add
label define citylbl 7460 "Wilkinsburg, PA", add
label define citylbl 7470 "Williamsport, PA", add
label define citylbl 7471 "Willimantic, CT", add
label define citylbl 7472 "Wilmette, IL", add
label define citylbl 7490 "Wilmington, DE", add
label define citylbl 7510 "Wilmington, NC", add
label define citylbl 7511 "Wilson, NC", add
label define citylbl 7512 "Winchester, VA", add
label define citylbl 7513 "Winchester, MA", add
label define citylbl 7514 "Windham, CT", add
label define citylbl 7515 "Winnetka, IL", add
label define citylbl 7516 "Winona, MN", add
label define citylbl 7530 "Winston-Salem, NC", add
label define citylbl 7531 "Winthrop, MA", add
label define citylbl 7532 "Woburn, MA", add
label define citylbl 7533 "Woodlawn, PA", add
label define citylbl 7534 "Woodmont, CT", add
label define citylbl 7550 "Woonsocket, RI", add
label define citylbl 7551 "Wooster, OH", add
label define citylbl 7570 "Worcester, MA", add
label define citylbl 7571 "Wyandotte, MI", add
label define citylbl 7572 "Xenia, OH", add
label define citylbl 7573 "Yakima, WA", add
label define citylbl 7590 "Yonkers, NY", add
label define citylbl 7610 "York, PA", add
label define citylbl 7630 "Youngstown, OH", add
label define citylbl 7631 "Ypsilanti, MI", add
label define citylbl 7650 "Zanesville, OH", add
label values city citylbl

label values citypop citypoplbl

label values puma pumalbl

label values pumasupr pumasuprlbl

label define gqlbl 0 "Vacant unit", add
label define gqlbl 1 "Households under 1970 definition", add
label define gqlbl 2 "Additional households under 1990 definition", add
label define gqlbl 3 "Group quarters--Institutions", add
label define gqlbl 4 "Other group quarters", add
label define gqlbl 5 "Additional households under 2000 definition", add
label define gqlbl 6 "Fragment", add
label values gq gqlbl

label define farmlbl 0 "N/A"
label define farmlbl 1 "Non-Farm", add
label define farmlbl 2 "Farm", add
label values farm farmlbl

label define ownershdlbl 00 "N/A"
label define ownershdlbl 10 "Owned or being bought", add
label define ownershdlbl 11 "Check mark (owns?)", add
label define ownershdlbl 12 "Owned free and clear", add
label define ownershdlbl 13 "Owned with mortgage or loan", add
label define ownershdlbl 20 "Rented", add
label define ownershdlbl 21 "No cash rent", add
label define ownershdlbl 22 "With cash rent", add
label values ownershd ownershdlbl

label define mortgagelbl 0 "N/A"
label define mortgagelbl 1 "No, owned free and clear", add
label define mortgagelbl 2 "Check mark (owns?)", add
label define mortgagelbl 3 "Yes, mortgaged/ deed of trust or similar debt", add
label define mortgagelbl 4 "Yes, contract to purchase", add
label values mortgage mortgagelbl

label define mortgag2lbl 0 "N/A"
label define mortgag2lbl 1 "No", add
label define mortgag2lbl 2 "Yes", add
label define mortgag2lbl 3 "Yes, 2nd mortgage", add
label define mortgag2lbl 4 "Yes, home equity loan", add
label define mortgag2lbl 5 "Yes, 2nd mortgage and home equity loan", add
label values mortgag2 mortgag2lbl

label define commuselbl 0 "N/A"
label define commuselbl 1 "No commerical use", add
label define commuselbl 2 "Yes, used commercially", add
label define commuselbl 3 "Unknown, unit on 10+ acres", add
label define commuselbl 4 "Unknown, unit on 3+ cuerdas", add
label values commuse commuselbl

label define acreproplbl 0 "N/A", add
label define acreproplbl 1 "City or suburban lot", add
label define acreproplbl 2 "City or suburban lot or rural lot less than 1 acre", add
label define acreproplbl 3 "Non-city, non-surburban, under 10 acres", add
label define acreproplbl 4 "Non-city, non-surburban, less than 3 cuerdas (Puerto Rico)", add
label define acreproplbl 5 "Non-city, non-surburban, 3 or more cuerdas (Puerto Rico)", add
label define acreproplbl 6 "3 to 10 cuerdas (Puerto Rico)", add
label define acreproplbl 7 "Non-city, non-surburban, 1-9 acres", add
label define acreproplbl 8 "Non-city, non-surburban, 10+ acres (10+ cuerdas, Puerto Rico)", add
label values acreprop acreproplbl

label values mortamt1 mortamt1lbl

label values mortamt2 mortamt2lbl

label define taxincllbl 0 "N/A"
label define taxincllbl 1 "No", add
label define taxincllbl 2 "Yes", add
label values taxincl taxincllbl

label define insincllbl 0 "N/A"
label define insincllbl 1 "No", add
label define insincllbl 2 "Yes, payment includes insurance premiums", add
label values insincl insincllbl

label values proptxin proptxinlbl

label values propinsr propinsrlbl

label define proptx99lbl 00 "N/A (GQ/vacant/not owned  or being bought/not a one-family h"
label define proptx99lbl 01 "None", add
label define proptx99lbl 02 "$1-49  ($2-49 in 1990 PR Samples)", add
label define proptx99lbl 03 "$ 50 - 99", add
label define proptx99lbl 04 "$ 100 - 149", add
label define proptx99lbl 05 "$ 150 - 199", add
label define proptx99lbl 06 "$ 200 - 249", add
label define proptx99lbl 07 "$ 250 - 299", add
label define proptx99lbl 08 "$ 300 - 349", add
label define proptx99lbl 09 "$ 350 - 399", add
label define proptx99lbl 10 "$ 400 - 449", add
label define proptx99lbl 11 "$ 450 - 499", add
label define proptx99lbl 12 "$ 500 - 549", add
label define proptx99lbl 13 "$ 550 - 599", add
label define proptx99lbl 14 "$ 600 - 649", add
label define proptx99lbl 15 "$ 650 - 699", add
label define proptx99lbl 16 "$ 700 - 749", add
label define proptx99lbl 17 "$ 750 - 799", add
label define proptx99lbl 18 "$ 800 - 849", add
label define proptx99lbl 19 "$ 850 - 899", add
label define proptx99lbl 20 "$ 900 - 949", add
label define proptx99lbl 21 "$ 950 - 999", add
label define proptx99lbl 22 "$ 1,000 - 1,099", add
label define proptx99lbl 23 "$ 1,100 - 1,199", add
label define proptx99lbl 24 "$ 1,200 - 1,299", add
label define proptx99lbl 25 "$ 1,300 - 1,399", add
label define proptx99lbl 26 "$ 1,400 - 1,499", add
label define proptx99lbl 27 "$ 1,500 - 1,599", add
label define proptx99lbl 28 "$ 1,600 - 1,699", add
label define proptx99lbl 29 "$ 1,700 - 1,799", add
label define proptx99lbl 30 "$ 1,800 - 1,899", add
label define proptx99lbl 31 "$ 1,900 - 1,999", add
label define proptx99lbl 32 "$ 2,000 - 2,099", add
label define proptx99lbl 33 "$2100-2199  ($2199+ 1990 PR Samples)", add
label define proptx99lbl 34 "$ 2,200 - 2,299", add
label define proptx99lbl 35 "$ 2,300 - 2,399", add
label define proptx99lbl 36 "$ 2,400 - 2,499", add
label define proptx99lbl 37 "$ 2,500 - 2,599", add
label define proptx99lbl 38 "$ 2,600 - 2,699", add
label define proptx99lbl 39 "$ 2,700 - 2,799", add
label define proptx99lbl 40 "$ 2,800 - 2,899", add
label define proptx99lbl 41 "$ 2,900 - 2,999", add
label define proptx99lbl 42 "$ 3,000 - 3,099", add
label define proptx99lbl 43 "$ 3,100 - 3,199", add
label define proptx99lbl 44 "$ 3,200 - 3,299", add
label define proptx99lbl 45 "$ 3,300 - 3,399", add
label define proptx99lbl 46 "$ 3,400 - 3,499", add
label define proptx99lbl 47 "$ 3,500 - 3,599", add
label define proptx99lbl 48 "$ 3,600 - 3,699", add
label define proptx99lbl 49 "$ 3,700 - 3,799", add
label define proptx99lbl 50 "$ 3,800 - 3,899", add
label define proptx99lbl 51 "$ 3,900 - 3,999", add
label define proptx99lbl 52 "$ 4,000 - 4,099", add
label define proptx99lbl 53 "$ 4,100 - 4,199", add
label define proptx99lbl 54 "$ 4,200 - 4,299", add
label define proptx99lbl 55 "$ 4,300 - 4,399", add
label define proptx99lbl 56 "$ 4,400 - 4,499", add
label define proptx99lbl 57 "$4500 (1990 U.S. Samples)", add
label define proptx99lbl 58 "$4500-4599 ($4501+ 1990 U.S. Samples)", add
label define proptx99lbl 59 "$4600 - 4699", add
label define proptx99lbl 60 "$4700 - 4799", add
label define proptx99lbl 61 "$4800 - 4899", add
label define proptx99lbl 62 "$4900 - 4999", add
label define proptx99lbl 63 "$5000 - 5499", add
label define proptx99lbl 64 "$5500 - 5999", add
label define proptx99lbl 65 "$6000 - 6999", add
label define proptx99lbl 66 "$7000 - 7999", add
label define proptx99lbl 67 "$8000-8999 ($8000-9099 in 2000)", add
label define proptx99lbl 68 "$9000-9999 ($9100+ in 2000)", add
label define proptx99lbl 69 "$10,000+", add
label values proptx99 proptx99lbl

label values rent rentlbl

label values rentgrs rentgrslbl

label define rentmeallbl 0 "N/A"
label define rentmeallbl 1 "No, meals not included", add
label define rentmeallbl 2 "Yes", add
label values rentmeal rentmeallbl

label define condolbl 0 "N/A"
label define condolbl 1 "Not a condominium unit", add
label define condolbl 2 "Condominium unit", add
label values condo condolbl

label values condofee condofeelbl

label values moblhome moblhomelbl

label values moblhom2 moblhom2lbl

label values costfuel costfuellbl

label values ftotinc ftotinclbl

label values hhincome hhincomelbl

label values valueh valuehlbl

label define lingisollbl 0 "N/A (group quarters/vacant)"
label define lingisollbl 1 "Not linguistically isolated", add
label define lingisollbl 2 "Linguistically isolated", add
label values lingisol lingisollbl

label define vacancylbl 0 "N/A"
label define vacancylbl 1 "For rent or sale", add
label define vacancylbl 2 "For sale only", add
label define vacancylbl 3 "Rented or sold but not (yet) occupied", add
label define vacancylbl 4 "For seasonal, recreational or other occasional use", add
label define vacancylbl 5 "For occasional use", add
label define vacancylbl 6 "For seasonal use", add
label define vacancylbl 7 "For migrant farm workers", add
label define vacancylbl 8 "For seasonal use or migratory", add
label define vacancylbl 9 "Other vacant", add
label values vacancy vacancylbl

label define roomslbl 0 "N/A"
label define roomslbl 1 "1 room", add
label define roomslbl 2 "2", add
label define roomslbl 3 "3", add
label define roomslbl 4 "4", add
label define roomslbl 5 "5", add
label define roomslbl 6 "6", add
label define roomslbl 7 "7", add
label define roomslbl 8 "8", add
label define roomslbl 9 "9+", add
label values rooms roomslbl

label define builtyrlbl 0 "N/A"
label define builtyrlbl 1 "0-1 year old", add
label define builtyrlbl 2 "2-5 years", add
label define builtyrlbl 3 "6-10 years", add
label define builtyrlbl 4 "11-20 years", add
label define builtyrlbl 5 "21-30 years", add
label define builtyrlbl 6 "31-40 years (31+ in 1960, 1970)", add
label define builtyrlbl 7 "41-50 years (41+ in 1980)", add
label define builtyrlbl 8 "51-60 years (51+ in 1990)", add
label define builtyrlbl 9 "61+ years", add
label values builtyr builtyrlbl

label define unitsstrlbl 00 "N/A"
label define unitsstrlbl 01 "Mobile home or trailer", add
label define unitsstrlbl 02 "Boat, tent, van, other", add
label define unitsstrlbl 03 "1-family house, detached", add
label define unitsstrlbl 04 "1-family house, attached", add
label define unitsstrlbl 05 "2-family building", add
label define unitsstrlbl 06 "3-4 family building", add
label define unitsstrlbl 07 "5-9 family building", add
label define unitsstrlbl 08 "10-19 family building", add
label define unitsstrlbl 09 "20-49 family building", add
label define unitsstrlbl 10 "50+ family building", add
label values unitsstr unitsstrlbl

label define bedroomslbl 0 "N/A"
label define bedroomslbl 1 "No bedrooms", add
label define bedroomslbl 2 "1", add
label define bedroomslbl 3 "2", add
label define bedroomslbl 4 "3", add
label define bedroomslbl 5 "4 (4+ in 1960)", add
label define bedroomslbl 6 "5+ (1970-2000, ACS, PRCS)", add
label values bedrooms bedroomslbl

label define vehicleslbl 0 "N/A"
label define vehicleslbl 1 "1 available", add
label define vehicleslbl 2 "2", add
label define vehicleslbl 3 "3", add
label define vehicleslbl 4 "4", add
label define vehicleslbl 5 "5", add
label define vehicleslbl 6 "6 (6+, 2000, ACS and PRCS)", add
label define vehicleslbl 7 "7+", add
label define vehicleslbl 9 "No vehicles available", add
label values vehicles vehicleslbl

label values pernum pernumlbl

label values perwt perwtlbl

label define agelbl 000 "Less than 1 year old"
label define agelbl 001 "1", add
label define agelbl 002 "2", add
label define agelbl 003 "3", add
label define agelbl 004 "4", add
label define agelbl 005 "5", add
label define agelbl 006 "6", add
label define agelbl 007 "7", add
label define agelbl 008 "8", add
label define agelbl 009 "9", add
label define agelbl 010 "10", add
label define agelbl 011 "11", add
label define agelbl 012 "12", add
label define agelbl 013 "13", add
label define agelbl 014 "14", add
label define agelbl 015 "15", add
label define agelbl 016 "16", add
label define agelbl 017 "17", add
label define agelbl 018 "18", add
label define agelbl 019 "19", add
label define agelbl 020 "20", add
label define agelbl 021 "21", add
label define agelbl 022 "22", add
label define agelbl 023 "23", add
label define agelbl 024 "24", add
label define agelbl 025 "25", add
label define agelbl 026 "26", add
label define agelbl 027 "27", add
label define agelbl 028 "28", add
label define agelbl 029 "29", add
label define agelbl 030 "30", add
label define agelbl 031 "31", add
label define agelbl 032 "32", add
label define agelbl 033 "33", add
label define agelbl 034 "34", add
label define agelbl 035 "35", add
label define agelbl 036 "36", add
label define agelbl 037 "37", add
label define agelbl 038 "38", add
label define agelbl 039 "39", add
label define agelbl 040 "40", add
label define agelbl 041 "41", add
label define agelbl 042 "42", add
label define agelbl 043 "43", add
label define agelbl 044 "44", add
label define agelbl 045 "45", add
label define agelbl 046 "46", add
label define agelbl 047 "47", add
label define agelbl 048 "48", add
label define agelbl 049 "49", add
label define agelbl 050 "50", add
label define agelbl 051 "51", add
label define agelbl 052 "52", add
label define agelbl 053 "53", add
label define agelbl 054 "54", add
label define agelbl 055 "55", add
label define agelbl 056 "56", add
label define agelbl 057 "57", add
label define agelbl 058 "58", add
label define agelbl 059 "59", add
label define agelbl 060 "60", add
label define agelbl 061 "61", add
label define agelbl 062 "62", add
label define agelbl 063 "63", add
label define agelbl 064 "64", add
label define agelbl 065 "65", add
label define agelbl 066 "66", add
label define agelbl 067 "67", add
label define agelbl 068 "68", add
label define agelbl 069 "69", add
label define agelbl 070 "70", add
label define agelbl 071 "71", add
label define agelbl 072 "72", add
label define agelbl 073 "73", add
label define agelbl 074 "74", add
label define agelbl 075 "75", add
label define agelbl 076 "76", add
label define agelbl 077 "77", add
label define agelbl 078 "78", add
label define agelbl 079 "79", add
label define agelbl 080 "80", add
label define agelbl 081 "81", add
label define agelbl 082 "82", add
label define agelbl 083 "83", add
label define agelbl 084 "84", add
label define agelbl 085 "85", add
label define agelbl 086 "86", add
label define agelbl 087 "87", add
label define agelbl 088 "88", add
label define agelbl 089 "89", add
label define agelbl 090 "90 (90+ in 1980 and 1990)", add
label define agelbl 091 "91", add
label define agelbl 092 "92", add
label define agelbl 093 "93", add
label define agelbl 094 "94", add
label define agelbl 095 "95", add
label define agelbl 096 "96", add
label define agelbl 097 "97", add
label define agelbl 098 "98", add
label define agelbl 099 "99", add
label define agelbl 100 "100 (100+ in 1970)", add
label define agelbl 101 "101", add
label define agelbl 102 "102", add
label define agelbl 103 "103", add
label define agelbl 104 "104", add
label define agelbl 105 "105", add
label define agelbl 106 "106", add
label define agelbl 107 "107", add
label define agelbl 108 "108", add
label define agelbl 109 "109", add
label define agelbl 110 "110", add
label define agelbl 111 "111", add
label define agelbl 112 "112", add
label define agelbl 113 "113", add
label define agelbl 114 "114", add
label define agelbl 115 "115 (115+ in the 1990 internal data)", add
label define agelbl 116 "116", add
label define agelbl 117 "117", add
label define agelbl 118 "118", add
label define agelbl 119 "119", add
label define agelbl 120 "120", add
label define agelbl 121 "121", add
label define agelbl 122 "122", add
label define agelbl 123 "123", add
label define agelbl 124 "124", add
label define agelbl 125 "125", add
label define agelbl 126 "126", add
label values age agelbl

label define sexlbl 1 "Male"
label define sexlbl 2 "Female", add
label values sex sexlbl

label define racelbl 1 "White"
label define racelbl 2 "Black/Negro", add
label define racelbl 3 "American Indian or Alaska Native", add
label define racelbl 4 "Chinese", add
label define racelbl 5 "Japanese", add
label define racelbl 6 "Other Asian or Pacific Islander", add
label define racelbl 7 "Other race, nec", add
label define racelbl 8 "Two major races", add
label define racelbl 9 "Three or more major races", add
label values race racelbl

label define citizenlbl 0 "N/A"
label define citizenlbl 1 "Born abroad of American parents", add
label define citizenlbl 2 "Naturalized citizen", add
label define citizenlbl 3 "Not a citizen", add
label define citizenlbl 4 "Not a citizen, but has received first papers", add
label define citizenlbl 5 "Foreign born, citizenship status not reported", add
label values citizen citizenlbl

label define speakenglbl 0 "N/A (Blank)"
label define speakenglbl 1 "Does not speak English", add
label define speakenglbl 2 "Yes, speaks English...", add
label define speakenglbl 3 "Yes, speaks only English", add
label define speakenglbl 4 "Yes, speaks very well", add
label define speakenglbl 5 "Yes, speaks well", add
label define speakenglbl 6 "Yes, but not well", add
label values speakeng speakenglbl

label define hispandlbl 000 "Not Hispanic", add
label define hispandlbl 100 "Mexican", add
label define hispandlbl 102 "Mexican American", add
label define hispandlbl 103 "Mexicano/Mexicana", add
label define hispandlbl 104 "Chicano/Chicana", add
label define hispandlbl 105 "La Raza", add
label define hispandlbl 106 "Mexican American Indian", add
label define hispandlbl 107 "Mexico", add
label define hispandlbl 200 "Puerto Rican", add
label define hispandlbl 300 "Cuban", add
label define hispandlbl 401 "Central American Indian", add
label define hispandlbl 402 "Canal Zone", add
label define hispandlbl 411 "Costa Rican", add
label define hispandlbl 412 "Guatemalan", add
label define hispandlbl 413 "Honduran", add
label define hispandlbl 414 "Nicaraguan", add
label define hispandlbl 415 "Panamanian", add
label define hispandlbl 416 "Salvadoran", add
label define hispandlbl 417 "Central American, n.e.c.", add
label define hispandlbl 420 "Argentinean", add
label define hispandlbl 421 "Bolivian", add
label define hispandlbl 422 "Chilean", add
label define hispandlbl 423 "Colombian", add
label define hispandlbl 424 "Ecuadorian", add
label define hispandlbl 425 "Paraguayan", add
label define hispandlbl 426 "Peruvian", add
label define hispandlbl 427 "Uruguayan", add
label define hispandlbl 428 "Venezuelan", add
label define hispandlbl 429 "South American Indian", add
label define hispandlbl 430 "Criollo", add
label define hispandlbl 431 "South American, n.e.c.", add
label define hispandlbl 450 "Spaniard", add
label define hispandlbl 451 "Andalusian", add
label define hispandlbl 452 "Asturian", add
label define hispandlbl 453 "Castillian", add
label define hispandlbl 454 "Catalonian", add
label define hispandlbl 455 "Balearic Islander", add
label define hispandlbl 456 "Gallego", add
label define hispandlbl 457 "Valencian", add
label define hispandlbl 458 "Canarian", add
label define hispandlbl 459 "Spanish Basque", add
label define hispandlbl 460 "Dominican", add
label define hispandlbl 465 "Latin American", add
label define hispandlbl 470 "Hispanic", add
label define hispandlbl 480 "Spanish", add
label define hispandlbl 490 "Californio", add
label define hispandlbl 491 "Tejano", add
label define hispandlbl 492 "Nuevo Mexicano", add
label define hispandlbl 493 "Spanish American", add
label define hispandlbl 494 "Spanish American Indian", add
label define hispandlbl 495 "Meso American Indian", add
label define hispandlbl 496 "Mestizo", add
label define hispandlbl 498 "Other, n.s.", add
label define hispandlbl 499 "Other, n.e.c.", add
label define hispandlbl 900 "Not Reported", add
label values hispand hispandlbl

label define educreclbl 0 "N/A  or No schooling"
label define educreclbl 1 "None or preschool", add
label define educreclbl 2 "Grade 1, 2, 3, or 4", add
label define educreclbl 3 "Grade 5, 6, 7, or 8", add
label define educreclbl 4 "Grade 9", add
label define educreclbl 5 "Grade 10", add
label define educreclbl 6 "Grade 11", add
label define educreclbl 7 "Grade 12", add
label define educreclbl 8 "1 to 3 years of college", add
label define educreclbl 9 "4+ years of college", add
label values educrec educreclbl

label define empstatdlbl 00 "N/A", add
label define empstatdlbl 10 "At work", add
label define empstatdlbl 11 "At work, public emerg", add
label define empstatdlbl 12 "Has job, not working", add
label define empstatdlbl 13 "Armed forces", add
label define empstatdlbl 14 "Armed forces--at work", add
label define empstatdlbl 15 "Armed forces--not at work but with job", add
label define empstatdlbl 20 "Unemployed", add
label define empstatdlbl 21 "Unemp, exper worker", add
label define empstatdlbl 22 "Unemp, new worker", add
label define empstatdlbl 30 "Not in Labor Force", add
label define empstatdlbl 31 "NILF, housework", add
label define empstatdlbl 32 "NILF, unable to work", add
label define empstatdlbl 33 "NILF, school", add
label define empstatdlbl 34 "NILF, other", add
label values empstatd empstatdlbl

label values occ occlbl

label values ind indlbl

label define ind1950lbl 000 "N/A or none reported", add
label define ind1950lbl 105 "Agriculture", add
label define ind1950lbl 116 "Forestry", add
label define ind1950lbl 126 "Fisheries", add
label define ind1950lbl 206 "Metal mining", add
label define ind1950lbl 216 "Coal mining", add
label define ind1950lbl 226 "Crude petroleum and natural gas extraction", add
label define ind1950lbl 236 "Nonmettalic  mining and quarrying, except fuel", add
label define ind1950lbl 239 "Mining, not specified", add
label define ind1950lbl 246 "Construction", add
label define ind1950lbl 306 "Logging", add
label define ind1950lbl 307 "Sawmills, planing mills, and mill work", add
label define ind1950lbl 308 "Misc wood products", add
label define ind1950lbl 309 "Furniture and fixtures", add
label define ind1950lbl 316 "Glass and glass products", add
label define ind1950lbl 317 "Cement, concrete, gypsum and plaster products", add
label define ind1950lbl 318 "Structural clay products", add
label define ind1950lbl 319 "Pottery and related prods", add
label define ind1950lbl 326 "Misc nonmetallic mineral and stone products", add
label define ind1950lbl 336 "Blast furnaces, steel works, and rolling mills", add
label define ind1950lbl 337 "Other primary iron and steel industries", add
label define ind1950lbl 338 "Primary nonferrous industries", add
label define ind1950lbl 346 "Fabricated steel products", add
label define ind1950lbl 347 "Fabricated nonferrous metal products", add
label define ind1950lbl 348 "Not specified metal industries", add
label define ind1950lbl 356 "Agricultural machinery and tractors", add
label define ind1950lbl 357 "Office and store machines", add
label define ind1950lbl 358 "Misc machinery", add
label define ind1950lbl 367 "Electrical machinery, equipment and supplies", add
label define ind1950lbl 376 "Motor vehicles and motor vehicle equipment", add
label define ind1950lbl 377 "Aircraft and parts", add
label define ind1950lbl 378 "Ship and boat building and repairing", add
label define ind1950lbl 379 "Railroad and misc transportation equipment", add
label define ind1950lbl 386 "Professional equipment", add
label define ind1950lbl 387 "Photographic equipment and supplies", add
label define ind1950lbl 388 "Watches, clocks, and clockwork-operated devices", add
label define ind1950lbl 399 "Misc manufacturing industries", add
label define ind1950lbl 406 "Meat products", add
label define ind1950lbl 407 "Dairy products", add
label define ind1950lbl 408 "Canning and preserving fruits, vegetables, and seafoods", add
label define ind1950lbl 409 "Grain-mill products", add
label define ind1950lbl 416 "Bakery products", add
label define ind1950lbl 417 "Confectionary and related products", add
label define ind1950lbl 418 "Beverage industries", add
label define ind1950lbl 419 "Misc food preparations and kindred products", add
label define ind1950lbl 426 "Not specified food industries", add
label define ind1950lbl 429 "Tobacco manufactures", add
label define ind1950lbl 436 "Knitting mills", add
label define ind1950lbl 437 "Dyeing and finishing textiles, except knit goods", add
label define ind1950lbl 438 "Carpets, rugs, and other floor coverings", add
label define ind1950lbl 439 "Yarn, thread, and fabric", add
label define ind1950lbl 446 "Misc textile mill products", add
label define ind1950lbl 448 "Apparel and accessories", add
label define ind1950lbl 449 "Misc fabricated textile products", add
label define ind1950lbl 456 "Pulp, paper, and paper-board mills", add
label define ind1950lbl 457 "Paperboard containers and boxes", add
label define ind1950lbl 458 "Misc paper and pulp products", add
label define ind1950lbl 459 "Printing, publishing, and allied industries", add
label define ind1950lbl 466 "Synthetic fibers", add
label define ind1950lbl 467 "Drugs and medicines", add
label define ind1950lbl 468 "Paints, varnishes, and related products", add
label define ind1950lbl 469 "Misc chemicals and allied products", add
label define ind1950lbl 476 "Petroleum refining", add
label define ind1950lbl 477 "Misc petroleum and coal products", add
label define ind1950lbl 478 "Rubber products", add
label define ind1950lbl 487 "Leather: tanned, curried, and finished", add
label define ind1950lbl 488 "Footwear, except rubber", add
label define ind1950lbl 489 "Leather products, except footwear", add
label define ind1950lbl 499 "Not specified manufacturing industries", add
label define ind1950lbl 506 "Railroads and railway", add
label define ind1950lbl 516 "Street railways and bus lines", add
label define ind1950lbl 526 "Trucking service", add
label define ind1950lbl 527 "Warehousing and storage", add
label define ind1950lbl 536 "Taxicab service", add
label define ind1950lbl 546 "Water transportation", add
label define ind1950lbl 556 "Air transportation", add
label define ind1950lbl 567 "Petroleum and gasoline pipe lines", add
label define ind1950lbl 568 "Services incidental to transportation", add
label define ind1950lbl 578 "Telephone", add
label define ind1950lbl 579 "Telegraph", add
label define ind1950lbl 586 "Electric light and power", add
label define ind1950lbl 587 "Gas and steam supply systems", add
label define ind1950lbl 588 "Electric-gas utilities", add
label define ind1950lbl 596 "Water supply", add
label define ind1950lbl 597 "Sanitary services", add
label define ind1950lbl 598 "Other and not specified utilities", add
label define ind1950lbl 606 "Motor vehicles and equipment", add
label define ind1950lbl 607 "Drugs, chemicals, and allied products", add
label define ind1950lbl 608 "Dry goods apparel", add
label define ind1950lbl 609 "Food and related products", add
label define ind1950lbl 616 "Electrical goods, hardware, and plumbing equipment", add
label define ind1950lbl 617 "Machinery, equipment, and supplies", add
label define ind1950lbl 618 "Petroleum products", add
label define ind1950lbl 619 "Farm prods--raw materials", add
label define ind1950lbl 626 "Misc wholesale trade", add
label define ind1950lbl 627 "Not specified wholesale trade", add
label define ind1950lbl 636 "Food stores, except dairy", add
label define ind1950lbl 637 "Dairy prods stores and milk retailing", add
label define ind1950lbl 646 "General merchandise", add
label define ind1950lbl 647 "Five and ten cent stores", add
label define ind1950lbl 656 "Apparel and accessories stores, except shoe", add
label define ind1950lbl 657 "Shoe stores", add
label define ind1950lbl 658 "Furniture and house furnishings stores", add
label define ind1950lbl 659 "Household appliance and radio stores", add
label define ind1950lbl 667 "Motor vehicles and accessories retailing", add
label define ind1950lbl 668 "Gasoline service stations", add
label define ind1950lbl 669 "Drug stores", add
label define ind1950lbl 679 "Eating and drinking  places", add
label define ind1950lbl 686 "Hardware and farm implement stores", add
label define ind1950lbl 687 "Lumber and building material retailing", add
label define ind1950lbl 688 "Liquor stores", add
label define ind1950lbl 689 "Retail florists", add
label define ind1950lbl 696 "Jewelry stores", add
label define ind1950lbl 697 "Fuel and ice retailing", add
label define ind1950lbl 698 "Misc retail stores", add
label define ind1950lbl 699 "Not specified retail trade", add
label define ind1950lbl 716 "Banking and credit", add
label define ind1950lbl 726 "Security and commodity brokerage and invest companies", add
label define ind1950lbl 736 "Insurance", add
label define ind1950lbl 746 "Real estate", add
label define ind1950lbl 756 "Real estate-insurance-law  offices", add
label define ind1950lbl 806 "Advertising", add
label define ind1950lbl 807 "Accounting, auditing, and bookkeeping services", add
label define ind1950lbl 808 "Misc business services", add
label define ind1950lbl 816 "Auto repair services and garages", add
label define ind1950lbl 817 "Misc repair services", add
label define ind1950lbl 826 "Private households", add
label define ind1950lbl 836 "Hotels and lodging places", add
label define ind1950lbl 846 "Laundering, cleaning, and dyeing", add
label define ind1950lbl 847 "Dressmaking shops", add
label define ind1950lbl 848 "Shoe repair shops", add
label define ind1950lbl 849 "Misc personal services", add
label define ind1950lbl 856 "Radio broadcasting and television", add
label define ind1950lbl 857 "Theaters and motion pictures", add
label define ind1950lbl 858 "Bowling alleys, and billiard and pool parlors", add
label define ind1950lbl 859 "Misc entertainment and recreation services", add
label define ind1950lbl 868 "Medical and other health services, except hospitals", add
label define ind1950lbl 869 "Hospitals", add
label define ind1950lbl 879 "Legal services", add
label define ind1950lbl 888 "Educational services", add
label define ind1950lbl 896 "Welfare and religious services", add
label define ind1950lbl 897 "Nonprofit membership organizs.", add
label define ind1950lbl 898 "Engineering and architectural services", add
label define ind1950lbl 899 "Misc professional and related", add
label define ind1950lbl 906 "Postal service", add
label define ind1950lbl 916 "Federal public administration", add
label define ind1950lbl 926 "State public administration", add
label define ind1950lbl 936 "Local public administration", add
label define ind1950lbl 946 "Public Administration, level not specified", add
label define ind1950lbl 976 "Common or General laborer", add
label define ind1950lbl 982 "Housework at home", add
label define ind1950lbl 983 "School response (students, etc.)", add
label define ind1950lbl 984 "Retired", add
label define ind1950lbl 987 "Institution response", add
label define ind1950lbl 991 "Lady/Man of leisure", add
label define ind1950lbl 995 "Non-industrial response", add
label define ind1950lbl 997 "Nonclassifiable", add
label define ind1950lbl 998 "Industry not reported", add
label values ind1950 ind1950lbl

label define ind1990lbl 000 "N/A (not applicable)", add
label define ind1990lbl 010 "Agricultural production, crops", add
label define ind1990lbl 011 "Agricultural production, livestock", add
label define ind1990lbl 012 "Veterinary services", add
label define ind1990lbl 020 "Landscape and horticultural services", add
label define ind1990lbl 030 "Agricultural services, n.e.c.", add
label define ind1990lbl 031 "Forestry", add
label define ind1990lbl 032 "Fishing, hunting, and trapping", add
label define ind1990lbl 040 "Metal mining", add
label define ind1990lbl 041 "Coal mining", add
label define ind1990lbl 042 "Oil and gas extraction", add
label define ind1990lbl 050 "Nonmetallic mining and quarrying, except fuels", add
label define ind1990lbl 060 "All construction", add
label define ind1990lbl 100 "Meat products", add
label define ind1990lbl 101 "Dairy products", add
label define ind1990lbl 102 "Canned, frozen, and preserved fruits and vegetables", add
label define ind1990lbl 110 "Grain mill products", add
label define ind1990lbl 111 "Bakery products", add
label define ind1990lbl 112 "Sugar and confectionery products", add
label define ind1990lbl 120 "Beverage industries", add
label define ind1990lbl 121 "Misc. food preparations and kindred products", add
label define ind1990lbl 122 "Food industries, n.s.", add
label define ind1990lbl 130 "Tobacco manufactures", add
label define ind1990lbl 132 "Knitting mills", add
label define ind1990lbl 140 "Dyeing and finishing textiles, except wool and knit goods", add
label define ind1990lbl 141 "Carpets and rugs", add
label define ind1990lbl 142 "Yarn, thread, and fabric mills", add
label define ind1990lbl 150 "Miscellaneous textile mill products", add
label define ind1990lbl 151 "Apparel and accessories, except knit", add
label define ind1990lbl 152 "Miscellaneous fabricated textile products", add
label define ind1990lbl 160 "Pulp, paper, and paperboard mills", add
label define ind1990lbl 161 "Miscellaneous paper and pulp products", add
label define ind1990lbl 162 "Paperboard containers and boxes", add
label define ind1990lbl 171 "Newspaper publishing and printing", add
label define ind1990lbl 172 "Printing, publishing, and allied industries, except newspapers", add
label define ind1990lbl 180 "Plastics, synthetics, and resins", add
label define ind1990lbl 181 "Drugs", add
label define ind1990lbl 182 "Soaps and cosmetics", add
label define ind1990lbl 190 "Paints, varnishes, and related products", add
label define ind1990lbl 191 "Agricultural chemicals", add
label define ind1990lbl 192 "Industrial and miscellaneous chemicals", add
label define ind1990lbl 200 "Petroleum refining", add
label define ind1990lbl 201 "Miscellaneous petroleum and coal products", add
label define ind1990lbl 210 "Tires and inner tubes", add
label define ind1990lbl 211 "Other rubber products, and plastics footwear and belting", add
label define ind1990lbl 212 "Miscellaneous plastics products", add
label define ind1990lbl 220 "Leather tanning and finishing", add
label define ind1990lbl 221 "Footwear, except rubber and plastic", add
label define ind1990lbl 222 "Leather products, except footwear", add
label define ind1990lbl 230 "Logging", add
label define ind1990lbl 231 "Sawmills, planing mills, and millwork", add
label define ind1990lbl 232 "Wood buildings and mobile homes", add
label define ind1990lbl 241 "Miscellaneous wood products", add
label define ind1990lbl 242 "Furniture and fixtures", add
label define ind1990lbl 250 "Glass and glass products", add
label define ind1990lbl 251 "Cement, concrete, gypsum, and plaster products", add
label define ind1990lbl 252 "Structural clay products", add
label define ind1990lbl 261 "Pottery and related products", add
label define ind1990lbl 262 "Misc. nonmetallic mineral and stone products", add
label define ind1990lbl 270 "Blast furnaces, steelworks, rolling and finishing mills", add
label define ind1990lbl 271 "Iron and steel foundries", add
label define ind1990lbl 272 "Primary aluminum industries", add
label define ind1990lbl 280 "Other primary metal industries", add
label define ind1990lbl 281 "Cutlery, handtools, and general hardware", add
label define ind1990lbl 282 "Fabricated structural metal products", add
label define ind1990lbl 290 "Screw machine products", add
label define ind1990lbl 291 "Metal forgings and stampings", add
label define ind1990lbl 292 "Ordnance", add
label define ind1990lbl 300 "Miscellaneous fabricated metal products", add
label define ind1990lbl 301 "Metal industries, n.s.", add
label define ind1990lbl 310 "Engines and turbines", add
label define ind1990lbl 311 "Farm machinery and equipment", add
label define ind1990lbl 312 "Construction and material handling machines", add
label define ind1990lbl 320 "Metalworking machinery", add
label define ind1990lbl 321 "Office and accounting machines", add
label define ind1990lbl 322 "Computers and related equipment", add
label define ind1990lbl 331 "Machinery, except electrical, n.e.c.", add
label define ind1990lbl 332 "Machinery, n.s.", add
label define ind1990lbl 340 "Household appliances", add
label define ind1990lbl 341 "Radio, TV, and communication equipment", add
label define ind1990lbl 342 "Electrical machinery, equipment, and supplies, n.e.c.", add
label define ind1990lbl 350 "Electrical machinery, equipment, and supplies, n.s.", add
label define ind1990lbl 351 "Motor vehicles and motor vehicle equipment", add
label define ind1990lbl 352 "Aircraft and parts", add
label define ind1990lbl 360 "Ship and boat building and repairing", add
label define ind1990lbl 361 "Railroad locomotives and equipment", add
label define ind1990lbl 362 "Guided missiles, space vehicles, and parts", add
label define ind1990lbl 370 "Cycles and miscellaneous transportation equipment", add
label define ind1990lbl 371 "Scientific and controlling instruments", add
label define ind1990lbl 372 "Medical, dental, and optical instruments and supplies", add
label define ind1990lbl 380 "Photographic equipment and supplies", add
label define ind1990lbl 381 "Watches, clocks, and clockwork operated devices", add
label define ind1990lbl 390 "Toys, amusement, and sporting goods", add
label define ind1990lbl 391 "Miscellaneous manufacturing industries", add
label define ind1990lbl 392 "Manufacturing industries, n.s.", add
label define ind1990lbl 400 "Railroads", add
label define ind1990lbl 401 "Bus service and urban transit", add
label define ind1990lbl 402 "Taxicab service", add
label define ind1990lbl 410 "Trucking service", add
label define ind1990lbl 411 "Warehousing and storage", add
label define ind1990lbl 412 "U.S. Postal Service", add
label define ind1990lbl 420 "Water transportation", add
label define ind1990lbl 421 "Air transportation", add
label define ind1990lbl 422 "Pipe lines, except natural gas", add
label define ind1990lbl 432 "Services incidental to transportation", add
label define ind1990lbl 440 "Radio and television broadcasting and cable", add
label define ind1990lbl 441 "Telephone communications", add
label define ind1990lbl 442 "Telegraph and miscellaneous communications services", add
label define ind1990lbl 450 "Electric light and power", add
label define ind1990lbl 451 "Gas and steam supply systems", add
label define ind1990lbl 452 "Electric and gas, and other combinations", add
label define ind1990lbl 470 "Water supply and irrigation", add
label define ind1990lbl 471 "Sanitary services", add
label define ind1990lbl 472 "Utilities, n.s.", add
label define ind1990lbl 500 "Motor vehicles and equipment", add
label define ind1990lbl 501 "Furniture and home furnishings", add
label define ind1990lbl 502 "Lumber and construction materials", add
label define ind1990lbl 510 "Professional and commercial equipment and supplies", add
label define ind1990lbl 511 "Metals and minerals, except petroleum", add
label define ind1990lbl 512 "Electrical goods", add
label define ind1990lbl 521 "Hardware, plumbing and heating supplies", add
label define ind1990lbl 530 "Machinery, equipment, and supplies", add
label define ind1990lbl 531 "Scrap and waste materials", add
label define ind1990lbl 532 "Miscellaneous wholesale, durable goods", add
label define ind1990lbl 540 "Paper and paper products", add
label define ind1990lbl 541 "Drugs, chemicals, and allied products", add
label define ind1990lbl 542 "Apparel, fabrics, and notions", add
label define ind1990lbl 550 "Groceries and related products", add
label define ind1990lbl 551 "Farm-product raw materials", add
label define ind1990lbl 552 "Petroleum products", add
label define ind1990lbl 560 "Alcoholic beverages", add
label define ind1990lbl 561 "Farm supplies", add
label define ind1990lbl 562 "Miscellaneous wholesale, nondurable goods", add
label define ind1990lbl 571 "Wholesale trade, n.s.", add
label define ind1990lbl 580 "Lumber and building material retailing", add
label define ind1990lbl 581 "Hardware stores", add
label define ind1990lbl 582 "Retail nurseries and garden stores", add
label define ind1990lbl 590 "Mobile home dealers", add
label define ind1990lbl 591 "Department stores", add
label define ind1990lbl 592 "Variety stores", add
label define ind1990lbl 600 "Miscellaneous general merchandise stores", add
label define ind1990lbl 601 "Grocery stores", add
label define ind1990lbl 602 "Dairy products stores", add
label define ind1990lbl 610 "Retail bakeries", add
label define ind1990lbl 611 "Food stores, n.e.c.", add
label define ind1990lbl 612 "Motor vehicle dealers", add
label define ind1990lbl 620 "Auto and home supply stores", add
label define ind1990lbl 621 "Gasoline service stations", add
label define ind1990lbl 622 "Miscellaneous vehicle dealers", add
label define ind1990lbl 623 "Apparel and accessory stores, except shoe", add
label define ind1990lbl 630 "Shoe stores", add
label define ind1990lbl 631 "Furniture and home furnishings stores", add
label define ind1990lbl 632 "Household appliance stores", add
label define ind1990lbl 633 "Radio, TV, and computer stores", add
label define ind1990lbl 640 "Music stores", add
label define ind1990lbl 641 "Eating and drinking places", add
label define ind1990lbl 642 "Drug stores", add
label define ind1990lbl 650 "Liquor stores", add
label define ind1990lbl 651 "Sporting goods, bicycles, and hobby stores", add
label define ind1990lbl 652 "Book and stationery stores", add
label define ind1990lbl 660 "Jewelry stores", add
label define ind1990lbl 661 "Gift, novelty, and souvenir shops", add
label define ind1990lbl 662 "Sewing, needlework, and piece goods stores", add
label define ind1990lbl 663 "Catalog and mail order houses", add
label define ind1990lbl 670 "Vending machine operators", add
label define ind1990lbl 671 "Direct selling establishments", add
label define ind1990lbl 672 "Fuel dealers", add
label define ind1990lbl 681 "Retail florists", add
label define ind1990lbl 682 "Miscellaneous retail stores", add
label define ind1990lbl 691 "Retail trade, n.s.", add
label define ind1990lbl 700 "Banking", add
label define ind1990lbl 701 "Savings institutions, including credit unions", add
label define ind1990lbl 702 "Credit agencies, n.e.c.", add
label define ind1990lbl 710 "Security, commodity brokerage, and investment companies", add
label define ind1990lbl 711 "Insurance", add
label define ind1990lbl 712 "Real estate, including real estate-insurance offices", add
label define ind1990lbl 721 "Advertising", add
label define ind1990lbl 722 "Services to dwellings and other buildings", add
label define ind1990lbl 731 "Personnel supply services", add
label define ind1990lbl 732 "Computer and data processing services", add
label define ind1990lbl 740 "Detective and protective services", add
label define ind1990lbl 741 "Business services, n.e.c.", add
label define ind1990lbl 742 "Automotive rental and leasing, without drivers", add
label define ind1990lbl 750 "Automobile parking and carwashes", add
label define ind1990lbl 751 "Automotive repair and related services", add
label define ind1990lbl 752 "Electrical repair shops", add
label define ind1990lbl 760 "Miscellaneous repair services", add
label define ind1990lbl 761 "Private households", add
label define ind1990lbl 762 "Hotels and motels", add
label define ind1990lbl 770 "Lodging places, except hotels and motels", add
label define ind1990lbl 771 "Laundry, cleaning, and garment services", add
label define ind1990lbl 772 "Beauty shops", add
label define ind1990lbl 780 "Barber shops", add
label define ind1990lbl 781 "Funeral service and crematories", add
label define ind1990lbl 782 "Shoe repair shops", add
label define ind1990lbl 790 "Dressmaking shops", add
label define ind1990lbl 791 "Miscellaneous personal services", add
label define ind1990lbl 800 "Theaters and motion pictures", add
label define ind1990lbl 801 "Video tape rental", add
label define ind1990lbl 802 "Bowling centers", add
label define ind1990lbl 810 "Miscellaneous entertainment and recreation services", add
label define ind1990lbl 812 "Offices and clinics of physicians", add
label define ind1990lbl 820 "Offices and clinics of dentists", add
label define ind1990lbl 821 "Offices and clinics of chiropractors", add
label define ind1990lbl 822 "Offices and clinics of optometrists", add
label define ind1990lbl 830 "Offices and clinics of health practitioners, n.e.c.", add
label define ind1990lbl 831 "Hospitals", add
label define ind1990lbl 832 "Nursing and personal care facilities", add
label define ind1990lbl 840 "Health services, n.e.c.", add
label define ind1990lbl 841 "Legal services", add
label define ind1990lbl 842 "Elementary and secondary schools", add
label define ind1990lbl 850 "Colleges and universities", add
label define ind1990lbl 851 "Vocational schools", add
label define ind1990lbl 852 "Libraries", add
label define ind1990lbl 860 "Educational services, n.e.c.", add
label define ind1990lbl 861 "Job training and vocational rehabilitation services", add
label define ind1990lbl 862 "Child day care services", add
label define ind1990lbl 863 "Family child care homes", add
label define ind1990lbl 870 "Residential care facilities, without nursing", add
label define ind1990lbl 871 "Social services, n.e.c.", add
label define ind1990lbl 872 "Museums, art galleries, and zoos", add
label define ind1990lbl 873 "Labor unions", add
label define ind1990lbl 880 "Religious organizations", add
label define ind1990lbl 881 "Membership organizations, n.e.c.", add
label define ind1990lbl 882 "Engineering, architectural, and surveying services", add
label define ind1990lbl 890 "Accounting, auditing, and bookkeeping services", add
label define ind1990lbl 891 "Research, development, and testing services", add
label define ind1990lbl 892 "Management and public relations services", add
label define ind1990lbl 893 "Miscellaneous professional and related services", add
label define ind1990lbl 900 "Executive and legislative offices", add
label define ind1990lbl 901 "General government, n.e.c.", add
label define ind1990lbl 910 "Justice, public order, and safety", add
label define ind1990lbl 921 "Public finance, taxation, and monetary policy", add
label define ind1990lbl 922 "Administration of human resources programs", add
label define ind1990lbl 930 "Administration of environmental quality and housing programs", add
label define ind1990lbl 931 "Administration of economic programs", add
label define ind1990lbl 932 "National security and international affairs", add
label define ind1990lbl 940 "Army", add
label define ind1990lbl 941 "Air Force", add
label define ind1990lbl 942 "Navy", add
label define ind1990lbl 950 "Marines", add
label define ind1990lbl 951 "Coast Guard", add
label define ind1990lbl 952 "Armed Forces, branch not specified", add
label define ind1990lbl 960 "Military Reserves or National Guard", add
label define ind1990lbl 992 "Last worked 1984 or earlier", add
label define ind1990lbl 999 "DID NOT RESPOND", add
label values ind1990 ind1990lbl

label values wkswork1 wkswork1lbl

label values uhrswork uhrsworklbl

label define workedyrlbl 0 "N/A"
label define workedyrlbl 1 "No", add
label define workedyrlbl 2 "Yes", add
label values workedyr workedyrlbl

label values inctot inctotlbl

label values incwage incwagelbl

label values incearn incearnlbl

label define migrate5lbl 0 "N/A", add
label define migrate5lbl 1 "Same house", add
label define migrate5lbl 2 "Moved, place not reported", add
label define migrate5lbl 3 "Moved within county (in Puerto Rico, within municipio)", add
label define migrate5lbl 4 "Moved within state, between counties (in Puerto Rico, between municipios)", add
label define migrate5lbl 5 "Moved between states (or between Puerto Rico and a state)", add
label define migrate5lbl 6 "Abroad", add
label define migrate5lbl 7 "Same state (migration status within state unknown)", add
label define migrate5lbl 9 "Unknown", add
label values migrate5 migrate5lbl

label define migplac5lbl 000 "N/A", add
label define migplac5lbl 001 "Alabama", add
label define migplac5lbl 002 "Alaska", add
label define migplac5lbl 004 "Arizona", add
label define migplac5lbl 005 "Arkansas", add
label define migplac5lbl 006 "California", add
label define migplac5lbl 008 "Colorado", add
label define migplac5lbl 009 "Connecticut", add
label define migplac5lbl 010 "Delaware", add
label define migplac5lbl 011 "District of Columbia", add
label define migplac5lbl 012 "Florida", add
label define migplac5lbl 013 "Georgia", add
label define migplac5lbl 015 "Hawaii", add
label define migplac5lbl 016 "Idaho", add
label define migplac5lbl 017 "Illinois", add
label define migplac5lbl 018 "Indiana", add
label define migplac5lbl 019 "Iowa", add
label define migplac5lbl 020 "Kansas", add
label define migplac5lbl 021 "Kentucky", add
label define migplac5lbl 022 "Louisiana", add
label define migplac5lbl 023 "Maine", add
label define migplac5lbl 024 "Maryland", add
label define migplac5lbl 025 "Massachusetts", add
label define migplac5lbl 026 "Michigan", add
label define migplac5lbl 027 "Minnesota", add
label define migplac5lbl 028 "Mississippi", add
label define migplac5lbl 029 "Missouri", add
label define migplac5lbl 030 "Montana", add
label define migplac5lbl 031 "Nebraska", add
label define migplac5lbl 032 "Nevada", add
label define migplac5lbl 033 "New Hampshire", add
label define migplac5lbl 034 "New Jersey", add
label define migplac5lbl 035 "New Mexico", add
label define migplac5lbl 036 "New York", add
label define migplac5lbl 037 "North Carolina", add
label define migplac5lbl 038 "North Dakota", add
label define migplac5lbl 039 "Ohio", add
label define migplac5lbl 040 "Oklahoma", add
label define migplac5lbl 041 "Oregon", add
label define migplac5lbl 042 "Pennsylvania", add
label define migplac5lbl 044 "Rhode Island", add
label define migplac5lbl 045 "South Carolina", add
label define migplac5lbl 046 "South Dakota", add
label define migplac5lbl 047 "Tennessee", add
label define migplac5lbl 048 "Texas", add
label define migplac5lbl 049 "Utah", add
label define migplac5lbl 050 "Vermont", add
label define migplac5lbl 051 "Virginia", add
label define migplac5lbl 053 "Washington", add
label define migplac5lbl 054 "West Virginia", add
label define migplac5lbl 055 "Wisconsin", add
label define migplac5lbl 056 "Wyoming", add
label define migplac5lbl 061 "Maine-New Hampshire-Vermont", add
label define migplac5lbl 062 "Massachussetts-Rhode Island", add
label define migplac5lbl 063 "Minnesota-Iowa-Missouri-Kansas-Nebraska-Dakotas", add
label define migplac5lbl 064 "Maryland-Delaware", add
label define migplac5lbl 065 "Montana-Idaho-Wyoming", add
label define migplac5lbl 066 "Utah-Nevada", add
label define migplac5lbl 067 "Arizona-New Mexico", add
label define migplac5lbl 068 "Alaska-Hawaii", add
label define migplac5lbl 099 "United States, not specified or state confidential", add
label define migplac5lbl 100 "Samoa", add
label define migplac5lbl 105 "Guam", add
label define migplac5lbl 110 "Puerto Rico", add
label define migplac5lbl 115 "Virgin Islands", add
label define migplac5lbl 119 "US outlying area (1980)", add
label define migplac5lbl 120 "Other US Possessions", add
label define migplac5lbl 150 "Canada", add
label define migplac5lbl 151 "English Canada", add
label define migplac5lbl 152 "French Canada", add
label define migplac5lbl 155 "St Pierre and Miquelon", add
label define migplac5lbl 160 "Atlantic Islands", add
label define migplac5lbl 199 "North America", add
label define migplac5lbl 200 "Mexico", add
label define migplac5lbl 211 "Belize/British Honduras", add
label define migplac5lbl 212 "Costa Rica", add
label define migplac5lbl 213 "El Salvador", add
label define migplac5lbl 214 "Guatemala", add
label define migplac5lbl 215 "Honduras", add
label define migplac5lbl 216 "Nicaragua", add
label define migplac5lbl 217 "Panama", add
label define migplac5lbl 218 "Canal Zone", add
label define migplac5lbl 219 "Central America, nec", add
label define migplac5lbl 250 "Cuba", add
label define migplac5lbl 260 "West Indies", add
label define migplac5lbl 261 "Dominican Republic", add
label define migplac5lbl 262 "Haita", add
label define migplac5lbl 263 "Jamaica", add
label define migplac5lbl 264 "British West Indies", add
label define migplac5lbl 266 "Trinidad and Tobago", add
label define migplac5lbl 267 "Other West Indies", add
label define migplac5lbl 305 "Argentina", add
label define migplac5lbl 310 "Bolivia", add
label define migplac5lbl 315 "Brazil", add
label define migplac5lbl 320 "Chile", add
label define migplac5lbl 325 "Colombia", add
label define migplac5lbl 330 "Ecuador", add
label define migplac5lbl 345 "Paraguay", add
label define migplac5lbl 350 "Peru", add
label define migplac5lbl 360 "Uruguay", add
label define migplac5lbl 365 "Venezuela", add
label define migplac5lbl 370 "North or Central America, n.s. (2000 5%)", add
label define migplac5lbl 390 "South America, nec", add
label define migplac5lbl 400 "Denmark", add
label define migplac5lbl 401 "Finland", add
label define migplac5lbl 402 "Iceland", add
label define migplac5lbl 404 "Norway", add
label define migplac5lbl 405 "Sweden", add
label define migplac5lbl 410 "England", add
label define migplac5lbl 411 "Scotland", add
label define migplac5lbl 412 "Wales", add
label define migplac5lbl 413 "United Kingdom", add
label define migplac5lbl 414 "Ireland", add
label define migplac5lbl 415 "Northern Ireland", add
label define migplac5lbl 420 "Belgium", add
label define migplac5lbl 421 "France", add
label define migplac5lbl 422 "Liechtenstein", add
label define migplac5lbl 423 "Luxembourg", add
label define migplac5lbl 424 "Monaco", add
label define migplac5lbl 425 "Netherlands", add
label define migplac5lbl 426 "Switzerland", add
label define migplac5lbl 430 "Albania", add
label define migplac5lbl 431 "Andorra", add
label define migplac5lbl 432 "Gibraltar", add
label define migplac5lbl 433 "Greece", add
label define migplac5lbl 434 "Dodecanese Islands", add
label define migplac5lbl 435 "Italy", add
label define migplac5lbl 436 "Portugal", add
label define migplac5lbl 437 "Azores", add
label define migplac5lbl 438 "Spain", add
label define migplac5lbl 439 "Vatican City", add
label define migplac5lbl 440 "Malta", add
label define migplac5lbl 450 "Austria", add
label define migplac5lbl 451 "Bulgaria", add
label define migplac5lbl 452 "Czechoslovakia", add
label define migplac5lbl 453 "Germany", add
label define migplac5lbl 454 "Hungary", add
label define migplac5lbl 455 "Poland", add
label define migplac5lbl 456 "Romania", add
label define migplac5lbl 457 "Yugoslavia", add
label define migplac5lbl 460 "Estonia", add
label define migplac5lbl 461 "Latvia", add
label define migplac5lbl 462 "Lithuania", add
label define migplac5lbl 465 "USSR", add
label define migplac5lbl 496 "Byelorussia", add
label define migplac5lbl 498 "Ukraine", add
label define migplac5lbl 499 "Europe, n.s.", add
label define migplac5lbl 500 "China", add
label define migplac5lbl 501 "Japan", add
label define migplac5lbl 502 "Korea", add
label define migplac5lbl 510 "Brunei", add
label define migplac5lbl 511 "Cambodia", add
label define migplac5lbl 512 "Indonesia", add
label define migplac5lbl 513 "Laos", add
label define migplac5lbl 514 "Malaysia", add
label define migplac5lbl 515 "Philippines", add
label define migplac5lbl 516 "Singapore", add
label define migplac5lbl 517 "Thailand", add
label define migplac5lbl 518 "Vietnam", add
label define migplac5lbl 520 "Afghanistan", add
label define migplac5lbl 521 "India", add
label define migplac5lbl 522 "Iran", add
label define migplac5lbl 523 "Maldives", add
label define migplac5lbl 524 "Nepal", add
label define migplac5lbl 525 "Pakistan", add
label define migplac5lbl 530 "Bahrain", add
label define migplac5lbl 531 "Cyprus", add
label define migplac5lbl 532 "Iraq", add
label define migplac5lbl 534 "Israel", add
label define migplac5lbl 535 "Jordan", add
label define migplac5lbl 536 "Kuwait", add
label define migplac5lbl 537 "Lebanon", add
label define migplac5lbl 538 "Oman", add
label define migplac5lbl 539 "Qatar", add
label define migplac5lbl 540 "Saudi Arabia", add
label define migplac5lbl 541 "Syria", add
label define migplac5lbl 542 "Turkey", add
label define migplac5lbl 543 "United Arab Emirates", add
label define migplac5lbl 544 "Yemen", add
label define migplac5lbl 548 "Southwest Asia, nec/ns", add
label define migplac5lbl 599 "Asia, nec/ns", add
label define migplac5lbl 600 "Africa", add
label define migplac5lbl 610 "Northern Africa", add
label define migplac5lbl 612 "Egypt/United Arab Rep.", add
label define migplac5lbl 670 "Central Africa", add
label define migplac5lbl 690 "Southern Africa", add
label define migplac5lbl 694 "South Africa (Union of)", add
label define migplac5lbl 699 "Africa, nec", add
label define migplac5lbl 700 "Coral Sea Islands", add
label define migplac5lbl 701 "Australia", add
label define migplac5lbl 702 "New Zealand", add
label define migplac5lbl 710 "Pacific Islands", add
label define migplac5lbl 715 "US Pacific Trust Territories", add
label define migplac5lbl 800 "Heard and McDonald Islands", add
label define migplac5lbl 900 "Abroad (unknown) or at sea", add
label define migplac5lbl 911 "Abroad, ns", add
label define migplac5lbl 912 "At sea", add
label define migplac5lbl 990 "Same house", add
label define migplac5lbl 999 "Missing/unknown", add
label values migplac5 migplac5lbl

label define migmet5lbl 0000 "N/A (household does not reside in a SMA)", add
label define migmet5lbl 0040 "Abilene, TX", add
label define migmet5lbl 0060 "Aguadilla, Puerto Rico", add
label define migmet5lbl 0080 "Akron, OH", add
label define migmet5lbl 0120 "Albany, GA", add
label define migmet5lbl 0160 "Albany-Schenectady-Troy, NY", add
label define migmet5lbl 0200 "Albuquerque, NM", add
label define migmet5lbl 0220 "Alexandria, LA", add
label define migmet5lbl 0240 "Allentown-Bethlehem-Easton, PA/NJ", add
label define migmet5lbl 0280 "Altoona, PA", add
label define migmet5lbl 0320 "Amarillo, TX", add
label define migmet5lbl 0380 "Anchorage, AK", add
label define migmet5lbl 0400 "Anderson, IN", add
label define migmet5lbl 0440 "Ann Arbor, MI", add
label define migmet5lbl 0450 "Anniston, AL", add
label define migmet5lbl 0460 "Appleton-Oskosh-Neenah, WI", add
label define migmet5lbl 0470 "Arecibo, Puerto Rico", add
label define migmet5lbl 0480 "Asheville, NC", add
label define migmet5lbl 0500 "Athens, GA", add
label define migmet5lbl 0520 "Atlanta, GA", add
label define migmet5lbl 0560 "Atlantic City, NJ", add
label define migmet5lbl 0580 "Auburn-Opelika, AL", add
label define migmet5lbl 0600 "Augusta-Aiken, GA-SC", add
label define migmet5lbl 0640 "Austin, TX", add
label define migmet5lbl 0680 "Bakersfield, CA", add
label define migmet5lbl 0720 "Baltimore, MD", add
label define migmet5lbl 0730 "Bangor, ME", add
label define migmet5lbl 0740 "Barnstable-Yarmouth, MA", add
label define migmet5lbl 0760 "Baton Rouge, LA", add
label define migmet5lbl 0780 "Battle Creek, MI", add
label define migmet5lbl 0840 "Beaumont-Port Arthur-Orange,TX", add
label define migmet5lbl 0860 "Bellingham, WA", add
label define migmet5lbl 0870 "Benton Harbor, MI", add
label define migmet5lbl 0880 "Billings, MT", add
label define migmet5lbl 0920 "Biloxi-Gulfport, MS", add
label define migmet5lbl 0960 "Binghamton, NY", add
label define migmet5lbl 1000 "Birmingham, AL", add
label define migmet5lbl 1010 "Bismarck,ND", add
label define migmet5lbl 1020 "Bloomington, IN", add
label define migmet5lbl 1040 "Bloomington-Normal, IL", add
label define migmet5lbl 1080 "Boise City, ID", add
label define migmet5lbl 1120 "Boston, MA", add
label define migmet5lbl 1121 "Lawrence-Haverhill, MA/NH", add
label define migmet5lbl 1122 "Lowell, MA/NH", add
label define migmet5lbl 1123 "Salem-Gloucester, MA", add
label define migmet5lbl 1140 "Bradenton, FL", add
label define migmet5lbl 1150 "Bremerton, WA", add
label define migmet5lbl 1160 "Bridgeport, CT", add
label define migmet5lbl 1200 "Brockton, MA", add
label define migmet5lbl 1240 "Brownsville-Harlingen-San Benito, TX", add
label define migmet5lbl 1260 "Bryan-College Station, TX", add
label define migmet5lbl 1280 "Buffalo-Niagara Falls, NY", add
label define migmet5lbl 1281 "Niagara Falls, NY", add
label define migmet5lbl 1290 "Caguas, PR", add
label define migmet5lbl 1300 "Burlington, NC", add
label define migmet5lbl 1310 "Burlington, VT", add
label define migmet5lbl 1320 "Canton, OH", add
label define migmet5lbl 1350 "Casper, WY", add
label define migmet5lbl 1360 "Cedar Rapids, IA", add
label define migmet5lbl 1400 "Champaign-Urbana-Rantoul, IL", add
label define migmet5lbl 1440 "Charleston-N.Charleston,SC", add
label define migmet5lbl 1480 "Charleston, WV", add
label define migmet5lbl 1520 "Charlotte-Gastonia-Rock Hill, SC", add
label define migmet5lbl 1521 "Rock Hill, SC", add
label define migmet5lbl 1540 "Charlottesville, VA", add
label define migmet5lbl 1560 "Chattanooga, TN/GA", add
label define migmet5lbl 1580 "Cheyenne, WY", add
label define migmet5lbl 1600 "Chicago-Gary-Lake, IL", add
label define migmet5lbl 1601 "Aurora-Elgin, IL", add
label define migmet5lbl 1602 "Gary-Hammond-East Chicago, IN", add
label define migmet5lbl 1603 "Joliet IL", add
label define migmet5lbl 1604 "Lake County, IL", add
label define migmet5lbl 1620 "Chico, CA", add
label define migmet5lbl 1640 "Cincinnati OH/KY/IN", add
label define migmet5lbl 1660 "Clarksville-Hopkinsville, TN/KY", add
label define migmet5lbl 1680 "Cleveland, OH", add
label define migmet5lbl 1720 "Colorado Springs, CO", add
label define migmet5lbl 1740 "Columbia, MO", add
label define migmet5lbl 1760 "Columbia, SC", add
label define migmet5lbl 1800 "Columbus, GA/AL", add
label define migmet5lbl 1840 "Columbus, OH", add
label define migmet5lbl 1880 "Corpus Christi, TX", add
label define migmet5lbl 1900 "Cumberland, MD/WV", add
label define migmet5lbl 1920 "Dallas-Fort Worth, TX", add
label define migmet5lbl 1921 "Fort Worth-Arlington, TX", add
label define migmet5lbl 1930 "Danbury, CT", add
label define migmet5lbl 1950 "Danville, VA", add
label define migmet5lbl 1960 "Davenport, IA Rock Island-Moline, IL", add
label define migmet5lbl 2000 "Dayton-Springfield, OH", add
label define migmet5lbl 2001 "Springfield, OH", add
label define migmet5lbl 2020 "Daytona Beach, FL", add
label define migmet5lbl 2030 "Decatur, AL", add
label define migmet5lbl 2040 "Decatur, IL", add
label define migmet5lbl 2080 "Denver-Boulder-Longmont, CO", add
label define migmet5lbl 2081 "Boulder-Longmont, CO", add
label define migmet5lbl 2120 "Des Moines, IA", add
label define migmet5lbl 2160 "Detroit, MI", add
label define migmet5lbl 2180 "Dothan, AL", add
label define migmet5lbl 2190 "Dover, DE", add
label define migmet5lbl 2200 "Dubuque, IA", add
label define migmet5lbl 2240 "Duluth-Superior, MN/WI", add
label define migmet5lbl 2281 "Dutchess Co., NY", add
label define migmet5lbl 2290 "Eau Claire, WI", add
label define migmet5lbl 2310 "El Paso, TX", add
label define migmet5lbl 2320 "Elkhart-Goshen, IN", add
label define migmet5lbl 2330 "Elmira, NY", add
label define migmet5lbl 2340 "Enid, OK", add
label define migmet5lbl 2360 "Erie, PA", add
label define migmet5lbl 2400 "Eugene-Springfield, OR", add
label define migmet5lbl 2440 "Evansville, IN/KY", add
label define migmet5lbl 2520 "Fargo-Morehead, ND/MN", add
label define migmet5lbl 2560 "Fayetteville, NC", add
label define migmet5lbl 2580 "Fayetteville-Springdale, AR", add
label define migmet5lbl 2600 "Fitchburg-Leominster, MA", add
label define migmet5lbl 2620 "Flagstaff, AZ", add
label define migmet5lbl 2640 "Flint, MI", add
label define migmet5lbl 2650 "Florence, AL", add
label define migmet5lbl 2660 "Florence, SC", add
label define migmet5lbl 2670 "Fort Collins-Loveland, CO", add
label define migmet5lbl 2680 "Fort Lauderdale-Hollywood-Pompano Beach, FL", add
label define migmet5lbl 2700 "Fort Myers-Cape Coral, FL", add
label define migmet5lbl 2710 "Fort Pierce, FL", add
label define migmet5lbl 2720 "Fort Smith, AR/OK", add
label define migmet5lbl 2750 "Fort Walton Beach, FL", add
label define migmet5lbl 2760 "Fort Wayne, IN", add
label define migmet5lbl 2840 "Fresno, CA", add
label define migmet5lbl 2880 "Gadsden, AL", add
label define migmet5lbl 2900 "Gainesville, FL", add
label define migmet5lbl 2920 "Galveston-Texas City, TX", add
label define migmet5lbl 2970 "Glens Falls, NY", add
label define migmet5lbl 2980 "Goldsboro, NC", add
label define migmet5lbl 2990 "Grand Forks, ND/MN", add
label define migmet5lbl 3000 "Grand Rapids, MI", add
label define migmet5lbl 3040 "Great Falls, MT", add
label define migmet5lbl 3060 "Greeley, CO", add
label define migmet5lbl 3080 "Green Bay, WI", add
label define migmet5lbl 3120 "Greensboro-Winston Salem-High Point, NC", add
label define migmet5lbl 3121 "Winston-Salem, NC", add
label define migmet5lbl 3150 "Greenville, NC", add
label define migmet5lbl 3160 "Greenville-Spartanburg-Anderson SC", add
label define migmet5lbl 3161 "Anderson, SC", add
label define migmet5lbl 3180 "Hagerstown, MD", add
label define migmet5lbl 3200 "Hamilton-Middleton, OH", add
label define migmet5lbl 3240 "Harrisburg-Lebanon-Carlisle, PA", add
label define migmet5lbl 3280 "Hartford-Bristol-Middleton-New Britain, CT", add
label define migmet5lbl 3281 "Bristol, CT", add
label define migmet5lbl 3283 "New Britain, CT", add
label define migmet5lbl 3290 "Hickory-Morgantown, NC", add
label define migmet5lbl 3300 "Hattiesburg, MS", add
label define migmet5lbl 3320 "Honolulu, HI", add
label define migmet5lbl 3350 "Houma-Thibodoux, LA", add
label define migmet5lbl 3360 "Houston-Brazoria, TX", add
label define migmet5lbl 3361 "Brazoria, TX", add
label define migmet5lbl 3400 "Huntington-Ashland, WV/KY/OH", add
label define migmet5lbl 3440 "Huntsville, AL", add
label define migmet5lbl 3480 "Indianapolis, IN", add
label define migmet5lbl 3500 "Iowa City, IA", add
label define migmet5lbl 3520 "Jackson, MI", add
label define migmet5lbl 3560 "Jackson, MS", add
label define migmet5lbl 3580 "Jackson, TN", add
label define migmet5lbl 3590 "Jacksonville, FL", add
label define migmet5lbl 3600 "Jacksonville, NC", add
label define migmet5lbl 3610 "Jamestown-Dunkirk, NY", add
label define migmet5lbl 3620 "Janesville-Beloit, WI", add
label define migmet5lbl 3660 "Johnson City-Kingsport-Bristol, TN/VA", add
label define migmet5lbl 3680 "Johnstown, PA", add
label define migmet5lbl 3710 "Joplin, MO", add
label define migmet5lbl 3720 "Kalamazoo-Portage, MI", add
label define migmet5lbl 3740 "Kankakee, IL", add
label define migmet5lbl 3760 "Kansas City, MO-KS", add
label define migmet5lbl 3800 "Kenosha, WI", add
label define migmet5lbl 3810 "Kileen-Temple, TX", add
label define migmet5lbl 3840 "Knoxville, TN", add
label define migmet5lbl 3850 "Kokomo, IN", add
label define migmet5lbl 3870 "LaCrosse, WI", add
label define migmet5lbl 3880 "Lafayette, LA", add
label define migmet5lbl 3920 "Lafayette-W. Lafayette, IN", add
label define migmet5lbl 3960 "Lake Charles, LA", add
label define migmet5lbl 3980 "Lakeland-Winterhaven, FL", add
label define migmet5lbl 4000 "Lancaster, PA", add
label define migmet5lbl 4040 "Lansing-E. Lansing, MI", add
label define migmet5lbl 4080 "Laredo, TX", add
label define migmet5lbl 4100 "Las Cruces, NM", add
label define migmet5lbl 4120 "Las Vegas, NV", add
label define migmet5lbl 4200 "Lawton, OK", add
label define migmet5lbl 4240 "Lewiston-Auburn, ME", add
label define migmet5lbl 4280 "Lexington-Fayette, KY", add
label define migmet5lbl 4320 "Lima, OH", add
label define migmet5lbl 4360 "Lincoln, NE", add
label define migmet5lbl 4400 "Little Rock-North Little Rock, AR", add
label define migmet5lbl 4410 "Long Branch-Asbury Park,NJ", add
label define migmet5lbl 4420 "Longview-Marshall, TX", add
label define migmet5lbl 4440 "Lorain-Elyria, OH", add
label define migmet5lbl 4480 "Los Angeles-Long Beach, CA", add
label define migmet5lbl 4481 "Anaheim-Santa Ana-Garden Grove, CA", add
label define migmet5lbl 4482 "Orange County, CA", add
label define migmet5lbl 4520 "Louisville, KY/IN", add
label define migmet5lbl 4600 "Lubbock, TX", add
label define migmet5lbl 4640 "Lynchburg, VA", add
label define migmet5lbl 4680 "Macon-Warner Robins, GA", add
label define migmet5lbl 4720 "Madison, WI", add
label define migmet5lbl 4760 "Manchester, NH", add
label define migmet5lbl 4800 "Mansfield, OH", add
label define migmet5lbl 4840 "Mayaguez, Puerto Rico", add
label define migmet5lbl 4880 "McAllen-Edinburg-Pharr-Mission, TX", add
label define migmet5lbl 4890 "Medford, OR", add
label define migmet5lbl 4900 "Melbourne-Titusville-Cocoa-Palm Bay, FL", add
label define migmet5lbl 4920 "Memphis, TN/AR/MS", add
label define migmet5lbl 4940 "Merced, CA", add
label define migmet5lbl 5000 "Miami-Hialeah, FL", add
label define migmet5lbl 5040 "Midland, TX", add
label define migmet5lbl 5080 "Milwaukee, WI", add
label define migmet5lbl 5120 "Minneapolis-St. Paul, MN", add
label define migmet5lbl 5160 "Mobile, AL", add
label define migmet5lbl 5170 "Modesto, CA", add
label define migmet5lbl 5190 "Monmouth-Ocean, NJ", add
label define migmet5lbl 5200 "Monroe, LA", add
label define migmet5lbl 5240 "Montgomery, AL", add
label define migmet5lbl 5280 "Muncie, IN", add
label define migmet5lbl 5320 "Muskegon-Norton Shores-Muskegon Heights, MI", add
label define migmet5lbl 5330 "Myrtle Beach, SC", add
label define migmet5lbl 5340 "Naples, FL", add
label define migmet5lbl 5350 "Nashua, NH", add
label define migmet5lbl 5360 "Nashville, TN", add
label define migmet5lbl 5400 "New Bedford, MA", add
label define migmet5lbl 5460 "New Brunswick-Perth Amboy-Sayreville, NJ", add
label define migmet5lbl 5480 "New Haven-Meriden, CT", add
label define migmet5lbl 5520 "New London-Norwich, CT/RI", add
label define migmet5lbl 5560 "New Orleans, LA", add
label define migmet5lbl 5600 "New York-Northeastern NJ", add
label define migmet5lbl 5601 "Nassau Co, NY", add
label define migmet5lbl 5602 "Bergen-Passaic, NJ", add
label define migmet5lbl 5603 "Jersey City, NJ", add
label define migmet5lbl 5604 "Middlesex-Somerset-Hunterdon, NJ", add
label define migmet5lbl 5605 "Newark, NJ", add
label define migmet5lbl 5640 "Newark, OH", add
label define migmet5lbl 5660 "Newburgh-Middletown, NY", add
label define migmet5lbl 5720 "Norfolk-VA Beach-Newport News, VA", add
label define migmet5lbl 5760 "Norwalk, CT", add
label define migmet5lbl 5790 "Ocala, FL", add
label define migmet5lbl 5800 "Odessa, TX", add
label define migmet5lbl 5880 "Oklahoma City, OK", add
label define migmet5lbl 5910 "Olympia, WA", add
label define migmet5lbl 5920 "Omaha, NE/IA", add
label define migmet5lbl 5950 "Orange, NY", add
label define migmet5lbl 5960 "Orlando, FL", add
label define migmet5lbl 5990 "Owensboro, KY", add
label define migmet5lbl 6010 "Panama City, FL", add
label define migmet5lbl 6020 "Parkersburg-Marietta,WV/OH", add
label define migmet5lbl 6030 "Pascagoula-Moss Point, MS", add
label define migmet5lbl 6080 "Pensacola, FL", add
label define migmet5lbl 6120 "Peoria, IL", add
label define migmet5lbl 6160 "Philadelphia, PA/NJ", add
label define migmet5lbl 6200 "Phoenix, AZ", add
label define migmet5lbl 6240 "Pine Bluff, AR", add
label define migmet5lbl 6280 "Pittsburgh-Beaver Valley, PA", add
label define migmet5lbl 6320 "Pittsfield, MA", add
label define migmet5lbl 6360 "Ponce, Puerto Rico", add
label define migmet5lbl 6400 "Portland, ME", add
label define migmet5lbl 6440 "Portland-Vancouver, OR", add
label define migmet5lbl 6441 "Vancouver, WA", add
label define migmet5lbl 6450 "Portsmouth-Dover-Rochester, NH/ME", add
label define migmet5lbl 6460 "Poughkeepsie, NY", add
label define migmet5lbl 6480 "Providence-Fall River-Pawtucket, MA/RI", add
label define migmet5lbl 6481 "Fall River, MA/RI", add
label define migmet5lbl 6482 "Pawtuckett-Woonsocket-Attleboro, RI/MA", add
label define migmet5lbl 6520 "Provo-Orem, UT", add
label define migmet5lbl 6560 "Pueblo, CO", add
label define migmet5lbl 6580 "Punta Gorda, FL", add
label define migmet5lbl 6600 "Racine, WI", add
label define migmet5lbl 6640 "Raleigh-Durham, NC", add
label define migmet5lbl 6641 "Durham, NC", add
label define migmet5lbl 6660 "Rapid City, SD", add
label define migmet5lbl 6680 "Reading, PA", add
label define migmet5lbl 6690 "Redding, CA", add
label define migmet5lbl 6720 "Reno, NV", add
label define migmet5lbl 6740 "Richland-Kennewick-Pasco, WA", add
label define migmet5lbl 6760 "Richmond-Petersburg, VA", add
label define migmet5lbl 6761 "Petersburg-Colonial Heights, VA", add
label define migmet5lbl 6780 "Riverside-San Bernadino, CA", add
label define migmet5lbl 6781 "San Bernadino, CA", add
label define migmet5lbl 6800 "Roanoke, VA", add
label define migmet5lbl 6820 "Rochester, MN", add
label define migmet5lbl 6840 "Rochester, NY", add
label define migmet5lbl 6880 "Rockford, IL", add
label define migmet5lbl 6895 "Rocky Mount, NC", add
label define migmet5lbl 6920 "Sacramento, CA", add
label define migmet5lbl 6960 "Saginaw-Bay City-Midland, MI", add
label define migmet5lbl 6961 "Bay City, MI", add
label define migmet5lbl 6980 "St. Cloud, MN", add
label define migmet5lbl 7000 "St. Joseph, MO", add
label define migmet5lbl 7040 "St. Louis, MO-IL", add
label define migmet5lbl 7080 "Salem, OR", add
label define migmet5lbl 7120 "Salinas-Sea Side-Monterey, CA", add
label define migmet5lbl 7140 "Salisbury-Concord, NC", add
label define migmet5lbl 7160 "Salt Lake City-Ogden, UT", add
label define migmet5lbl 7161 "Ogden", add
label define migmet5lbl 7200 "San Angelo, TX", add
label define migmet5lbl 7240 "San Antonio, TX", add
label define migmet5lbl 7320 "San Diego, CA", add
label define migmet5lbl 7360 "San Francisco-Oakland-Vallejo, CA", add
label define migmet5lbl 7361 "Oakland, CA", add
label define migmet5lbl 7362 "Vallejo-Fairfield-Napa, CA", add
label define migmet5lbl 7400 "San Jose, CA", add
label define migmet5lbl 7440 "San Juan-Bayamon, Puerto Rico", add
label define migmet5lbl 7460 "San Luis Obispo-Atascad-P Robles, CA", add
label define migmet5lbl 7470 "Santa Barbara-Santa Maria-Lompoc, CA", add
label define migmet5lbl 7480 "Santa Cruz, CA", add
label define migmet5lbl 7490 "Santa Fe, NM", add
label define migmet5lbl 7500 "Santa Rosa-Petaluma, CA", add
label define migmet5lbl 7510 "Sarasota, FL", add
label define migmet5lbl 7520 "Savannah, GA", add
label define migmet5lbl 7560 "Scranton-Wilkes-Barre, PA", add
label define migmet5lbl 7561 "Wilkes-Barre-Hazelton, PA", add
label define migmet5lbl 7600 "Seattle-Everett, WA", add
label define migmet5lbl 7610 "Sharon, PA", add
label define migmet5lbl 7620 "Sheboygan, WI", add
label define migmet5lbl 7640 "Sherman-Denison, TX", add
label define migmet5lbl 7680 "Shreveport, LA", add
label define migmet5lbl 7720 "Sioux City, IA/NE", add
label define migmet5lbl 7760 "Sioux Falls, SD", add
label define migmet5lbl 7800 "South Bend-Mishawaka, IN", add
label define migmet5lbl 7840 "Spokane, WA", add
label define migmet5lbl 7880 "Springfield, IL", add
label define migmet5lbl 7920 "Springfield, MO", add
label define migmet5lbl 8000 "Springfield-Holyoke-Chicopee, MA", add
label define migmet5lbl 8040 "Stamford, CT", add
label define migmet5lbl 8050 "State College, PA", add
label define migmet5lbl 8080 "Steubenville-Weirton,OH/WV", add
label define migmet5lbl 8120 "Stockton, CA", add
label define migmet5lbl 8140 "Sumter, SC", add
label define migmet5lbl 8160 "Syracuse, NY", add
label define migmet5lbl 8200 "Tacoma, WA", add
label define migmet5lbl 8240 "Tallahassee, FL", add
label define migmet5lbl 8280 "Tampa-St. Petersburg-Clearwater, FL", add
label define migmet5lbl 8320 "Terre Haute, IN", add
label define migmet5lbl 8360 "Texarkana, TX/AR", add
label define migmet5lbl 8400 "Toledo, OH/MI", add
label define migmet5lbl 8440 "Topeka, KS", add
label define migmet5lbl 8480 "Trenton, NJ", add
label define migmet5lbl 8520 "Tucson, AZ", add
label define migmet5lbl 8560 "Tulsa, OK", add
label define migmet5lbl 8600 "Tuscaloosa, AL", add
label define migmet5lbl 8640 "Tyler, TX", add
label define migmet5lbl 8680 "Utica-Rome, NY", add
label define migmet5lbl 8730 "Ventura-Oxnard-Simi Valley, CA", add
label define migmet5lbl 8750 "Victoria, TX", add
label define migmet5lbl 8760 "Vineland-Milville-Bridgetown, NJ", add
label define migmet5lbl 8780 "Visalia-Tulare-Porterville, CA", add
label define migmet5lbl 8800 "Waco, TX", add
label define migmet5lbl 8840 "Washington, DC/MD/VA", add
label define migmet5lbl 8880 "Waterbury, CT", add
label define migmet5lbl 8920 "Waterloo-Cedar Falls, IA", add
label define migmet5lbl 8940 "Wausau, WI", add
label define migmet5lbl 8960 "West Palm Beach-Boca Raton-Delray Beach, FL", add
label define migmet5lbl 9000 "Wheeling, WV/OH", add
label define migmet5lbl 9040 "Wichita, KS", add
label define migmet5lbl 9080 "Wichita Falls, TX", add
label define migmet5lbl 9140 "Williamsport, PA", add
label define migmet5lbl 9160 "Wilmington, DE/NJ/MD", add
label define migmet5lbl 9200 "Wilmington, NC", add
label define migmet5lbl 9240 "Worcester, MA", add
label define migmet5lbl 9260 "Yakima, WA", add
label define migmet5lbl 9270 "Yolo, CA", add
label define migmet5lbl 9280 "York, PA", add
label define migmet5lbl 9320 "Youngstown-Warren, OH-PA", add
label define migmet5lbl 9340 "Yuba City, CA", add
label define migmet5lbl 9360 "Yuma, AZ", add
label define migmet5lbl 9990 "SMA not identified for confidentiality reasons", add
label values migmet5 migmet5lbl

label define migtype5lbl 0 "N/A"
label define migtype5lbl 1 "Not in metro area", add
label define migtype5lbl 2 "In a metro area, central city status unknown", add
label define migtype5lbl 3 "Central city", add
label define migtype5lbl 4 "Not central city", add
label define migtype5lbl 9 "Unknown", add
label values migtype5 migtype5lbl

label define samemet5lbl 0 "N/A", add
label define samemet5lbl 1 "In metro, and in same metro in reference year", add
label define samemet5lbl 2 "In metro, and in different metro in the reference year", add
label define samemet5lbl 3 "Not in a metro in the reference year", add
label define samemet5lbl 4 "In an metro in the reference year", add
label define samemet5lbl 5 "Not in an metro in the reference year", add
label define samemet5lbl 9 "Unknown", add
label values samemet5 samemet5lbl

label define movedinlbl 0 "N/A", add
label define movedinlbl 1 "This year or last year", add
label define movedinlbl 2 "2 years ago", add
label define movedinlbl 3 "3 years ago", add
label define movedinlbl 4 "4-6 (1960)", add
label define movedinlbl 5 "7-10 (1960)", add
label define movedinlbl 6 "11-20", add
label define movedinlbl 7 "21+", add
label define movedinlbl 8 "31+", add
label define movedinlbl 9 "Always lived here", add
label values movedin movedinlbl

label define tranworklbl 00 "N/A (+ not reported 1960)", add
label define tranworklbl 10 "Auto, truck, or van", add
label define tranworklbl 11 "Auto", add
label define tranworklbl 12 "Driver", add
label define tranworklbl 13 "Passenger", add
label define tranworklbl 14 "Truck", add
label define tranworklbl 15 "Van", add
label define tranworklbl 20 "Motorcycle", add
label define tranworklbl 30 "Bus or streetcar", add
label define tranworklbl 31 "Bus or trolley bus", add
label define tranworklbl 32 "Streetcar or trolley car", add
label define tranworklbl 33 "Subway or elevated", add
label define tranworklbl 34 "Railroad", add
label define tranworklbl 35 "Taxicab", add
label define tranworklbl 36 "Ferryboat", add
label define tranworklbl 40 "Bicycle", add
label define tranworklbl 50 "Walked only", add
label define tranworklbl 60 "Other", add
label define tranworklbl 70 "Worked at home", add
label values tranwork tranworklbl

label define carpoollbl 0 "N/A"
label define carpoollbl 1 "Drives alone", add
label define carpoollbl 2 "Carpools", add
label define carpoollbl 3 "Shares driving", add
label define carpoollbl 4 "Drives others only", add
label define carpoollbl 5 "Passenger only", add
label values carpool carpoollbl

label values trantime trantimelbl

label data "IPUMS Census Data, 1970-2000"
save jdgottl_fas_harvard_edu_010.dta, replace

gen rand = uniform()
keep if rand < 0.001
drop rand
label data "IPUMS 0.1% subsample"
save jdgottl_fas_harvard_edu_010_001.dta, replace

